/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.web.jsf.integration.config;

import javax.faces.validator.BeanValidator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.jboss.logging.Logger;
import org.jboss.mc.servlet.vdf.spi.VDFConnector;
import org.jboss.web.validation.ValidatorFactoryVDFConnector;


/**
 * This ServletContextListener adds the BeanValidationFactory needed to
 * use the JSF 2.0 BeanValidator.
 *
 * @author Stan Silvert
 * @author Ales Justin
 */
public class JBossMojarra20ConfigureListener extends JBossMojarraConfigureListener
{
    private static Logger LOG = Logger.getLogger(JBossMojarra20ConfigureListener.class);

    @Override
    public void doVersionSpecificInitialization()
    {
       addBeanValidatorFactory();
    }

    protected void addBeanValidatorFactory()
    {
       VDFConnector<ValidatorFactory> vfc = new ValidatorFactoryVDFConnector(servletContext);

       ValidatorFactory factory;
       if (vfc.isValid())
       {
          factory = vfc.getUtility();
       }
       else
       {
          LOG.warn("No such ValidatorFactory in VDF layer, creating new instance.");
          factory = Validation.buildDefaultValidatorFactory();
       }

       servletContext.setAttribute(BeanValidator.VALIDATOR_FACTORY_KEY, factory);
    }

}
