/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import com.sun.faces.config.ConfigureListener;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRegistration;

public abstract class JBossMojarraConfigureListener
extends ConfigureListener {
    protected ServletContext servletContext;
    protected boolean initialized = false;

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        JBossMojarraConfigureListener.initializeJspRuntime();
        this.addFacesMappings();
        this.doVersionSpecificInitialization();
        super.contextInitialized(event);
        this.initialized = true;
    }

    public abstract void doVersionSpecificInitialization();

    public void contextDestroyed(ServletContextEvent event) {
        if (this.initialized) {
            super.contextDestroyed(event);
            this.initialized = false;
        }
    }

    private void addFacesMappings() {
        if (this.hasJSFServlet()) {
            return;
        }
        ServletRegistration.Dynamic facesServlet = this.servletContext.addServlet("FacesServlet", "javax.faces.webapp.FacesServlet");
        facesServlet.addMapping(new String[]{"/faces/*", "*.jsf", "*.faces"});
        this.servletContext.setAttribute("com.sun.faces.facesInitializerMappingsAdded", (Object)Boolean.TRUE);
    }

    private boolean hasJSFServlet() {
        Map servletRegistrations = this.servletContext.getServletRegistrations();
        for (ServletRegistration registration : servletRegistrations.values()) {
            if (!"javax.faces.webapp.FacesServlet".equals(registration.getClassName())) continue;
            return true;
        }
        return false;
    }

    private static void initializeJspRuntime() {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

