/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.ant;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.cargo.module.webapp.WebXml;
import org.jboss.jsfunit.ant.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUnitWarTask
extends Task {
    private String containerId = "";
    private File srcfile;
    private File destfile;
    private List<JSFUnitFilter> jsfFilters = new ArrayList<JSFUnitFilter>();
    private List<FileSet> libs = new ArrayList<FileSet>();
    private List<FileSet> classes = new ArrayList<FileSet>();
    private Boolean autoAddJars = true;
    private List<JSFUnitTestRunnerFilter> testRunnerFilters = new ArrayList<JSFUnitTestRunnerFilter>();

    public void setContainer(String containerId) {
        this.containerId = containerId;
        if (containerId.equals("jboss6x")) {
            this.containerId = "jboss5x";
        }
    }

    public void setSrcfile(File srcfile) {
        this.srcfile = srcfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void addLib(FileSet libFileSet) {
        this.libs.add(libFileSet);
    }

    public void addClasses(FileSet classesFileSet) {
        this.classes.add(classesFileSet);
    }

    public void setAutoAddJars(Boolean autoAddJars) {
        this.autoAddJars = autoAddJars;
    }

    public void addJSFUnitFilter(JSFUnitFilter jsfFilter) {
        this.jsfFilters.add(jsfFilter);
    }

    public void addTestRunner(JSFUnitTestRunnerFilter testRunnerFilter) {
        this.testRunnerFilters.add(testRunnerFilter);
    }

    public void execute() {
        if (this.srcfile == null) {
            throw new BuildException("A srcfile must be specified");
        }
        if (this.destfile == null) {
            throw new BuildException("A destfile must be specified");
        }
        if (this.destfile.equals(this.srcfile)) {
            throw new BuildException("The destfile and srcfile must not be the same");
        }
        this.log("using srcfile :" + this.srcfile, 4);
        if (this.srcfile.isDirectory()) {
            this.log("srcfile is a directory", 4);
            this.JSFUnitExplodedWar();
        } else if (this.srcfile.isFile()) {
            this.log("srcfile is a file", 4);
            this.JSFUnitWar();
        } else {
            throw new BuildException("Cannot find specifiec srcfile : " + this.srcfile);
        }
    }

    private void JSFUnitExplodedWar() {
        try {
            Utils.copy(this.srcfile, this.destfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e.getMessage(), 0);
        }
        try {
            WebXml webxml = this.getWebXml(this.destfile);
            webxml = this.editWebXml(webxml);
            this.writeWebXml(this.destfile, webxml);
            this.addLibs(this.destfile);
            this.autoAddLibs(this.destfile);
            this.addClasses(this.destfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e.getMessage(), 0);
        }
    }

    private WebXml getWebXml(File archiveRoot) throws SAXException, IOException, ParserConfigurationException {
        String webXMLLocation = archiveRoot.getPath() + File.separator + "WEB-INF" + File.separator + "web.xml";
        File webXMLFile = new File(webXMLLocation);
        if (!webXMLFile.exists()) {
            throw new BuildException("No web xml descriptor : " + webXMLLocation);
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document webxmlDoc = docBuilder.parse(webXMLFile);
        WebXml webxml = new WebXml(webxmlDoc);
        return webxml;
    }

    private void writeWebXml(File archiveRoot, WebXml webxml) throws IOException {
        String webXMLLocation = archiveRoot.getPath() + File.separator + "WEB-INF" + File.separator + "web.xml";
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        XMLSerializer xmlSerializer = new XMLSerializer(format);
        xmlSerializer.setOutputCharStream(new FileWriter(webXMLLocation));
        xmlSerializer.serialize(webxml.getDocument());
    }

    private void JSFUnitWar() {
        try {
            File tmpDir = File.createTempFile("jsfunitwartask", "");
            tmpDir.delete();
            tmpDir.mkdir();
            ZipFile zip = new ZipFile(this.srcfile);
            File explodedArchive = Utils.explodeArchive(zip, tmpDir);
            WebXml webXml = this.getWebXml(explodedArchive);
            this.editWebXml(webXml);
            this.writeWebXml(explodedArchive, webXml);
            this.addLibs(explodedArchive);
            this.autoAddLibs(explodedArchive);
            this.addClasses(explodedArchive);
            Utils.archive(explodedArchive, this.destfile);
        }
        catch (Exception e) {
            this.log(e.getMessage(), 0);
            e.printStackTrace();
        }
    }

    private WebXml editWebXml(WebXml webXml) {
        if (this.jsfFilters.isEmpty()) {
            this.jsfFilters.add(new JSFUnitFilter());
        }
        Iterator<Filter> i = this.jsfFilters.iterator();
        while (i.hasNext()) {
            i.next().addFilter(webXml);
        }
        i = this.testRunnerFilters.iterator();
        while (i.hasNext()) {
            ((JSFUnitTestRunnerFilter)i.next()).addFilter(webXml);
        }
        return webXml;
    }

    private void addFilesToArchive(File archiveRoot, String directoryName, List<FileSet> fileSets) throws Exception {
        if (!fileSets.isEmpty()) {
            File directory = new File(archiveRoot.getPath() + File.separator + directoryName);
            if (!directory.exists()) {
                directory.mkdir();
            } else if (!directory.isDirectory()) {
                throw new Exception("The " + directoryName + " directory for the archive is not a directory");
            }
            for (FileSet fileSet : fileSets) {
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] files = directoryScanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File file = new File(fileSet.getDir(this.getProject()) + File.separator + files[j]);
                    File dest = new File(directory + File.separator + files[j]);
                    if (dest.getParentFile() != null) {
                        dest.getParentFile().mkdirs();
                    }
                    Utils.copy(file, dest);
                }
            }
        }
    }

    private void addLibs(File archiveRoot) throws Exception {
        String libsDirectory = "WEB-INF" + File.separator + "lib";
        this.addFilesToArchive(archiveRoot, libsDirectory, this.libs);
    }

    private void addClasses(File archiveRoot) throws Exception {
        String classesDirectory = "WEB-INF" + File.separator + "classes";
        this.addFilesToArchive(archiveRoot, classesDirectory, this.classes);
    }

    private void autoAddLibs(File archiveRoot) throws Exception {
        if (!this.autoAddJars.booleanValue()) {
            return;
        }
        this.log("Automatically adding JSFunit required jars to the new war", 2);
        String[][] classNames = new String[][]{{"/org/jboss/jsfunit/init/AllJSFUnitTests.class", "JSFUnit Catus 2.0 or higher"}, {"/org/jboss/jsfunit/context/NoNewEntryMap.class", "JSFUnit Core 2.0 or higher"}, {"/com/gargoylesoftware/htmlunit/AjaxController.class", "HTMLUnit 2.8 or higher"}, {"/org/apache/commons/codec/BinaryDecoder.class", "Commons Codec 1.4 or higher"}, {"/net/sourceforge/htmlunit/corejs/javascript/ScriptableObject.class", "HTMLUnitJavascript 2.8 or higher"}, {"/org/apache/commons/logging/Log.class", "Commons Logging 1.0.4 or higher"}, {"/org/apache/http/client/CredentialsProvider.class", "Apache HTTP Client 4.0.1 or higher"}, {"/org/apache/http/entity/mime/MIME.class", "Apache HTTP MIME 4.0.1 or higher"}, {"/org/apache/james/mime4j/message/Body.class", "Apache James mime4j 0.6 or higher"}, {"/org/apache/http/params/HttpParams.class", "Apache HTTP Core 4.0.1 or higher"}, {"/org/apache/commons/lang/ArrayUtils.class", "Commons Lang 2.4 or higher"}, {"/org/apache/commons/collections/ArrayStack.class", "Commons Collections 3.2.1 or higher"}, {"/org/apache/commons/io/FileUtils.class", "CommonsIO 1.4 or higher"}, {"/com/steadystate/css/parser/HandlerBase.class", "CSSParser 0.9.5 or higher"}, {"/org/w3c/css/sac/SACMediaList.class", "W3C SAC 1.3 or higher"}, {"/org/cyberneko/html/ObjectFactory.class", "NekoHTML 1.9.14 or higher"}, {"/org/apache/html/dom/CollectionIndex.class", "XercesImpl 2.8.1 or higher"}, {"/org/apache/xalan/extensions/ExpressionContext.class", "Xalan 2.7.0 or higher"}, {"/org/apache/cactus/Request.class", "Cactus 1.7.1 or higher"}, {"/org/apache/cactus/integration/ant/CactifyEarTask.class", "Cactus Ant 1.7.1 or higher"}, {"/junit/framework/Assert.class", "JUnit 3.8.1 or higher"}, {"/org/aspectj/runtime/CFlow.class", "AspectJ 1.2.1 or higher"}, {"/org/codehaus/cargo/ant/CargoTask.class", "Cargo 0.5 or higher"}, {"/org/apache/tools/ant/AntClassLoader.class", "Ant 1.5.4 or higher"}};
        for (int i = 0; i < classNames.length; ++i) {
            if (this.skipForJBoss5(classNames[i][1])) continue;
            try {
                File jar = ResourceUtils.getResourceLocation((String)classNames[i][0]);
                if (jar == null) {
                    this.log("Could not find the " + classNames[i][1] + " jar in the classpath. Cannot automatically add this jar to the war");
                    continue;
                }
                this.log("Auto-adding " + jar.getName());
                this.addLib(archiveRoot, jar);
                continue;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.log("Could not find " + classNames[i][0] + " class in the " + classNames[i][1] + " jar. Cannot automatically add this jar to the war");
            }
        }
    }

    private boolean skipForJBoss5(String libraryName) {
        if (!"jboss5x".equalsIgnoreCase(this.containerId)) {
            return false;
        }
        if (libraryName.startsWith("XercesImpl")) {
            return true;
        }
        return libraryName.startsWith("Xalan");
    }

    private void addLib(File archiveRoot, File libJar) throws Exception {
        if (!libJar.exists()) {
            throw new Exception("Can not find " + libJar.getName());
        }
        String libDirectoryName = archiveRoot.getPath() + File.separator + "WEB-INF" + File.separator + "lib";
        File libDir = new File(libDirectoryName);
        if (!libDir.exists()) {
            libDir.mkdir();
        }
        String libFileName = libDirectoryName + File.separator + libJar.getName();
        File destFile = new File(libFileName);
        Utils.copy(libJar, destFile);
    }

    public static class JSFUnitTestRunnerFilter
    extends Filter {
        private final String DEFAULT_NAME = "ServletTestFilter";
        private final String DEFAULT_MAPPING = "/ServletTestRunner";
        private final String DEFAULT_SERVLET_CLASS = "org.apache.cactus.server.runner.ServletTestRunner";
        private final String DEFAULT_FILTER_CLASS = "org.jboss.jsfunit.framework.JSFUnitFilter";

        public JSFUnitTestRunnerFilter() {
            this.name = "ServletTestFilter";
            this.mapping = "/ServletTestRunner";
            this.servletClass = "org.apache.cactus.server.runner.ServletTestRunner";
            this.filterClass = "org.jboss.jsfunit.framework.JSFUnitFilter";
            this.servletName = "ServletTestRunner";
        }
    }

    public static class JSFUnitFilter
    extends Filter {
        private final String DEFAULT_NAME = "JSFUnitFilter";
        private final String DEFAULT_MAPPING = "/ServletRedirector";
        private final String DEFAULT_SERVLET_CLASS = "org.jboss.jsfunit.framework.JSFUnitServletRedirector";
        private final String DEFAULT_FILTER_CLASS = "org.jboss.jsfunit.framework.JSFUnitFilter";

        public JSFUnitFilter() {
            this.name = "JSFUnitFilter";
            this.mapping = "/ServletRedirector";
            this.servletClass = "org.jboss.jsfunit.framework.JSFUnitServletRedirector";
            this.filterClass = "org.jboss.jsfunit.framework.JSFUnitFilter";
            this.servletName = "ServletRedirector";
        }
    }

    public static class Filter {
        protected String name;
        protected String mapping;
        protected String servletClass;
        protected String filterClass;
        protected String servletName;

        public void setName(String name) {
            this.name = name;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setServletClass(String servletClass) {
            this.servletClass = servletClass;
        }

        public void addFilter(WebXml webXml) {
            if (!webXml.hasServlet(this.servletName)) {
                webXml.addServlet(this.servletName, this.servletClass);
            }
            if (!webXml.hasFilter(this.name)) {
                webXml.addFilter(this.name, this.filterClass);
            }
            webXml.addServletMapping(this.servletName, this.mapping);
            webXml.addFilterMapping(this.name, this.mapping);
        }
    }
}

