/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession.hellojsf;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.context.FacesContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.framework.Environment;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.jsfsession.DuplicateClientIDException;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacadeAPITest
extends ServletTestCase {
    private JSFClientSession client;
    private JSFServerSession server;

    public void setUp() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/index.jsp");
        this.client = jsfSession.getJSFClientSession();
        this.server = jsfSession.getJSFServerSession();
    }

    public static Test suite() {
        return new TestSuite(FacadeAPITest.class);
    }

    public void testCustomBrowserVersion() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/jsf/index.jsp", BrowserVersion.INTERNET_EXPLORER_7);
        JSFSession jsfSession = new JSFSession(wcSpec);
        FacadeAPITest.assertEquals((Object)BrowserVersion.INTERNET_EXPLORER_7, (Object)jsfSession.getWebClient().getBrowserVersion());
    }

    public void testGetCurrentViewId() throws IOException {
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        FacadeAPITest.assertEquals((String)this.server.getCurrentViewID(), (String)this.server.getFacesContext().getViewRoot().getViewId());
    }

    public void testSetParamAndSubmit() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("submit_button");
        UIComponent greeting = this.server.findComponent("greeting");
        FacadeAPITest.assertTrue((boolean)greeting.isRendered());
    }

    public void testSetCheckbox() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("funcheck");
        this.client.click("submit_button");
        FacadeAPITest.assertFalse((boolean)((Boolean)this.server.getManagedBeanValue("#{checkbox.funCheck}")));
        this.client.click("funcheck");
        this.client.click("submit_button");
        FacadeAPITest.assertTrue((boolean)((Boolean)this.server.getManagedBeanValue("#{checkbox.funCheck}")));
    }

    public void testClickCommandLink() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("go_back_link");
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
    }

    public void testCommandLinkWithoutViewChange() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("stay_here_link");
        FacadeAPITest.assertEquals((String)"/finalgreeting.jsp", (String)this.server.getCurrentViewID());
    }

    public void testCommandLinkWithFParam() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("stay_here_link");
        String name = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("name");
        FacadeAPITest.assertEquals((String)"Stan", (String)name);
    }

    public void testCommandLinkWithParamFromLoopVariable() throws IOException {
        if (Environment.getJSFMajorVersion() == 1 && Environment.getJSFMinorVersion() < 2) {
            return;
        }
        JSFSession jsfSession = new JSFSession("/jsf/marathons.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        client.click("marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        client.click("marathonSelectj_id_3");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Flora London Marathon"));
        client.click("marathonSelectj_id_5");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Olympic Marathon"));
    }

    public void testCommandLinkWithParamFromDatatableVariable() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/marathons_datatable.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        client.click("3:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Flora London Marathon"));
        client.click("5:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Olympic Marathon"));
    }

    public void testInvalidateSession() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/marathons_datatable.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        FacadeAPITest.assertEquals((Object)"BAA Boston Marathon", (Object)server.getManagedBeanValue("#{marathons.selectedMarathon}"));
        client.click("invalidateSession");
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        FacadeAPITest.assertEquals((Object)"BAA Boston Marathon", (Object)server.getManagedBeanValue("#{marathons.selectedMarathon}"));
    }

    public void testServerSideComponentValue() throws IOException {
        this.testSetParamAndSubmit();
        FacadeAPITest.assertEquals((Object)"Hello Stan", (Object)this.server.getComponentValue("greeting"));
    }

    public void testManagedBeanValue() throws IOException {
        this.testSetParamAndSubmit();
        FacadeAPITest.assertEquals((Object)"Stan", (Object)this.server.getManagedBeanValue("#{foo.text}"));
    }

    public void testFacesMessages() throws IOException {
        this.client.setValue("input_foo_text", "A");
        this.client.click("submit_button");
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        Iterator allMessages = this.server.getFacesMessages();
        allMessages.next();
        FacadeAPITest.assertFalse((boolean)allMessages.hasNext());
        Iterator checkboxMessages = this.server.getFacesMessages("funcheck");
        FacadeAPITest.assertFalse((boolean)checkboxMessages.hasNext());
        Iterator fooTextMessages = this.server.getFacesMessages("input_foo_text");
        FacesMessage message = (FacesMessage)fooTextMessages.next();
        FacadeAPITest.assertTrue((boolean)message.getDetail().contains("input_foo_text"));
    }

    public void testTextArea() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/indexWithExtraComponents.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        client.setValue("input_foo_text", "Stan");
        FacadeAPITest.assertEquals((Object)"Initial Value", (Object)server.getManagedBeanValue("#{foo2.text}"));
        client.setValue("MyTextArea", "New Value");
        client.click("submit_button");
        FacadeAPITest.assertEquals((Object)"New Value", (Object)server.getManagedBeanValue("#{foo2.text}"));
    }

    public void testSelectOneRadio() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/indexWithExtraComponents.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        client.setValue("input_foo_text", "Stan");
        FacadeAPITest.assertEquals((Object)"Blue", (Object)server.getManagedBeanValue("#{foo3.text}"));
        client.click("selectGreen");
        client.click("submit_button");
        FacadeAPITest.assertEquals((Object)"Green", (Object)server.getManagedBeanValue("#{foo3.text}"));
    }

    public void testSelectManyListbox() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/indexWithExtraComponents.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        client.click("selectMonday");
        client.click("selectWednesday");
        client.click("selectFriday");
        client.click("submit_button");
        HtmlSelectManyListbox listBox = (HtmlSelectManyListbox)server.findComponent("Weekdays");
        Object[] selectedValues = listBox.getSelectedValues();
        FacadeAPITest.assertEquals((int)3, (int)selectedValues.length);
        List<Object> listOfValues = Arrays.asList(selectedValues);
        FacadeAPITest.assertTrue((boolean)listOfValues.contains("Monday"));
        FacadeAPITest.assertFalse((boolean)listOfValues.contains("Tuesday"));
        FacadeAPITest.assertTrue((boolean)listOfValues.contains("Wednesday"));
        FacadeAPITest.assertFalse((boolean)listOfValues.contains("Thursday"));
        FacadeAPITest.assertTrue((boolean)listOfValues.contains("Friday"));
    }

    public void testGetElementThrowsDuplicateIDException() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/index.jsp");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        try {
            client.getElement("Test");
            FacadeAPITest.fail((String)"Expected DuplicateClientIDException");
        }
        catch (DuplicateClientIDException e) {
            // empty catch block
        }
    }

    public void testNoCreationOfBeanDuringELExpressionReference() throws IOException {
        Object bean = this.server.getManagedBeanValue("#{mysessionbean}");
        FacadeAPITest.assertNull((Object)bean);
    }
}

