/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession.hellojsf;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimplifiedHelloJSFIntegrationTest
extends ServletTestCase {
    private JSFClientSession client;
    private JSFServerSession server;

    public void setUp() throws IOException {
        JSFSession jsfSession = new JSFSession("/jsf/index.jsp");
        this.client = jsfSession.getJSFClientSession();
        this.server = jsfSession.getJSFServerSession();
    }

    public static Test suite() {
        return new TestSuite(SimplifiedHelloJSFIntegrationTest.class);
    }

    public void testInitialPage() throws IOException {
        SimplifiedHelloJSFIntegrationTest.assertNotNull((Object)this.client.getContentPage());
        SimplifiedHelloJSFIntegrationTest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        UIComponent prompt = this.server.findComponent("prompt");
        SimplifiedHelloJSFIntegrationTest.assertTrue((boolean)prompt.isRendered());
        UIComponent greeting = this.server.findComponent("greeting");
        SimplifiedHelloJSFIntegrationTest.assertFalse((boolean)greeting.isRendered());
    }

    public void testInputValidation() throws IOException {
        this.client.setValue("input_foo_text", "A");
        this.client.click("submit_button");
        SimplifiedHelloJSFIntegrationTest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        FacesMessage message = (FacesMessage)this.server.getFacesContext().getMessages().next();
        SimplifiedHelloJSFIntegrationTest.assertTrue((boolean)message.getDetail().contains("input_foo_text"));
    }

    public void testValidInput() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("submit_button");
        UIComponent greeting = this.server.findComponent("greeting");
        SimplifiedHelloJSFIntegrationTest.assertTrue((boolean)greeting.isRendered());
        SimplifiedHelloJSFIntegrationTest.assertEquals((Object)"Hello Stan", (Object)this.server.getComponentValue("greeting"));
        SimplifiedHelloJSFIntegrationTest.assertEquals((Object)"Stan", (Object)this.server.getManagedBeanValue("#{foo.text}"));
    }

    public void testGoodbyeButton() throws IOException {
        this.testValidInput();
        this.client.click("goodbye_button");
        SimplifiedHelloJSFIntegrationTest.assertEquals((String)"/finalgreeting.jsp", (String)this.server.getCurrentViewID());
        SimplifiedHelloJSFIntegrationTest.assertEquals((Object)"Bye Stan. I enjoyed our chat.", (Object)this.server.getComponentValue("finalgreeting"));
    }
}

