/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession.hellojsf;

import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import java.io.IOException;
import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.framework.FacesContextBridge;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class HelloJSFIntegrationTest
extends ServletTestCase {
    private HtmlPage htmlPage;

    public void setUp() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/jsf/index.jsp");
        this.htmlPage = (HtmlPage)wcSpec.doInitialRequest();
    }

    public static Test suite() {
        return new TestSuite(HelloJSFIntegrationTest.class);
    }

    public void testInitialPage() throws IOException, SAXException {
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot root = facesContext.getViewRoot();
        HelloJSFIntegrationTest.assertEquals((String)"/index.jsp", (String)root.getViewId());
        UIComponent prompt = root.findComponent("form1:prompt");
        HelloJSFIntegrationTest.assertTrue((boolean)prompt.isRendered());
        UIComponent greeting = root.findComponent("form1:greeting");
        HelloJSFIntegrationTest.assertFalse((boolean)greeting.isRendered());
    }

    public void testInputValidation() throws IOException, SAXException {
        HtmlInput inputText = (HtmlInput)this.htmlPage.getElementById("form1:input_foo_text");
        inputText.setValueAttribute("A");
        HtmlSubmitInput submit = (HtmlSubmitInput)this.htmlPage.getElementById("form1:submit_button");
        submit.click();
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot root = facesContext.getViewRoot();
        HelloJSFIntegrationTest.assertEquals((String)"/index.jsp", (String)root.getViewId());
        FacesMessage message = (FacesMessage)facesContext.getMessages().next();
        HelloJSFIntegrationTest.assertTrue((boolean)message.getDetail().contains("input_foo_text"));
    }

    public void testValidInput() throws IOException, SAXException {
        HtmlInput inputText = (HtmlInput)this.htmlPage.getElementById("form1:input_foo_text");
        inputText.setValueAttribute("Stan");
        HtmlSubmitInput submit = (HtmlSubmitInput)this.htmlPage.getElementById("form1:submit_button");
        this.htmlPage = (HtmlPage)submit.click();
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot root = facesContext.getViewRoot();
        UIComponent greeting = root.findComponent("form1:greeting");
        HelloJSFIntegrationTest.assertTrue((boolean)greeting.isRendered());
        HelloJSFIntegrationTest.assertEquals((Object)"Hello Stan", (Object)((ValueHolder)greeting).getValue());
        HelloJSFIntegrationTest.assertEquals((String)"Stan", (String)((String)facesContext.getApplication().createValueBinding("#{foo.text}").getValue(facesContext)));
    }

    public void testGoodbyeButton() throws IOException, SAXException {
        this.testValidInput();
        HtmlSubmitInput submit = (HtmlSubmitInput)this.htmlPage.getElementById("form1:goodbye_button");
        submit.click();
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot root = facesContext.getViewRoot();
        HelloJSFIntegrationTest.assertEquals((String)"/finalgreeting.jsp", (String)root.getViewId());
        UIComponent finalGreeting = root.findComponent("finalgreeting");
        HelloJSFIntegrationTest.assertEquals((Object)"Bye Stan. I enjoyed our chat.", (Object)((ValueHolder)finalGreeting).getValue());
    }

    public void testFacesContextSerializable() throws IOException, SAXException {
        HelloJSFIntegrationTest.assertTrue((boolean)(FacesContextBridge.getCurrentInstance() instanceof Serializable));
    }
}

