/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
implements Serializable {
    private static final long serialVersionUID = 4145377365165079425L;
    public static final String HTMLUNIT_COOKIE_POLICY = "compatibility";
    private boolean cookiesEnabled_ = true;
    private final Set<Cookie> cookies_ = new LinkedHashSet<Cookie>();

    public void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled_ = enabled;
    }

    public boolean isCookiesEnabled() {
        return this.cookiesEnabled_;
    }

    public Set<Cookie> getCookies() {
        return Collections.unmodifiableSet(this.cookies_);
    }

    public Set<Cookie> getCookies(String domain) {
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals(cookie.getDomain(), domain)) continue;
            cookies.add(cookie);
        }
        return Collections.unmodifiableSet(cookies);
    }

    public Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals(cookie.getName(), name)) continue;
            return cookie;
        }
        return null;
    }

    public void addCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
        this.cookies_.add(cookie);
    }

    public void removeCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
    }

    public void clearCookies() {
        this.cookies_.clear();
    }

    protected void updateState(HttpState state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        state.clearCookies();
        for (Cookie cookie : this.cookies_) {
            state.addCookie(cookie);
        }
    }

    protected void updateFromState(HttpState state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        this.cookies_.clear();
        this.cookies_.addAll(Arrays.asList(state.getCookies()));
    }
}

