/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlScript
extends HtmlElement {
    private static final long serialVersionUID = 5736570536821513938L;
    public static final String TAG_NAME = "script";
    private static final String SLASH_SLASH_COLON = "//:";
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());

    HtmlScript(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttribute("language");
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getEventAttribute() {
        return this.getAttribute("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttribute("for");
    }

    public final String getDeferAttribute() {
        return this.getAttribute("defer");
    }

    protected boolean isDeferred() {
        return this.getDeferAttribute() != ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        boolean ie;
        String oldValue = this.getAttributeNS(namespaceURI, qualifiedName);
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        boolean execute = false;
        if (namespaceURI == null && "src".equals(qualifiedName) && ((ie = this.getPage().getWebClient().getBrowserVersion().isIE()) || oldValue.length() == 0 && this.getFirstChild() == null)) {
            execute = true;
        }
        if (execute) {
            this.executeScriptIfNeeded(true);
        }
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug("Script node added: " + this.asXml());
        }
        PostponedAction action = new PostponedAction(){

            public void execute() {
                boolean ie = HtmlScript.this.getPage().getWebClient().getBrowserVersion().isIE();
                if (ie) {
                    if (!HtmlScript.this.isDeferred()) {
                        if (!HtmlScript.this.getSrcAttribute().equals(HtmlScript.SLASH_SLASH_COLON)) {
                            HtmlScript.this.setAndExecuteReadyState("loading");
                            HtmlScript.this.executeScriptIfNeeded(true);
                            HtmlScript.this.setAndExecuteReadyState("loaded");
                        } else {
                            HtmlScript.this.setAndExecuteReadyState("complete");
                            HtmlScript.this.executeScriptIfNeeded(true);
                        }
                    }
                } else {
                    HtmlScript.this.executeScriptIfNeeded(true);
                    HTMLScriptElement script = (HTMLScriptElement)HtmlScript.this.getScriptObject();
                    Function handler = script.getOnLoadHandler();
                    if (handler != null) {
                        ((HtmlPage)HtmlScript.this.getPage()).executeJavaScriptFunctionIfPossible(handler, script, new Object[0], HtmlScript.this);
                    }
                }
            }
        };
        if (postponed && this.getTextContent().length() == 0) {
            JavaScriptEngine engine = this.getPage().getWebClient().getJavaScriptEngine();
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeInlineScriptIfNeeded(boolean executeIfDeferred) {
        if (!this.isExecutionNeeded()) {
            return;
        }
        boolean ie = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!executeIfDeferred && this.isDeferred() && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        String forr = this.getHtmlForAttribute();
        String event = this.getEventAttribute();
        String scriptCode = textNode.getData();
        if (event != ATTRIBUTE_NOT_DEFINED && forr != ATTRIBUTE_NOT_DEFINED) {
            if (event.endsWith("()")) {
                event = event.substring(0, event.length() - 2);
            }
            if ("window".equals(forr)) {
                Window window = (Window)this.getPage().getEnclosingWindow().getScriptObject();
                EventHandler function = new EventHandler(this, event, scriptCode);
                window.jsxFunction_attachEvent(event, function);
                return;
            } else {
                if (!ie) return;
                try {
                    Object elt = ((HtmlPage)this.getPage()).getHtmlElementById(forr);
                    ((HtmlElement)elt).setEventHandler(event, scriptCode);
                    return;
                }
                catch (ElementNotFoundException e) {
                    this.mainLog_.warn("<script for='" + forr + "' ...>: no element found with id \"" + forr + "\". Ignoring.");
                }
            }
            return;
        } else {
            String url = this.getPage().getWebResponse().getRequestUrl().toExternalForm();
            int line1 = this.getStartLineNumber();
            int line2 = this.getEndLineNumber();
            int col1 = this.getStartColumnNumber();
            int col2 = this.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            ((HtmlPage)this.getPage()).executeJavaScriptIfPossible(scriptCode, desc, line1);
        }
    }

    void executeScriptIfNeeded(boolean executeIfDeferred) {
        if (!this.isExecutionNeeded()) {
            return;
        }
        BrowserVersion browser = this.getPage().getWebClient().getBrowserVersion();
        boolean ie = browser.isIE();
        if (!executeIfDeferred && this.isDeferred() && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            return;
        }
        if (src != ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) {
                String code;
                int len;
                if ((!ie || browser.getBrowserVersionNumeric() != 7.0f) && (len = (code = StringUtils.removeStart(src, "javascript:").trim()).length()) > 2 && (code.charAt(0) == '\'' && code.charAt(len - 1) == '\'' || code.charAt(0) == '\"' && code.charAt(len - 1) == '\"')) {
                    code = code.substring(1, len - 1);
                    if (this.mainLog_.isDebugEnabled()) {
                        this.mainLog_.debug("Executing JavaScript: " + code);
                    }
                    ((HtmlPage)this.getPage()).executeJavaScriptIfPossible(code, code, this.getStartLineNumber());
                }
            } else {
                if (this.mainLog_.isDebugEnabled()) {
                    this.mainLog_.debug("Loading external JavaScript: " + src);
                }
                ((HtmlPage)this.getPage()).loadExternalJavaScriptFile(src, this.getCharsetAttribute());
            }
        } else if (this.getFirstChild() != null) {
            this.executeInlineScriptIfNeeded(executeIfDeferred);
        }
    }

    private boolean isExecutionNeeded() {
        SgmlPage page = this.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        if (page instanceof HtmlPage && ((HtmlPage)page).isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = this; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames) && !(o instanceof HtmlNoScript)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        if (!HtmlPage.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            String t = this.getTypeAttribute();
            String l = this.getLanguageAttribute();
            if (this.mainLog_.isWarnEnabled()) {
                this.mainLog_.warn("Script is not JavaScript (type: " + t + ", language: " + l + "). Skipping execution.");
            }
            return false;
        }
        DomNode root = this;
        while (root.getParentNode() != null) {
            root = root.getParentNode();
        }
        return root == this.getPage();
    }

    protected void setAndExecuteReadyState(String state) {
        if (this.getPage().getWebClient().getBrowserVersion().isIE()) {
            this.setReadyState(state);
            HTMLScriptElement script = (HTMLScriptElement)this.getScriptObject();
            Function handler = script.getOnReadyStateChangeHandler();
            if (handler != null) {
                ((HtmlPage)this.getPage()).executeJavaScriptFunctionIfPossible(handler, script, new Object[0], this);
            }
        }
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    protected String asTextInternal() {
        return "";
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        if (textNode != null) {
            printWriter.println("//<![CDATA[");
            printWriter.println(textNode.getData());
            printWriter.println("//]]>");
        }
    }
}

