/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final long serialVersionUID = -1883166331827717255L;
    private SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Map<String, String> defaultDisplays_;

    public ComputedCSSStyleDeclaration() {
    }

    ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getHTMLElement());
        this.getHTMLElement().setDefaults(this);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    void setLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap(boolean camelCase) {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap(camelCase);
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement e : this.localModifications_.values()) {
                String key = e.getName();
                if (camelCase) {
                    key = ComputedCSSStyleDeclaration.camelize(key);
                }
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(key, e.getValue(), e.getIndex());
                if (existent != null) continue;
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundAttachment(), "scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        String value = super.jsxGet_backgroundColor();
        if (StringUtils.isEmpty(value)) {
            value = "transparent";
        } else if (this.getBrowserVersion().isFirefox()) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String jsxGet_backgroundImage() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundImage(), "none");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundRepeat(), "repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderBottomColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderBottomStyle(), "none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderBottomWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderCollapse() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderCollapse(), "separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderLeftColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderLeftStyle(), "none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderLeftWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderRightColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderRightColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderRightStyle(), "none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderRightWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderSpacing(), "0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderTopColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderTopStyle(), "none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderTopWidth(), "0px"));
    }

    @Override
    public String jsxGet_bottom() {
        return StringUtils.defaultIfEmpty(super.jsxGet_bottom(), "auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return StringUtils.defaultIfEmpty(super.jsxGet_captionSide(), "top");
    }

    @Override
    public String jsxGet_clear() {
        return StringUtils.defaultIfEmpty(super.jsxGet_clear(), "none");
    }

    @Override
    public String jsxGet_clip() {
        return StringUtils.defaultIfEmpty(super.jsxGet_clip(), "auto");
    }

    @Override
    public String jsxGet_color() {
        return StringUtils.defaultIfEmpty(super.jsxGet_color(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return StringUtils.defaultIfEmpty(super.jsxGet_counterIncrement(), "none");
    }

    @Override
    public String jsxGet_counterReset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_counterReset(), "none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return StringUtils.defaultIfEmpty(super.jsxGet_cssFloat(), "none");
    }

    @Override
    public String jsxGet_cursor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_cursor(), "auto");
    }

    @Override
    public String jsxGet_direction() {
        return StringUtils.defaultIfEmpty(super.jsxGet_direction(), "ltr");
    }

    @Override
    public String jsxGet_display() {
        return StringUtils.defaultIfEmpty(super.jsxGet_display(), this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue;
        if (this.defaultDisplays_ == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("A", "inline");
            map.put("CODE", "inline");
            map.put("SPAN", "inline");
            if (!this.getBrowserVersion().isIE()) {
                map.put("LI", "list-item");
                map.put("TABLE", "table");
                map.put("TBODY", "table-row-group");
                map.put("TD", "table-cell");
                map.put("TH", "table-cell");
                map.put("THEAD", "table-header-group");
                map.put("TR", "table-row");
            }
            this.defaultDisplays_ = Collections.unmodifiableMap(map);
        }
        if ((defaultValue = this.defaultDisplays_.get(this.getHTMLElement().jsxGet_tagName())) == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return StringUtils.defaultIfEmpty(super.jsxGet_emptyCells(), "-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontFamily(), "serif");
    }

    @Override
    public String jsxGet_fontSize() {
        HTMLElement parent;
        String value = super.jsxGet_fontSize();
        if (value.length() == 0 && (parent = this.getElement().getParentHTMLElement()) != null) {
            value = parent.jsxGet_currentStyle().jsxGet_fontSize();
        }
        if (value.length() == 0) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontSizeAdjust(), "none");
    }

    @Override
    public String jsxGet_fontStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontStyle(), "normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontVariant(), "normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontWeight(), "400");
    }

    @Override
    public String jsxGet_height() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_height(), "363px"));
    }

    @Override
    public String jsxGet_left() {
        return StringUtils.defaultIfEmpty(super.jsxGet_left(), "auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_letterSpacing(), "normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_lineHeight(), "normal");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStyleImage(), "none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStylePosition(), "outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStyleType(), "disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginBottom(), "0px"));
    }

    @Override
    public String jsxGet_marginLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginLeft(), "0px"));
    }

    @Override
    public String jsxGet_marginRight() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginRight(), "0px"));
    }

    @Override
    public String jsxGet_marginTop() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginTop(), "0px"));
    }

    @Override
    public String jsxGet_markerOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_markerOffset(), "none");
    }

    @Override
    public String jsxGet_maxHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_maxHeight(), "none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_maxWidth(), "none");
    }

    @Override
    public String jsxGet_minHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_minHeight(), "0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_minWidth(), "0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozAppearance(), "none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundClip(), "border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundInlinePolicy(), "continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundOrigin(), "padding");
    }

    @Override
    public String jsxGet_MozBinding() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBinding(), "none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderBottomColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderLeftColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRightColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderTopColors(), "none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxAlign(), "stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxDirection(), "normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxFlex(), "0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxOrdinalGroup(), "1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxOrient(), "horizontal");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxPack(), "start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxSizing(), "content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnCount(), "auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnGap(), "0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnWidth(), "auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozFloatEdge(), "content-box");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozImageRegion(), "auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOpacity(), "1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineOffset(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineStyle(), "none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineWidth(), "0px");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserFocus(), "none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserInput(), "auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserModify(), "read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserSelect(), "auto");
    }

    @Override
    public String jsxGet_opacity() {
        return StringUtils.defaultIfEmpty(super.jsxGet_opacity(), "1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineOffset(), "0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineStyle(), "none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineWidth(), "0px");
    }

    @Override
    public String jsxGet_overflow() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflow(), "visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflowX(), "visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflowY(), "visible");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingBottom(), "0px"));
    }

    @Override
    public String jsxGet_paddingLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingLeft(), "0px"));
    }

    @Override
    public String jsxGet_paddingRight() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingRight(), "0px"));
    }

    @Override
    public String jsxGet_paddingTop() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingTop(), "0px"));
    }

    @Override
    public String jsxGet_position() {
        return StringUtils.defaultIfEmpty(super.jsxGet_position(), "static");
    }

    @Override
    public String jsxGet_right() {
        return StringUtils.defaultIfEmpty(super.jsxGet_right(), "auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return StringUtils.defaultIfEmpty(super.jsxGet_tableLayout(), "auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textAlign(), "start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textDecoration(), "none");
    }

    @Override
    public String jsxGet_textIndent() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textIndent(), "0px");
    }

    @Override
    public String jsxGet_textTransform() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textTransform(), "none");
    }

    @Override
    public String jsxGet_top() {
        return StringUtils.defaultIfEmpty(super.jsxGet_top(), "auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        return StringUtils.defaultIfEmpty(super.jsxGet_unicodeBidi(), "normal");
    }

    @Override
    public String jsxGet_verticalAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_verticalAlign(), "baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return StringUtils.defaultIfEmpty(super.jsxGet_visibility(), "visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return StringUtils.defaultIfEmpty(super.jsxGet_whiteSpace(), "normal");
    }

    @Override
    public String jsxGet_width() {
        if (this.jsxGet_display().equals("none")) {
            return "auto";
        }
        String defaultWidth = "1256px";
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_width(), "1256px"));
    }

    int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width;
        String styleWidth = super.jsxGet_width();
        DomNode parent = this.getHTMLElement().getDomNodeOrDie().getParentNode();
        if (StringUtils.isEmpty(styleWidth) && parent instanceof HtmlElement) {
            HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
            String parentWidth = this.getWindow().jsxFunction_getComputedStyle(parentJS, null).jsxGet_width();
            width = ComputedCSSStyleDeclaration.pixelValue(parentWidth);
        } else {
            width = ComputedCSSStyleDeclaration.pixelValue(styleWidth);
            if (includeBorder) {
                int borderLeft = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
                int borderRight = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderRightWidth());
                width += borderLeft + borderRight;
            }
            if (includePadding) {
                int paddingLeft = this.getPaddingLeft();
                int paddingRight = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingRight());
                width += paddingLeft + paddingRight;
            }
        }
        return width;
    }

    int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = ComputedCSSStyleDeclaration.pixelValue(super.jsxGet_height());
        if (includeBorder) {
            int borderTop = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
            int borderBottom = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderBottomWidth());
            height += borderTop + borderBottom;
        }
        if (includePadding) {
            int paddingTop = this.getPaddingTop();
            int paddingBottom = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingBottom());
            height += paddingTop + paddingBottom;
        }
        return height;
    }

    int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        String p = this.jsxGet_position();
        String t = this.jsxGet_top();
        String b = this.jsxGet_bottom();
        if ("absolute".equals(p) && !"auto".equals(t)) {
            top = ComputedCSSStyleDeclaration.pixelValue(t);
        } else if ("absolute".equals(p) && !"auto".equals(b)) {
            top = 0;
            for (DomNode child = this.getHTMLElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getPreviousSibling()) {
                if (!(child instanceof HtmlElement) || child instanceof HtmlHead) continue;
                top += 20;
            }
            top -= ComputedCSSStyleDeclaration.pixelValue(b);
        } else {
            top = 0;
            for (DomNode prev = this.getHTMLElement().getDomNodeOrDie().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (!(prev instanceof HtmlElement) || prev instanceof HtmlHead) continue;
                top += 20;
            }
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTop();
            top += padding;
        }
        return top;
    }

    int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        String p = this.jsxGet_position();
        String l = this.jsxGet_left();
        String r = this.jsxGet_right();
        int left = "absolute".equals(p) && !"auto".equals(l) ? ComputedCSSStyleDeclaration.pixelValue(l) : ("absolute".equals(p) && !"auto".equals(r) ? 200 - ComputedCSSStyleDeclaration.pixelValue(r) : 0);
        if (includeMargin) {
            int margin = this.getMarginLeft();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeft();
            left += padding;
        }
        return left;
    }

    public int getPaddingTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingTop());
    }

    public int getPaddingLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingLeft());
    }

    public int getMarginLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginLeft());
    }

    public int getBorderLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
    }

    public int getBorderTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
    }

    @Override
    public String jsxGet_wordSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_wordSpacing(), "normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        String response = Context.toString(ComputedCSSStyleDeclaration.getProperty((Scriptable)this, ComputedCSSStyleDeclaration.camelize(name)));
        if (response == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return response;
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().isIE()) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }
}

