/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.UIEvent;
import java.util.LinkedList;
import org.mozilla.javascript.Context;

public class MouseEvent
extends UIEvent {
    private static final long serialVersionUID = 1990705559211878370L;
    public static final String TYPE_CLICK = "click";
    public static final String TYPE_DBL_CLICK = "dblclick";
    public static final String TYPE_MOUSE_OVER = "mouseover";
    public static final String TYPE_MOUSE_MOVE = "mousemove";
    public static final String TYPE_MOUSE_OUT = "mouseout";
    public static final String TYPE_MOUSE_DOWN = "mousedown";
    public static final String TYPE_MOUSE_UP = "mouseup";
    public static final String TYPE_CONTEXT_MENU = "contextmenu";
    public static final int BUTTON_LEFT = 0;
    public static final int BUTTON_MIDDLE = 1;
    public static final int BUTTON_RIGHT = 2;
    private static final int[] buttonCodeToIE = new int[]{1, 4, 2};
    private Integer screenX_;
    private Integer screenY_;
    private int button_;
    private boolean metaKey_;

    public MouseEvent() {
        this.screenX_ = 0;
        this.screenY_ = 0;
        this.setDetail(1L);
    }

    public MouseEvent(DomNode domNode, String type, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        super(domNode, type, shiftKey, ctrlKey, altKey);
        if (button != 0 && button != 1 && button != 2) {
            throw new IllegalArgumentException("Invalid button code: " + button);
        }
        this.button_ = button;
        this.metaKey_ = false;
        if (TYPE_DBL_CLICK.equals(type)) {
            this.setDetail(2L);
        } else {
            this.setDetail(1L);
        }
    }

    public int jsxGet_clientX() {
        return this.jsxGet_screenX();
    }

    public int jsxGet_screenX() {
        if (this.screenX_ == null) {
            HTMLElement target = (HTMLElement)this.jsxGet_target();
            this.screenX_ = target.getPosX() + 10;
        }
        return this.screenX_;
    }

    public int jsxGet_pageX() {
        return this.jsxGet_screenX();
    }

    public int jsxGet_clientY() {
        return this.jsxGet_screenY();
    }

    public int jsxGet_screenY() {
        if (this.screenY_ == null) {
            HTMLElement target = (HTMLElement)this.jsxGet_target();
            this.screenY_ = target.getPosY() + 10;
        }
        return this.screenY_;
    }

    public int jsxGet_pageY() {
        return this.jsxGet_screenY();
    }

    public int jsxGet_button() {
        if (this.getBrowserVersion().isIE()) {
            if (this.jsxGet_type().equals(TYPE_CONTEXT_MENU)) {
                return 0;
            }
            return buttonCodeToIE[this.button_];
        }
        return this.button_;
    }

    public boolean jsxGet_metaKey() {
        return this.metaKey_;
    }

    public int jsxGet_which() {
        return this.button_ + 1;
    }

    public void jsxFunction_initMouseEvent(String type, boolean bubbles, boolean cancelable, Object view, int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Object relatedTarget) {
        this.jsxFunction_initUIEvent(type, bubbles, cancelable, view, detail);
        this.screenX_ = screenX;
        this.screenY_ = screenY;
        this.setCtrlKey(ctrlKey);
        this.setAltKey(altKey);
        this.setShiftKey(shiftKey);
        this.button_ = button;
    }

    static MouseEvent getCurrentMouseEvent() {
        LinkedList events = (LinkedList)Context.getCurrentContext().getThreadLocal("Event#current");
        if (events != null && !events.isEmpty() && events.getLast() instanceof MouseEvent) {
            return (MouseEvent)events.getLast();
        }
        return null;
    }

    static boolean isMouseEvent(String type) {
        return TYPE_CLICK.equals(type) || TYPE_MOUSE_OVER.equals(type) || TYPE_MOUSE_MOVE.equals(type) || TYPE_MOUSE_OUT.equals(type) || TYPE_MOUSE_DOWN.equals(type) || TYPE_MOUSE_UP.equals(type) || TYPE_CONTEXT_MENU.equals(type);
    }
}

