/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.deployment.WarDeployableFile;
import org.apache.cactus.integration.ant.deployment.webapp.DefaultWarArchive;
import org.apache.cactus.integration.ant.deployment.webapp.WarArchive;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;

public class WarParser {
    public static final WarDeployableFile parse(File theDeployableFile) {
        WarDeployableFile deployable = new WarDeployableFile();
        try {
            deployable.setFile(theDeployableFile);
            deployable.setWarArchive(new DefaultWarArchive(theDeployableFile));
            deployable.setTestContext(WarParser.parseWebContext(theDeployableFile));
            deployable.setServletRedirectorMapping(WarParser.parseServletRedirectorMapping(deployable.getWarArchive()));
            deployable.setFilterRedirectorMapping(WarParser.parseFilterRedirectorMapping(deployable.getWarArchive()));
            deployable.setJspRedirectorMapping(WarParser.parseJspRedirectorMapping(deployable.getWarArchive()));
        }
        catch (IOException e) {
            throw new BuildException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        return deployable;
    }

    protected static String parseWebContext(File theDeployableFile) {
        String context = theDeployableFile.getName();
        int warIndex = context.toLowerCase().lastIndexOf(".war");
        if (warIndex >= 0) {
            context = context.substring(0, warIndex);
        }
        return context;
    }

    static String parseServletRedirectorMapping(WarArchive theWar) throws SAXException, IOException, ParserConfigurationException {
        Iterator servletNames = theWar.getWebXml().getServletNamesForClass("org.apache.cactus.server.ServletTestRedirector");
        if (servletNames.hasNext()) {
            String name = (String)servletNames.next();
            Iterator mappings = theWar.getWebXml().getServletMappings(name);
            if (mappings.hasNext()) {
                return (String)mappings.next();
            }
        }
        return null;
    }

    static String parseFilterRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException {
        Iterator filterNames = theWar.getWebXml().getFilterNamesForClass("org.apache.cactus.server.FilterTestRedirector");
        if (filterNames.hasNext()) {
            String name = (String)filterNames.next();
            Iterator mappings = theWar.getWebXml().getFilterMappings(name);
            if (mappings.hasNext()) {
                return (String)mappings.next();
            }
        }
        return null;
    }

    static String parseJspRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException {
        String jspRedirectorPath = theWar.findResource("jspRedirector.jsp");
        if (jspRedirectorPath != null) {
            jspRedirectorPath = "/" + jspRedirectorPath;
            Iterator jspNames = theWar.getWebXml().getServletNamesForJspFile(jspRedirectorPath);
            if (jspNames.hasNext()) {
                String name = (String)jspNames.next();
                Iterator mappings = theWar.getWebXml().getServletMappings(name);
                if (mappings.hasNext()) {
                    return (String)mappings.next();
                }
            }
        }
        return null;
    }
}

