/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Iterator;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.internal.tomcat.TomcatStandaloneConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public abstract class AbstractTomcatStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private ConfigurationCapability capability = new TomcatStandaloneConfigurationCapability();

    public AbstractTomcatStandaloneConfiguration(Container container) {
        super(container);
    }

    public AbstractTomcatStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    protected String getSecurityToken() {
        StringBuffer token = new StringBuffer(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            Iterator users = User.parseUsers(this.getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                token.append("<user ");
                token.append("name=\"" + user.getName() + "\" ");
                token.append("password=\"" + user.getPassword() + "\" ");
                token.append("roles=\"");
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    token.append(role);
                    if (!roles.hasNext()) continue;
                    token.append(',');
                }
                token.append("\"/>");
            }
        }
        return token.toString();
    }
}

