/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployable.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.AbstractTomcatStandaloneConfiguration;

public class CatalinaStandaloneConfiguration
extends AbstractTomcatStandaloneConfiguration {
    public CatalinaStandaloneConfiguration(Container container) {
        super(container);
    }

    public CatalinaStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public void configure() {
        try {
            this.createConfigurationDir();
            FilterChain filterChain = this.createTomcatFilterChain();
            this.getFileUtils().createDirectory(this.getDir(), "temp");
            this.getFileUtils().createDirectory(this.getDir(), "logs");
            File confDir = this.getFileUtils().createDirectory(this.getDir(), "conf");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/tomcat-users.xml", new File(confDir, "tomcat-users.xml"), filterChain);
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/web.xml", new File(confDir, "web.xml"));
            this.setupWebApps();
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private void setupWebApps() {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            File appDir = this.getFileUtils().createDirectory(this.getDir(), "webapps");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable instanceof TomcatWAR) {
                    TomcatWAR tomcatWar = (TomcatWAR)deployable;
                    if (tomcatWar.isExpandedWar() || !tomcatWar.containsContextFile()) continue;
                    fileUtils.copyFile(tomcatWar.getFile(), new File(appDir, tomcatWar.getFile().getName()), null, true);
                    continue;
                }
                if (deployable instanceof WAR) continue;
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create an " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "1" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "2" : "4");
        return level;
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.tomcat.shutdown.port", this.getPropertyValue("cargo.tomcat.shutdown.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        StringBuffer webappTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            TomcatWAR tomcatWar;
            WAR deployable = (WAR)it.next();
            if (deployable instanceof TomcatWAR && !(tomcatWar = (TomcatWAR)deployable).isExpandedWar() && tomcatWar.containsContextFile()) continue;
            webappTokenValue.append(this.createContextToken(deployable));
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    protected String createContextToken(WAR deployable) {
        StringBuffer contextTokenValue = new StringBuffer();
        contextTokenValue.append("<Context path=\"");
        contextTokenValue.append("/" + deployable.getContext());
        contextTokenValue.append("\" docBase=\"");
        contextTokenValue.append(deployable.getFile().getAbsolutePath());
        contextTokenValue.append("\" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\"/>");
        return contextTokenValue.toString();
    }
}

