/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.orion.OrionWebXml;
import org.codehaus.cargo.module.webapp.orion.OrionWebXmlIo;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXml;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXmlIo;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmi;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmiIo;
import org.codehaus.cargo.util.FileUtils;
import org.xml.sax.SAXException;

public class DefaultWarArchive
extends DefaultJarArchive
implements WarArchive {
    private WebXml webXml;

    public DefaultWarArchive(File theFile) throws IOException {
        super(theFile);
    }

    public DefaultWarArchive(InputStream theInputStream) throws IOException {
        super(theInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WebXml getWebXml() throws IOException, SAXException, ParserConfigurationException {
        if (this.webXml == null) {
            InputStream in = null;
            try {
                in = this.getResource("WEB-INF/web.xml");
                if (in != null) {
                    this.webXml = WebXmlIo.parseWebXml(in, null);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.addWeblogicDescriptor();
            this.addOracleDescriptor();
            this.addWebsphereDescriptor();
        }
        return this.webXml;
    }

    public final void store(File f) throws IOException, SAXException, ParserConfigurationException {
        JarEntry entry;
        FileUtils util = new FileUtils();
        File tmpDir = util.createTmpDir();
        WebXmlIo.writeAll(this.getWebXml(), tmpDir);
        JarInputStream in = this.getContentAsStream();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(f));
        while ((entry = in.getNextJarEntry()) != null) {
            if (this.inTmpDir(entry.getName(), tmpDir)) continue;
            out.putNextEntry(entry);
            util.copy(in, out);
        }
        in.close();
        File[] descriptors = tmpDir.listFiles();
        for (int i = 0; i < descriptors.length; ++i) {
            File tmpFile = descriptors[i];
            FileInputStream fIn = new FileInputStream(tmpFile);
            entry = new JarEntry("WEB-INF/" + tmpFile.getName());
            out.putNextEntry(entry);
            util.copy(fIn, out);
            fIn.close();
        }
        out.close();
    }

    public final boolean containsClass(String theClassName) throws IOException {
        boolean containsClass = false;
        String resourceName = "WEB-INF/classes/" + theClassName.replace('.', '/') + ".class";
        if (this.getResource(resourceName) != null) {
            containsClass = true;
        }
        List jars = this.getResources("WEB-INF/lib/");
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            DefaultJarArchive jar = new DefaultJarArchive(this.getResource((String)i.next()));
            if (!jar.containsClass(theClassName)) continue;
            containsClass = true;
        }
        return containsClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWeblogicDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            WeblogicXml descr;
            in = this.getResource("WEB-INF/weblogic.xml");
            if (in != null && (descr = WeblogicXmlIo.parseWeblogicXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOracleDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            OrionWebXml descr;
            in = this.getResource("WEB-INF/orion-web.xml");
            if (in != null && (descr = OrionWebXmlIo.parseOrionXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWebsphereDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            IbmWebBndXmi descr;
            in = this.getResource("WEB-INF/ibm-web-bnd.xmi");
            if (in != null && (descr = IbmWebBndXmiIo.parseIbmWebBndXmi(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private boolean inTmpDir(String entryName, File dir) {
        boolean result = false;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!entryName.toLowerCase().equals("web-inf/" + files[i].getName())) continue;
            result = true;
        }
        return result;
    }
}

