/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jsfunit.framework.RequestListener;

public class JSFUnitWebConnection
implements WebConnection {
    private WebConnection wrappedConnection;
    private List<RequestListener> listeners = new ArrayList<RequestListener>();

    public JSFUnitWebConnection(WebConnection wrappedConnection) {
        this.wrappedConnection = wrappedConnection;
    }

    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        this.notifyListenersBefore(webRequestSettings);
        WebResponse response = null;
        try {
            response = this.wrappedConnection.getResponse(webRequestSettings);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            this.notifyListenersAfter(response);
        }
        return response;
    }

    private void notifyListenersBefore(WebRequestSettings webRequestSettings) {
        Iterator<RequestListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().beforeRequest(webRequestSettings);
        }
    }

    private void notifyListenersAfter(WebResponse response) {
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            RequestListener listener = this.listeners.get(i);
            listener.afterRequest(response);
        }
    }

    public void addListener(RequestListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RequestListener listener) {
        this.listeners.remove(listener);
    }
}

