/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.ImmediateRefreshHandler;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.IncorrectnessListenerImpl;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.attachment.Attachment;
import com.gargoylesoftware.htmlunit.attachment.AttachmentHandler;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.protocol.data.DataUrlDecoder;
import com.gargoylesoftware.htmlunit.protocol.javascript.Handler;
import com.gargoylesoftware.htmlunit.ssl.InsecureSSLProtocolSocketFactory;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
implements Serializable {
    private static final long serialVersionUID = -7214321203864969635L;
    private static final int ALLOWED_REDIRECTIONS_SAME_URL = 20;
    private transient WebConnection webConnection_;
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private CredentialsProvider credentialsProvider_ = new DefaultCredentialsProvider();
    private ProxyConfig proxyConfig_;
    private CookieManager cookieManager_ = new CookieManager();
    private JavaScriptEngine scriptEngine_;
    private boolean javaScriptEnabled_ = true;
    private boolean cssEnabled_ = true;
    private boolean appletEnabled_ = false;
    private boolean popupBlockerEnabled_;
    private String homePage_;
    private final Map<String, String> requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private IncorrectnessListener incorrectnessListener_ = new IncorrectnessListenerImpl();
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private StatusHandler statusHandler_;
    private AttachmentHandler attachmentHandler_;
    private AjaxController ajaxController_ = new AjaxController();
    private BrowserVersion browserVersion_;
    private boolean isRedirectEnabled_ = true;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private final Set<WebWindowListener> webWindowListeners_ = new HashSet<WebWindowListener>(5);
    private final Stack<TopLevelWindow> topLevelWindows_ = new Stack();
    private final List<WebWindow> windows_ = Collections.synchronizedList(new ArrayList());
    private WebWindow currentWindow_;
    private int timeout_;
    private HTMLParserListener htmlParserListener_;
    private ErrorHandler cssErrorHandler_ = new DefaultCssErrorHandler();
    private OnbeforeunloadHandler onbeforeunloadHandler_;
    private Cache cache_ = new Cache();
    private static URLStreamHandler JavaScriptUrlStreamHandler_ = new Handler();
    private static URLStreamHandler AboutUrlStreamHandler_ = new com.gargoylesoftware.htmlunit.protocol.about.Handler();
    private static URLStreamHandler DataUrlStreamHandler_ = new com.gargoylesoftware.htmlunit.protocol.data.Handler();
    public static final URL URL_ABOUT_BLANK;
    private static final WebResponse WEB_RESPONSE_FOR_ABOUT_BLANK;
    private ScriptPreProcessor scriptPreProcessor_;
    private Map<String, String> activeXObjectMap_ = Collections.emptyMap();
    private boolean activeXNative_;
    private RefreshHandler refreshHandler_ = new ImmediateRefreshHandler();
    private boolean throwExceptionOnScriptError_ = true;

    public WebClient() {
        this(BrowserVersion.getDefault());
    }

    public WebClient(BrowserVersion browserVersion) {
        WebAssert.notNull("browserVersion", browserVersion);
        this.init(browserVersion, new ProxyConfig());
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        WebAssert.notNull("browserVersion", browserVersion);
        WebAssert.notNull("proxyHost", proxyHost);
        this.init(browserVersion, new ProxyConfig(proxyHost, proxyPort));
    }

    private void init(BrowserVersion browserVersion, ProxyConfig proxyConfig) {
        this.homePage_ = "http://www.gargoylesoftware.com/";
        this.browserVersion_ = browserVersion;
        this.proxyConfig_ = proxyConfig;
        try {
            this.scriptEngine_ = WebClient.createJavaScriptEngineIfPossible(this);
        }
        catch (NoClassDefFoundError e) {
            this.scriptEngine_ = null;
        }
        this.addWebWindowListener(new CurrentWindowTracker());
        this.currentWindow_ = new TopLevelWindow("", this);
        this.fireWindowOpened(new WebWindowEvent(this.currentWindow_, 1, null, null));
    }

    private static JavaScriptEngine createJavaScriptEngineIfPossible(WebClient webClient) {
        try {
            Class.forName("net.sourceforge.htmlunit.corejs.javascript.Context");
            return new JavaScriptEngine(webClient);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public synchronized WebConnection getWebConnection() {
        if (this.webConnection_ == null) {
            this.webConnection_ = new HttpWebConnection(this);
        }
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        WebAssert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public <P extends Page> P getPage(WebWindow webWindow, WebRequestSettings parameters) throws IOException, FailingHttpStatusCodeException {
        WebResponse webResponse;
        HtmlPage htmlPage;
        Page page = webWindow.getEnclosedPage();
        if (page != null && page instanceof HtmlPage && !(htmlPage = (HtmlPage)page).isOnbeforeunloadAccepted()) {
            this.getLog().debug("The registered OnbeforeunloadHandler rejected to load a new page.");
            return (P)page;
        }
        this.getLog().debug("Get page for window named '" + webWindow.getName() + "', using " + parameters);
        String protocol = parameters.getUrl().getProtocol();
        if (protocol.equals("javascript")) {
            webResponse = this.makeWebResponseForJavaScriptUrl(webWindow, parameters.getUrl(), parameters.getCharset());
            if (webWindow.getEnclosedPage() != null && webWindow.getEnclosedPage().getWebResponse() == webResponse) {
                return (P)webWindow.getEnclosedPage();
            }
        } else {
            webResponse = this.loadWebResponse(parameters);
        }
        this.printContentIfNecessary(webResponse);
        this.loadWebResponseInto(webResponse, webWindow);
        this.throwFailingHttpStatusCodeExceptionIfNecessary(webResponse);
        return (P)webWindow.getEnclosedPage();
    }

    public <P extends Page> P getPage(WebWindow opener, String target, WebRequestSettings params) throws FailingHttpStatusCodeException, IOException {
        return this.getPage(this.openTargetWindow(opener, target, "_self"), params);
    }

    public <P extends Page> P getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        return this.getPage(WebClient.makeUrl(url));
    }

    public <P extends Page> P getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), new WebRequestSettings(url));
    }

    public <P extends Page> P getPage(WebRequestSettings request) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), request);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException, FailingHttpStatusCodeException {
        WebAssert.notNull("webResponse", webResponse);
        WebAssert.notNull("webWindow", webWindow);
        if (this.attachmentHandler_ != null && Attachment.isAttachment(webResponse)) {
            WebWindow w = this.openWindow(null, null, webWindow);
            Page page = this.pageCreator_.createPage(webResponse, w);
            this.attachmentHandler_.handleAttachment(page);
            return page;
        }
        Page oldPage = webWindow.getEnclosedPage();
        if (oldPage != null) {
            oldPage.cleanUp();
        }
        Page newPage = null;
        if (this.windows_.contains(webWindow) || this.getBrowserVersion().isIE()) {
            newPage = this.pageCreator_.createPage(webResponse, webWindow);
            if (this.windows_.contains(webWindow)) {
                this.fireWindowContentChanged(new WebWindowEvent(webWindow, 3, oldPage, newPage));
                if (webWindow.getEnclosedPage() == newPage) {
                    newPage.initialize();
                }
            }
        }
        return newPage;
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean getPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void printContentIfNecessary(WebResponse webResponse) {
        boolean successful;
        String contentType = webResponse.getContentType();
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300;
        if (this.getPrintContentOnFailingStatusCode() && !successful) {
            this.getLog().info("statusCode=[" + statusCode + "] contentType=[" + contentType + "]");
            this.getLog().info(webResponse.getContentAsString());
        }
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean isThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public void throwFailingHttpStatusCodeExceptionIfNecessary(WebResponse webResponse) {
        boolean successful;
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300 || statusCode == 305;
        if (this.isThrowExceptionOnFailingStatusCode() && !successful) {
            throw new FailingHttpStatusCodeException(webResponse);
        }
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        WebAssert.notNull("credentialsProvider", credentialsProvider);
        this.credentialsProvider_ = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    public void setJavaScriptEngine(JavaScriptEngine engine) {
        if (engine == null) {
            throw new NullPointerException("Can't set JavaScriptEngine to null");
        }
        this.scriptEngine_ = engine;
    }

    public void setJavaScriptEnabled(boolean enabled) {
        this.javaScriptEnabled_ = enabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_ && this.scriptEngine_ != null;
    }

    public void setCssEnabled(boolean enabled) {
        this.cssEnabled_ = enabled;
    }

    public boolean isCssEnabled() {
        return this.cssEnabled_;
    }

    public void setAppletEnabled(boolean enabled) {
        this.appletEnabled_ = enabled;
    }

    public boolean isAppletEnabled() {
        return this.appletEnabled_;
    }

    public void setPopupBlockerEnabled(boolean enabled) {
        this.popupBlockerEnabled_ = enabled;
    }

    public boolean isPopupBlockerEnabled() {
        return this.popupBlockerEnabled_;
    }

    public String getHomePage() {
        return this.homePage_;
    }

    public void setHomePage(String homePage) {
        this.homePage_ = homePage;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig_;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        WebAssert.notNull("proxyConfig", proxyConfig);
        this.proxyConfig_ = proxyConfig;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager_;
    }

    public void setCookieManager(CookieManager cookieManager) {
        WebAssert.notNull("cookieManager", cookieManager);
        this.cookieManager_ = cookieManager;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler_ = statusHandler;
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        Window jsWindow;
        HtmlElement focusedElement;
        Page enclosedPage;
        WebAssert.notNull("window", window);
        if (this.currentWindow_ == window) {
            return;
        }
        if (this.currentWindow_ != null && (enclosedPage = this.currentWindow_.getEnclosedPage()) instanceof HtmlPage && (focusedElement = ((HtmlPage)enclosedPage).getFocusedElement()) != null) {
            focusedElement.fireEvent("blur");
        }
        this.currentWindow_ = window;
        enclosedPage = this.currentWindow_.getEnclosedPage();
        if (enclosedPage instanceof HtmlPage && (jsWindow = (Window)this.currentWindow_.getScriptObject()) != null) {
            if (this.getBrowserVersion().isIE()) {
                HTMLElement activeElement = (HTMLElement)jsWindow.jsxGet_document().jsxGet_activeElement();
                if (activeElement != null) {
                    ((HtmlPage)enclosedPage).setFocusedElement(activeElement.getDomNodeOrDie(), true);
                }
            } else {
                HtmlElement focusedElement2 = ((HtmlPage)enclosedPage).getFocusedElement();
                if (focusedElement2 != null) {
                    ((HtmlPage)enclosedPage).setFocusedElement(focusedElement2, true);
                }
            }
        }
    }

    public void addWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowOpened(event);
        }
    }

    private void fireWindowClosed(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowClosed(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        WebAssert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, this.getCurrentWindow());
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window = this.openTargetWindow(opener, windowName, "_blank");
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        if (url != null) {
            try {
                WebRequestSettings settings = new WebRequestSettings(url);
                if (!this.getBrowserVersion().isIE() && openerPage != null) {
                    String referer = openerPage.getWebResponse().getRequestUrl().toExternalForm();
                    settings.addAdditionalHeader("Referer", referer);
                }
                this.getPage(window, settings);
            }
            catch (IOException e) {
                this.getLog().error("Error loading content into window", e);
            }
        } else {
            this.initializeEmptyWindow(window);
            if (openerPage != null) {
                Window jsWindow = (Window)window.getScriptObject();
                jsWindow.setDomNode(openerPage);
                jsWindow.jsxGet_document().setDomNode(openerPage);
            }
        }
        return window;
    }

    private WebWindow openTargetWindow(WebWindow opener, String windowName, String defaultName) {
        WebAssert.notNull("opener", opener);
        WebAssert.notNull("defaultName", defaultName);
        String windowToOpen = windowName;
        if (windowToOpen == null || windowToOpen.length() == 0) {
            windowToOpen = defaultName;
        }
        WebWindow webWindow = null;
        if (windowToOpen.equals("_self")) {
            webWindow = opener;
            windowToOpen = "";
        } else if (windowToOpen.equals("_parent")) {
            webWindow = opener.getParentWindow();
            windowToOpen = "";
        } else if (windowToOpen.equals("_top")) {
            webWindow = opener.getTopWindow();
            windowToOpen = "";
        } else if (windowToOpen.equals("_blank")) {
            windowToOpen = "";
        } else if (windowToOpen.length() != 0) {
            try {
                webWindow = this.getWebWindowByName(windowToOpen);
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        if (webWindow == null) {
            webWindow = new TopLevelWindow(windowToOpen, this);
            this.fireWindowOpened(new WebWindowEvent(webWindow, 1, null, null));
        }
        if (webWindow instanceof TopLevelWindow && webWindow != opener.getTopWindow()) {
            ((TopLevelWindow)webWindow).setOpener(opener);
        }
        return webWindow;
    }

    public DialogWindow openDialogWindow(URL url, WebWindow opener, Object dialogArguments) throws IOException {
        WebAssert.notNull("url", url);
        WebAssert.notNull("opener", opener);
        DialogWindow window = new DialogWindow(this, dialogArguments);
        this.fireWindowOpened(new WebWindowEvent(window, 1, null, null));
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        WebRequestSettings settings = new WebRequestSettings(url);
        if (!this.getBrowserVersion().isIE()) {
            String referer = openerPage.getWebResponse().getRequestUrl().toExternalForm();
            settings.addAdditionalHeader("Referer", referer);
        }
        this.getPage(window, settings);
        return window;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setUseInsecureSSL(boolean useInsecureSSL) throws GeneralSecurityException {
        if (useInsecureSSL) {
            InsecureSSLProtocolSocketFactory factory = new InsecureSSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)factory, 443);
            Protocol.registerProtocol("https", https);
        } else {
            Protocol.unregisterProtocol("https");
        }
    }

    public void setPageCreator(PageCreator pageCreator) {
        WebAssert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        WebAssert.notNull("name", name);
        for (WebWindow webWindow : this.windows_) {
            if (!webWindow.getName().equals(name)) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void initialize(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.initialize(webWindow);
        }
    }

    public void initialize(Page newPage) {
        WebAssert.notNull("newPage", newPage);
        if (this.scriptEngine_ != null) {
            ((Window)newPage.getEnclosingWindow().getScriptObject()).initialize(newPage);
        }
    }

    public void initializeEmptyWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.scriptEngine_ != null) {
            this.initialize(webWindow);
            ((Window)webWindow.getScriptObject()).initialize();
        }
    }

    public void registerWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.windows_.add(webWindow);
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.windows_.remove(webWindow);
        this.fireWindowClosed(new WebWindowEvent(webWindow, 2, webWindow.getEnclosedPage(), null));
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private static URL makeUrl(String urlString) throws MalformedURLException {
        WebAssert.notNull("urlString", urlString);
        if (TextUtil.startsWithIgnoreCase(urlString, "javascript:")) {
            return new URL(null, urlString, JavaScriptUrlStreamHandler_);
        }
        if (TextUtil.startsWithIgnoreCase(urlString, "about:")) {
            return new URL(null, urlString, AboutUrlStreamHandler_);
        }
        if (TextUtil.startsWithIgnoreCase(urlString, "data:")) {
            return new URL(null, urlString, DataUrlStreamHandler_);
        }
        return new URL(urlString);
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String newUrl = UrlUtils.resolveUrl(baseUrl, relativeUrl);
        return WebClient.makeUrl(newUrl);
    }

    private WebResponse makeWebResponseForDataUrl(WebRequestSettings webRequestSettings) throws IOException {
        DataUrlDecoder decoder;
        URL url = webRequestSettings.getUrl();
        ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>();
        try {
            decoder = DataUrlDecoder.decode(url);
        }
        catch (DecoderException e) {
            throw new IOException(e.getMessage());
        }
        responseHeaders.add(new NameValuePair("content-type", decoder.getMediaType() + ";charset=" + decoder.getCharset()));
        WebResponseData data = new WebResponseData(url.openStream(), 200, "OK", responseHeaders);
        return new WebResponseImpl(data, url, webRequestSettings.getHttpMethod(), 0L);
    }

    private WebResponse makeWebResponseForAboutUrl(URL url) {
        String urlWithoutQuery = StringUtils.substringBefore(url.toExternalForm(), "?");
        if (!StringUtils.substringAfter(urlWithoutQuery, "about:").equalsIgnoreCase("blank")) {
            throw new IllegalArgumentException(url + "is not supported, only about:blank is supported now.");
        }
        return WEB_RESPONSE_FOR_ABOUT_BLANK;
    }

    private WebResponse makeWebResponseForFileUrl(URL url, String charset) throws IOException {
        File file;
        String contentType;
        URL cleanUrl = url;
        if (cleanUrl.getQuery() != null) {
            cleanUrl = UrlUtils.getUrlWithNewQuery(cleanUrl, null);
        }
        if (cleanUrl.getRef() != null) {
            cleanUrl = UrlUtils.getUrlWithNewRef(cleanUrl, null);
        }
        if ((contentType = this.guessContentType(file = FileUtils.toFile(cleanUrl))).startsWith("text")) {
            String str = IOUtils.toString(new FileInputStream(file), charset);
            return new StringWebResponse(str, charset, url){
                private static final long serialVersionUID = 5713127877370126236L;

                public String getContentType() {
                    return contentType;
                }
            };
        }
        byte[] data = IOUtils.toByteArray(new FileInputStream(file));
        return new BinaryWebResponse(data, url, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String guessContentType(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (file.getName().endsWith(".xhtml")) {
            contentType = "application/xhtml+xml";
        }
        if (contentType == null) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                contentType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(inputStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
        }
        if (contentType == null) {
            contentType = file.getName().endsWith(".js") ? "text/javascript" : "application/octet-stream";
        }
        return contentType;
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, URL url, String charset) throws FailingHttpStatusCodeException, IOException {
        HtmlPage page;
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            page = frameWindow.getEnclosingPage();
        } else {
            Page currentPage = webWindow.getEnclosedPage();
            if (currentPage == null) {
                currentPage = this.getPage(webWindow, new WebRequestSettings(URL_ABOUT_BLANK));
            }
            page = (HtmlPage)currentPage;
        }
        ScriptResult r = page.executeJavaScriptIfPossible(url.toExternalForm(), "JavaScript URL", 1);
        if (r != null && r.getJavaScriptResult() == null || ScriptResult.isUndefined(r)) {
            return webWindow.getEnclosedPage().getWebResponse();
        }
        String contentString = r.getJavaScriptResult().toString();
        return new StringWebResponse(contentString, charset, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebResponse loadWebResponse(WebRequestSettings webRequestSettings) throws IOException {
        String protocol = webRequestSettings.getUrl().getProtocol();
        if (protocol.equals("about")) {
            return this.makeWebResponseForAboutUrl(webRequestSettings.getUrl());
        }
        if (protocol.equals("file")) {
            return this.makeWebResponseForFileUrl(webRequestSettings.getUrl(), webRequestSettings.getCharset());
        }
        if (!protocol.equals("data")) return this.loadWebResponseFromWebConnection(webRequestSettings, 20);
        if (!this.browserVersion_.isFirefox()) throw new MalformedURLException("Unknown protocol: data");
        return this.makeWebResponseForDataUrl(webRequestSettings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebResponse loadWebResponseFromWebConnection(WebRequestSettings webRequestSettings, int nbAllowedRedirections) throws IOException {
        URL newUrl;
        URL url = webRequestSettings.getUrl();
        HttpMethod method = webRequestSettings.getHttpMethod();
        List<NameValuePair> parameters = webRequestSettings.getRequestParameters();
        WebAssert.notNull("url", url);
        WebAssert.notNull("method", (Object)method);
        WebAssert.notNull("parameters", parameters);
        this.getLog().debug("Load response for " + url.toExternalForm());
        if (webRequestSettings.getProxyHost() == null && !this.proxyConfig_.shouldBypassProxy(webRequestSettings.getUrl().getHost())) {
            webRequestSettings.setProxyHost(this.proxyConfig_.getProxyHost());
            webRequestSettings.setProxyPort(this.proxyConfig_.getProxyPort());
        }
        URL fixedUrl = this.encodeUrl(url);
        webRequestSettings.setUrl(fixedUrl);
        webRequestSettings.getAdditionalHeaders().putAll(this.requestHeaders_);
        WebResponse webResponse = this.getWebConnection().getResponse(webRequestSettings);
        int statusCode = webResponse.getStatusCode();
        if (statusCode == 305) {
            this.getIncorrectnessListener().notify("Ignoring HTTP status code [305] 'Use Proxy'", this);
            return webResponse;
        }
        if (statusCode < 301) return webResponse;
        if (statusCode > 307) return webResponse;
        if (!this.isRedirectEnabled()) return webResponse;
        String locationString = null;
        try {
            locationString = webResponse.getResponseHeaderValue("Location");
            newUrl = WebClient.expandUrl(fixedUrl, locationString);
        }
        catch (MalformedURLException e) {
            this.getIncorrectnessListener().notify("Got a redirect status code [" + statusCode + " " + webResponse.getStatusMessage() + "] but the location is not a valid URL [" + locationString + "]. Skipping redirection processing.", this);
            return webResponse;
        }
        this.getLog().debug("Got a redirect status code [" + statusCode + "] new location=[" + locationString + "]");
        if (webRequestSettings.getHttpMethod() == HttpMethod.GET && webResponse.getRequestUrl().toExternalForm().equals(locationString)) {
            if (nbAllowedRedirections == 0) {
                this.getLog().warn("Max redirections allowed to the same location reached for [" + locationString + "]. Skipping redirection.");
                return webResponse;
            }
            this.getLog().debug("Got a redirect with location same as the page we just loaded. Nb self redirection allowed: " + nbAllowedRedirections);
            return this.loadWebResponseFromWebConnection(webRequestSettings, nbAllowedRedirections - 1);
        }
        if ((statusCode == 301 || statusCode == 307) && method.equals((Object)HttpMethod.GET)) {
            WebRequestSettings wrs = new WebRequestSettings(newUrl);
            wrs.setRequestParameters(parameters);
            Iterator<Map.Entry<String, String>> i$ = webRequestSettings.getAdditionalHeaders().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> entry = i$.next();
                wrs.addAdditionalHeader(entry.getKey(), entry.getValue());
            }
            return this.loadWebResponse(wrs);
        }
        if (statusCode > 303) return webResponse;
        WebRequestSettings wrs = new WebRequestSettings(newUrl);
        wrs.setHttpMethod(HttpMethod.GET);
        Iterator<Map.Entry<String, String>> i$ = webRequestSettings.getAdditionalHeaders().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, String> entry = i$.next();
            wrs.addAdditionalHeader(entry.getKey(), entry.getValue());
        }
        return this.loadWebResponse(wrs);
    }

    protected URL encodeUrl(URL url) throws MalformedURLException, URIException {
        String path = url.getPath();
        String fixedPath = this.encode(path, URI.allowed_abs_path);
        String query = url.getQuery();
        String fixedQuery = this.encode(query, URI.allowed_query);
        if (!StringUtils.equals(path, fixedPath) || !StringUtils.equals(query, fixedQuery)) {
            StringBuilder newUrl = new StringBuilder();
            newUrl.append(url.getProtocol());
            newUrl.append("://");
            newUrl.append(url.getHost());
            if (url.getPort() != -1) {
                newUrl.append(":");
                newUrl.append(url.getPort());
            }
            newUrl.append(fixedPath);
            if (url.getUserInfo() != null) {
                newUrl.append(url.getUserInfo());
            }
            if (fixedQuery != null) {
                newUrl.append("?");
                newUrl.append(fixedQuery);
            }
            if (url.getRef() != null) {
                newUrl.append("#");
                newUrl.append(url.getRef());
            }
            return new URL(newUrl.toString());
        }
        return url;
    }

    private String encode(String str, BitSet allowed) throws URIException {
        if (str == null) {
            return null;
        }
        BitSet bits = new BitSet(str.length());
        bits.set(37);
        bits.set(43);
        bits.or(allowed);
        return URIUtil.encode(str, bits);
    }

    public List<WebWindow> getWebWindows() {
        return Collections.unmodifiableList(this.windows_);
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler_ = handler == null ? new ImmediateRefreshHandler() : handler;
    }

    public RefreshHandler getRefreshHandler() {
        return this.refreshHandler_;
    }

    public void setScriptPreProcessor(ScriptPreProcessor scriptPreProcessor) {
        this.scriptPreProcessor_ = scriptPreProcessor;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor_;
    }

    public void setActiveXObjectMap(Map<String, String> activeXObjectMap) {
        this.activeXObjectMap_ = activeXObjectMap;
    }

    public Map<String, String> getActiveXObjectMap() {
        return this.activeXObjectMap_;
    }

    public void setActiveXNative(boolean allow) {
        this.activeXNative_ = allow;
    }

    public boolean isActiveXNative() {
        return this.activeXNative_;
    }

    public void setHTMLParserListener(HTMLParserListener listener) {
        this.htmlParserListener_ = listener;
    }

    public HTMLParserListener getHTMLParserListener() {
        return this.htmlParserListener_;
    }

    public ErrorHandler getCssErrorHandler() {
        return this.cssErrorHandler_;
    }

    public void setCssErrorHandler(ErrorHandler cssErrorHandler) {
        WebAssert.notNull("cssErrorHandler", cssErrorHandler);
        this.cssErrorHandler_ = cssErrorHandler;
    }

    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        HTMLParser.setIgnoreOutsideContent(ignoreOutsideContent);
    }

    public static boolean getIgnoreOutsideContent() {
        return HTMLParser.getIgnoreOutsideContent();
    }

    public void setJavaScriptTimeout(long timeout) {
        this.scriptEngine_.getContextFactory().setTimeout(timeout);
    }

    public long getJavaScriptTimeout() {
        return this.scriptEngine_.getContextFactory().getTimeout();
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public boolean isThrowExceptionOnScriptError() {
        return this.throwExceptionOnScriptError_;
    }

    public void setThrowExceptionOnScriptError(boolean newValue) {
        this.throwExceptionOnScriptError_ = newValue;
    }

    public IncorrectnessListener getIncorrectnessListener() {
        return this.incorrectnessListener_;
    }

    public void setIncorrectnessListener(IncorrectnessListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null incorrectness listener.");
        }
        this.incorrectnessListener_ = listener;
    }

    public AjaxController getAjaxController() {
        return this.ajaxController_;
    }

    public void setAjaxController(AjaxController newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.ajaxController_ = newValue;
    }

    public void setAttachmentHandler(AttachmentHandler handler) {
        this.attachmentHandler_ = handler;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler_;
    }

    public void setOnbeforeunloadHandler(OnbeforeunloadHandler onbeforeunloadHandler) {
        this.onbeforeunloadHandler_ = onbeforeunloadHandler;
    }

    public OnbeforeunloadHandler getOnbeforeunloadHandler() {
        return this.onbeforeunloadHandler_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache should not be null!");
        }
        this.cache_ = cache;
    }

    public void closeAllWindows() {
        ArrayList<TopLevelWindow> topWindows = new ArrayList<TopLevelWindow>();
        for (TopLevelWindow window : this.topLevelWindows_) {
            if (!(window instanceof TopLevelWindow)) continue;
            topWindows.add(window);
        }
        for (TopLevelWindow topWindow : topWindows) {
            if (!this.topLevelWindows_.contains(topWindow)) continue;
            topWindow.close();
        }
    }

    public int waitForBackgroundJavaScript(long timeoutMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            long newTimeout = endTime - System.currentTimeMillis();
            count += window.getJobManager().waitForJobs(newTimeout);
        }
        if (count != this.getAggregateJobCount()) {
            long newTimeout = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScript(newTimeout);
        }
        return count;
    }

    public int waitForBackgroundJavaScriptStartingBefore(long delayMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + delayMillis;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            long newDelay = endTime - System.currentTimeMillis();
            count += window.getJobManager().waitForJobsStartingBefore(newDelay);
        }
        if (count != this.getAggregateJobCount()) {
            long newDelay = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScriptStartingBefore(newDelay);
        }
        return count;
    }

    private int getAggregateJobCount() {
        int count = 0;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            count += window.getJobManager().getJobCount();
        }
        return count;
    }

    static {
        URL tmpUrl = null;
        try {
            tmpUrl = new URL(null, "about:blank", AboutUrlStreamHandler_);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        URL_ABOUT_BLANK = tmpUrl;
        WEB_RESPONSE_FOR_ABOUT_BLANK = new StringWebResponse("", URL_ABOUT_BLANK);
    }

    class CurrentWindowTracker
    implements WebWindowListener,
    Serializable {
        private static final long serialVersionUID = -987538223249485123L;

        CurrentWindowTracker() {
        }

        public void webWindowClosed(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)event.getWebWindow();
                WebClient.this.topLevelWindows_.remove(tlw);
                if (tlw.equals(WebClient.this.getCurrentWindow())) {
                    if (WebClient.this.topLevelWindows_.isEmpty()) {
                        TopLevelWindow newWindow = new TopLevelWindow("", WebClient.this);
                        WebClient.this.topLevelWindows_.push(newWindow);
                        WebClient.this.setCurrentWindow(newWindow);
                    } else {
                        WebClient.this.setCurrentWindow((WebWindow)WebClient.this.topLevelWindows_.peek());
                    }
                }
            } else if (event.getWebWindow() == WebClient.this.getCurrentWindow()) {
                WebClient.this.setCurrentWindow((WebWindow)WebClient.this.topLevelWindows_.peek());
            }
        }

        public void webWindowContentChanged(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            boolean takeItAsNew = window instanceof TopLevelWindow && event.getOldPage() == null ? true : (WebClient.this.getJavaScriptEngine().isScriptRunning() ? !(window instanceof FrameWindow) || "complete".equals(((FrameWindow)window).getEnclosingPage().getDocumentElement().getReadyState()) : false);
            if (takeItAsNew) {
                WebClient.this.setCurrentWindow(window);
            }
        }

        public void webWindowOpened(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)event.getWebWindow();
                WebClient.this.topLevelWindows_.push(tlw);
            }
        }
    }

    private static final class BinaryWebResponse
    extends WebResponseImpl {
        private static final long serialVersionUID = 8000117717229261957L;
        private final byte[] data_;

        private static WebResponseData getWebResponseData(byte[] data, String contentType) {
            ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
            compiledHeaders.add(new NameValuePair("Content-Type", contentType));
            return new WebResponseData(data, 200, "OK", compiledHeaders);
        }

        private BinaryWebResponse(byte[] data, URL originatingURL, String contentType) {
            super(BinaryWebResponse.getWebResponseData(data, contentType), originatingURL, HttpMethod.GET, 0L);
            this.data_ = data;
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.data_);
        }
    }
}

