/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlButton
extends ClickableElement
implements DisabledElement,
SubmittableElement {
    private static final long serialVersionUID = 4828725767615187345L;
    public static final String TAG_NAME = "button";
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());

    HtmlButton(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        String type = this.getTypeAttribute().toLowerCase();
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            if (type.equals("submit")) {
                return form.submit(this);
            }
            if (type.equals("reset")) {
                return form.reset();
            }
        }
        return defaultPage;
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    @Override
    public void reset() {
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug("reset() not implemented for this element");
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug("setDefaultValue() not implemented for this element");
        }
    }

    @Override
    public String getDefaultValue() {
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug("getDefaultValue() not implemented for this element");
        }
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getValueAttribute() {
        return this.getAttribute("value");
    }

    public final String getTypeAttribute() {
        String type = this.getAttribute("type");
        if (type == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            BrowserVersion browser = this.getPage().getWebClient().getBrowserVersion();
            type = browser.isIE() ? TAG_NAME : "submit";
        }
        return type;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }
}

