/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMeta
extends HtmlElement {
    private static final long serialVersionUID = 7408601325303605790L;
    public static final String TAG_NAME = "meta";

    HtmlMeta(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if ("set-cookie".equalsIgnoreCase(this.getHttpEquivAttribute())) {
            this.performSetCookie();
        }
    }

    protected void performSetCookie() {
        String[] parts = this.getContentAttribute().split("\\s*;\\s*");
        String name = StringUtils.substringBefore(parts[0], "=");
        String value = StringUtils.substringAfter(parts[0], "=");
        Cookie cookie = new Cookie(this.getPage().getWebResponse().getRequestUrl().getHost(), name, value);
        for (int i = 1; i < parts.length; ++i) {
            String partName = StringUtils.substringBefore(parts[i], "=").trim().toLowerCase();
            String partValue = StringUtils.substringAfter(parts[i], "=").trim();
            if ("path".equals(partName)) {
                cookie.setPath(partValue);
            } else if ("expires".equals(partName)) {
                try {
                    cookie.setExpiryDate(DateUtil.parseDate(partValue));
                }
                catch (DateParseException e) {
                    this.notifyIncorrectness("set-cookie http-equiv meta tag: can't parse expiration date >" + partValue + "<.");
                }
            } else {
                this.notifyIncorrectness("set-cookie http-equiv meta tag: unknown attribute >" + partName + "<");
            }
            this.getPage().getWebClient().getCookieManager().addCookie(cookie);
        }
    }

    public final String getHttpEquivAttribute() {
        return this.getAttribute("http-equiv");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getContentAttribute() {
        return this.getAttribute("content");
    }

    public final String getSchemeAttribute() {
        return this.getAttribute("scheme");
    }
}

