/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.javascript.ScriptableWrapper;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodWrapper
extends ScriptableObject
implements Function {
    private static final long serialVersionUID = 6106771000496895783L;
    private final Class<?> clazz_;
    private final Method method_;
    private final int[] jsTypeTags_;

    MethodWrapper(String methodName, Class<?> clazz) throws NoSuchMethodException {
        this(methodName, clazz, ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    MethodWrapper(String methodName, Class<?> clazz, Class<?>[] parameterTypes) throws NoSuchMethodException {
        this.clazz_ = clazz;
        this.method_ = clazz.getMethod(methodName, parameterTypes);
        this.jsTypeTags_ = new int[parameterTypes.length];
        int i = 0;
        for (Class<?> klass : parameterTypes) {
            this.jsTypeTags_[i++] = FunctionObject.getTypeTag(klass);
        }
    }

    @Override
    public String getClassName() {
        return "function " + this.method_.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!(thisObj instanceof ScriptableWrapper)) throw this.buildInvalidCallException(thisObj);
        ScriptableWrapper wrapper = (ScriptableWrapper)thisObj;
        Object wrappedObject = wrapper.getWrappedObject();
        if (!this.clazz_.isInstance(wrappedObject)) throw this.buildInvalidCallException(thisObj);
        Object[] javaArgs = this.convertJSArgsToJavaArgs(context, scope, args);
        try {
            Object javaResp = this.method_.invoke(wrappedObject, javaArgs);
            return Context.javaToJS(javaResp, ScriptableObject.getTopLevelScope(scope));
        }
        catch (Exception e) {
            throw Context.reportRuntimeError("Exception calling wrapped function " + this.method_.getName() + ": " + e.getMessage());
        }
    }

    private RuntimeException buildInvalidCallException(Scriptable thisObj) {
        return Context.reportRuntimeError("Function " + this.method_.getName() + " called on incompatible object: " + thisObj);
    }

    Object[] convertJSArgsToJavaArgs(Context context, Scriptable scope, Object[] jsArgs) {
        if (jsArgs.length != this.jsTypeTags_.length) {
            throw Context.reportRuntimeError("Bad number of parameters for function " + this.method_.getName() + ": expected " + this.jsTypeTags_.length + " got " + jsArgs.length);
        }
        Object[] javaArgs = new Object[jsArgs.length];
        int i = 0;
        for (Object object : jsArgs) {
            javaArgs[i] = FunctionObject.convertArg(context, scope, object, this.jsTypeTags_[i++]);
        }
        return javaArgs;
    }

    @Override
    public Scriptable construct(Context context, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError("Function " + this.method_.getName() + " can't be used as a constructor");
    }
}

