/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Comment;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.Text;
import com.gargoylesoftware.htmlunit.javascript.host.XMLAttr;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDOMParseError;
import com.gargoylesoftware.htmlunit.javascript.host.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.httpclient.NameValuePair;

public class XMLDocument
extends Document {
    private static final long serialVersionUID = 1225601711396578064L;
    private boolean async_ = true;
    private boolean preserveWhiteSpace_;
    private XMLDOMParseError parseError_;

    public XMLDocument() {
        this(null);
    }

    XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("IOException: " + e);
            }
        }
    }

    public void jsxSet_async(boolean async) {
        this.async_ = async;
    }

    public boolean jsxGet_async() {
        return this.async_;
    }

    public boolean jsxFunction_load(String xmlSrouce) {
        if (this.async_) {
            this.getLog().debug("XMLDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            WebRequestSettings settings = new WebRequestSettings(htmlPage.getFullyQualifiedUrl(xmlSrouce));
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(settings);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.jsxGet_parseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl(xmlSrouce);
            this.getLog().debug("Error parsing XML from '" + xmlSrouce + "'", e);
            return false;
        }
    }

    public boolean jsxFunction_loadXML(String strXML) {
        try {
            List<NameValuePair> emptyList = Collections.emptyList();
            WebResponseData data = new WebResponseData(strXML.getBytes(), 200, null, emptyList);
            WebResponseImpl webResponse = new WebResponseImpl(data, (URL)null, (HttpMethod)null, 0L);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow());
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            this.getLog().debug("Error parsing XML\n" + strXML, e);
            return false;
        }
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            scriptable = new Element();
        } else if (domNode instanceof DomAttr) {
            XMLAttr attribute = new XMLAttr();
            attribute.init(domNode.getNodeName(), (DomElement)domNode.getParentNode());
            scriptable = attribute;
        } else {
            scriptable = domNode instanceof DomComment || domNode instanceof DomCData ? new Comment() : (domNode instanceof DomText ? new Text() : super.makeScriptableFor(domNode));
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    public XMLDOMParseError jsxGet_parseError() {
        if (this.parseError_ == null) {
            this.parseError_ = new XMLDOMParseError();
            this.parseError_.setPrototype(this.getPrototype(this.parseError_.getClass()));
            this.parseError_.setParentScope(this.getParentScope());
        }
        return this.parseError_;
    }

    public String jsxGet_xml() {
        XMLSerializer seralizer = new XMLSerializer();
        seralizer.setParentScope(this.getWindow());
        seralizer.setPrototype(this.getPrototype(seralizer.getClass()));
        return seralizer.jsxFunction_serializeToString(this.jsxGet_documentElement());
    }

    public boolean jsxGet_preserveWhiteSpace() {
        return this.preserveWhiteSpace_;
    }

    public void jsxSet_preserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    public void jsxFunction_setProperty(String name, String value) {
    }

    public HTMLCollection jsxFunction_selectNodes(String expression) {
        HTMLCollection collection = new HTMLCollection(this);
        collection.init(this.getDomNodeOrDie(), expression);
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public HTMLCollection jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this);
        collection.init(this.getDomNodeOrDie().getFirstChild(), "//*[local-name()='" + tagName + "']");
        return collection;
    }

    public Object jsxFunction_getElementById(String id) {
        XmlPage xmlPage = (XmlPage)this.getDomNodeOrDie();
        Object domElement = xmlPage.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement == null) {
            return null;
        }
        if (domElement instanceof HtmlElement) {
            return ((HtmlElement)domElement).getScriptObject();
        }
        this.getLog().debug("getElementById(" + id + "): no HTML DOM node found with this ID");
        return null;
    }
}

