/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment.application;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cactus.integration.ant.deployment.application.ApplicationXml;
import org.apache.cactus.integration.ant.deployment.application.ApplicationXmlTag;
import org.apache.cactus.integration.ant.deployment.application.ApplicationXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultApplicationXml
implements ApplicationXml {
    private final Document document;
    private final Element rootElement;
    private static final ApplicationXmlTag[] ELEMENT_ORDER = new ApplicationXmlTag[]{ApplicationXmlTag.ICON, ApplicationXmlTag.DISPLAY_NAME, ApplicationXmlTag.DESCRIPTION, ApplicationXmlTag.MODULE, ApplicationXmlTag.SECURITY_ROLE};

    public DefaultApplicationXml(Document theDocument) {
        this.document = theDocument;
        this.rootElement = theDocument.getDocumentElement();
    }

    public final Document getDocument() {
        return this.document;
    }

    public final ApplicationXmlVersion getVersion() {
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            return ApplicationXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final Element getWebModule(String theWebUri) {
        if (theWebUri == null) {
            throw new NullPointerException();
        }
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || !theWebUri.equals(this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI))) continue;
            return webElement;
        }
        return null;
    }

    public final String getWebModuleContextRoot(String theWebUri) {
        Element webModuleElement = this.getWebModule(theWebUri);
        if (webModuleElement == null) {
            throw new IllegalArgumentException("Web module [" + theWebUri + "] is not defined");
        }
        return this.getNestedText(webModuleElement, ApplicationXmlTag.CONTEXT_ROOT);
    }

    public final Iterator getWebModuleUris() {
        ArrayList<String> webUris = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            String webUri;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || (webUri = this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI)) == null) continue;
            webUris.add(webUri);
        }
        return webUris.iterator();
    }

    public final Iterator getElements(ApplicationXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = this.rootElement.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    public void addWebModule(String theUri, String theContext) {
        Element moduleElement = this.document.createElement(ApplicationXmlTag.MODULE.getTagName());
        Element webElement = this.document.createElement(ApplicationXmlTag.WEB.getTagName());
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.WEB_URI, theUri));
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.CONTEXT_ROOT, theContext));
        moduleElement.appendChild(webElement);
        this.addElement(ApplicationXmlTag.MODULE, moduleElement);
    }

    private Iterator getNestedElements(Element theParent, ApplicationXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = theParent.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    private String getNestedText(Element theElement, ApplicationXmlTag theTag) {
        Node nestedText;
        NodeList nestedElements = theElement.getElementsByTagName(theTag.getTagName());
        if (nestedElements.getLength() > 0 && (nestedText = nestedElements.item(0).getFirstChild()) != null) {
            return nestedText.getNodeValue();
        }
        return null;
    }

    private Element createNestedText(ApplicationXmlTag theTag, String theText) {
        Element element = this.document.createElement(theTag.getTagName());
        element.appendChild(this.document.createTextNode(theText));
        return element;
    }

    public final void addElement(ApplicationXmlTag theTag, Element theElement) {
        Node importedNode = this.document.importNode(theElement, true);
        Node refNode = this.getInsertionPointFor(theTag);
        this.rootElement.insertBefore(importedNode, refNode);
    }

    private Node getInsertionPointFor(ApplicationXmlTag theTag) {
        for (int i = 0; i < ELEMENT_ORDER.length; ++i) {
            if (ELEMENT_ORDER[i] != theTag) continue;
            for (int j = i + 1; j < ELEMENT_ORDER.length; ++j) {
                NodeList elements = this.rootElement.getElementsByTagName(ELEMENT_ORDER[j].getTagName());
                if (elements.getLength() <= 0) continue;
                Node result = elements.item(0);
                Node previous = result.getPreviousSibling();
                while (previous != null && (previous.getNodeType() == 8 || previous.getNodeType() == 3)) {
                    result = previous;
                    previous = result.getPreviousSibling();
                }
                return result;
            }
            break;
        }
        return null;
    }
}

