/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.ant.EARElement;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.ant.WARElement;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.container.configuration.StandaloneConfiguration;

public class ConfigurationElement {
    private String hint = "standalone";
    private File dir;
    private List properties = new ArrayList();
    private Class configurationClass;
    private List wars = new ArrayList();
    private List ears = new ArrayList();

    public final void setClass(Class configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected final Class getConfigurationClass() {
        return this.configurationClass;
    }

    public void addConfiguredWar(WARElement warElement) {
        this.wars.add(warElement);
    }

    public void addConfiguredEar(EARElement earElement) {
        this.ears.add(earElement);
    }

    protected final List getWars() {
        return this.wars;
    }

    protected final List getEars() {
        return this.ears;
    }

    protected final List getProperties() {
        return this.properties;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    public final void setHint(String hint) {
        this.hint = hint;
    }

    public final void setDir(File dir) {
        this.dir = dir;
    }

    public final String getHint() {
        return this.hint;
    }

    public final File getDir() {
        return this.dir;
    }

    public Configuration createConfiguration(Container container) {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getConfigurationClass() != null) {
            factory.registerConfiguration(container.getId(), this.getHint(), this.getConfigurationClass());
        }
        Configuration configuration = this.getDir() == null ? factory.createConfiguration(container, this.getHint()) : factory.createConfiguration(container, this.getHint(), this.getDir());
        Iterator itProperties = this.getProperties().iterator();
        while (itProperties.hasNext()) {
            Property property = (Property)itProperties.next();
            configuration.setProperty(property.getName(), property.getValue());
        }
        if (configuration instanceof StandaloneConfiguration) {
            this.addStaticDeployables(container, (StandaloneConfiguration)configuration);
        }
        return configuration;
    }

    private void addStaticDeployables(Container container, StandaloneConfiguration configuration) {
        Iterator itWars = this.getWars().iterator();
        while (itWars.hasNext()) {
            WARElement warElement = (WARElement)itWars.next();
            configuration.addDeployable(warElement.createWAR(container));
        }
        Iterator itEars = this.getEars().iterator();
        while (itEars.hasNext()) {
            EARElement earElement = (EARElement)itEars.next();
            configuration.addDeployable(earElement.createEAR(container));
        }
    }
}

