/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.webapp.AbstractDescriptorIo;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WebXmlIo
extends AbstractDescriptorIo {
    private WebXmlIo() {
    }

    public static WebXml newWebXml(WebXmlVersion theVersion) throws ParserConfigurationException {
        DocumentBuilder builder = WebXmlIo.createDocumentBuilder();
        DocumentType docType = null;
        if (theVersion != null) {
            docType = builder.getDOMImplementation().createDocumentType("web-app", theVersion.getPublicId(), theVersion.getSystemId());
        }
        Document doc = builder.getDOMImplementation().createDocument("", "web-app", docType);
        return new WebXml(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebXml parseWebXmlFromFile(File theFile, EntityResolver theEntityResolver) throws SAXException, ParserConfigurationException, IOException {
        WebXml webXml;
        block5: {
            FileInputStream in = null;
            try {
                in = new FileInputStream(theFile);
                webXml = WebXmlIo.parseWebXml(in, theEntityResolver);
                Object var5_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (in == null) break block6;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ioe) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return webXml;
    }

    public static WebXml parseWebXml(InputStream theInput, EntityResolver theEntityResolver) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilder builder = WebXmlIo.createDocumentBuilder();
        if (theEntityResolver != null) {
            builder.setEntityResolver(theEntityResolver);
        } else {
            builder.setEntityResolver(new WebXmlEntityResolver());
        }
        return new WebXml(builder.parse(theInput));
    }

    public static void writeWebXml(WebXml theWebXml, File theFile) throws IOException {
        WebXmlIo.writeWebXml(theWebXml, theFile, null, false);
    }

    public static void writeWebXml(WebXml theWebXml, File theFile, String theEncoding) throws IOException {
        WebXmlIo.writeWebXml(theWebXml, theFile, theEncoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeWebXml(WebXml theWebXml, File theFile, String theEncoding, boolean isIndent) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(theFile);
            WebXmlIo.writeWebXml(theWebXml, out, theEncoding, isIndent);
            Object var6_5 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException ioe) {}
    }

    public static void writeWebXml(WebXml theWebXml, OutputStream theOutput, String theEncoding, boolean isIndent) throws IOException {
        OutputFormat outputFormat = new OutputFormat(theWebXml.getDocument());
        if (theEncoding != null) {
            outputFormat.setEncoding(theEncoding);
        }
        outputFormat.setIndenting(isIndent);
        outputFormat.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(theOutput, outputFormat);
        serializer.serialize(theWebXml.getDocument());
    }

    public static File[] writeAll(WebXml webXml, File dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File webXmlFile = new File(dir, "web.xml");
        WebXmlIo.writeWebXml(webXml, webXmlFile, null, true);
        files.add(webXmlFile);
        Iterator vendorDescriptors = webXml.getVendorDescriptors();
        while (vendorDescriptors.hasNext()) {
            VendorWebAppDescriptor descr = (VendorWebAppDescriptor)vendorDescriptors.next();
            File file = new File(dir, descr.getFileName());
            AbstractDescriptorIo.writeDescriptor((Descriptor)descr, file, null, true);
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    private static class WebXmlEntityResolver
    implements EntityResolver {
        private WebXmlEntityResolver() {
        }

        public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException, IOException {
            WebXmlVersion version = WebXmlVersion.valueOf(thePublicId);
            if (version != null) {
                String fileName = version.getSystemId().substring(version.getSystemId().lastIndexOf(47));
                InputStream in = this.getClass().getResourceAsStream("/org/codehaus/cargo/module/internal/resource" + fileName);
                if (in != null) {
                    return new InputSource(in);
                }
            }
            return null;
        }
    }
}

