/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
implements Serializable {
    private static final long serialVersionUID = 4145377365165079425L;
    public static final String HTMLUNIT_COOKIE_POLICY = "compatibility";
    private boolean cookiesEnabled_ = true;
    private final Set<Cookie> cookies_ = new LinkedHashSet<Cookie>();

    public synchronized void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled_ = enabled;
    }

    public synchronized boolean isCookiesEnabled() {
        return this.cookiesEnabled_;
    }

    public synchronized Set<Cookie> getCookies() {
        return Collections.unmodifiableSet(this.cookies_);
    }

    public synchronized Set<Cookie> getCookies(URL url) {
        String host = url.getHost();
        String path = url.getPath();
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        CookieSpec spec = CookiePolicy.getCookieSpec(HTMLUNIT_COOKIE_POLICY);
        org.apache.commons.httpclient.Cookie[] all = Cookie.toHttpClient(this.cookies_);
        org.apache.commons.httpclient.Cookie[] matches = spec.match(host, port, path, secure, all);
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        cookies.addAll(Cookie.fromHttpClient(matches));
        return Collections.unmodifiableSet(cookies);
    }

    public synchronized Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals(cookie.getName(), name)) continue;
            return cookie;
        }
        return null;
    }

    public synchronized void addCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
        this.cookies_.add(cookie);
    }

    public synchronized void removeCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
    }

    public synchronized void clearCookies() {
        this.cookies_.clear();
    }

    protected synchronized void updateState(HttpState state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        state.clearCookies();
        for (Cookie cookie : this.cookies_) {
            state.addCookie(cookie.toHttpClient());
        }
    }

    protected synchronized void updateFromState(HttpState state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        this.cookies_.clear();
        this.cookies_.addAll(Cookie.fromHttpClient(state.getCookies()));
    }
}

