/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCredentialsProvider
implements CredentialsProvider,
Serializable {
    private static final long serialVersionUID = 1036331144926557053L;
    private static final Log LOG = LogFactory.getLog(DefaultCredentialsProvider.class);
    private final Map<AuthScopeProxy, Credentials> credentials_ = new HashMap<AuthScopeProxy, Credentials>();
    private final Map<AuthScopeProxy, Credentials> proxyCredentials_ = new HashMap<AuthScopeProxy, Credentials>();
    private final Set<Object> answerMarks_ = Collections.synchronizedSortedSet(new TreeSet());

    public void addCredentials(String username, String password) {
        this.addCredentials(username, password, AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
    }

    public void addCredentials(String username, String password, String host, int port, String realm) {
        AuthScopeProxy scope = new AuthScopeProxy(host, port, realm, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentialsExt c = new UsernamePasswordCredentialsExt(username, password);
        this.credentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addProxyCredentials(String username, String password) {
        this.addProxyCredentials(username, password, AuthScope.ANY_HOST, -1);
    }

    public void addProxyCredentials(String username, String password, String host, int port) {
        AuthScopeProxy scope = new AuthScopeProxy(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentialsExt c = new UsernamePasswordCredentialsExt(username, password);
        this.proxyCredentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addNTLMCredentials(String username, String password, String host, int port, String clientHost, String clientDomain) {
        AuthScopeProxy scope = new AuthScopeProxy(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        NTCredentialsExt c = new NTCredentialsExt(username, password, clientHost, clientDomain);
        this.credentials_.put(scope, c);
        this.clearAnswered();
    }

    public void addNTLMProxyCredentials(String username, String password, String host, int port, String clientHost, String clientDomain) {
        AuthScopeProxy scope = new AuthScopeProxy(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        NTCredentialsExt c = new NTCredentialsExt(username, password, clientHost, clientDomain);
        this.proxyCredentials_.put(scope, c);
        this.clearAnswered();
    }

    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (this.alreadyAnswered(scheme, host, port, proxy)) {
            LOG.debug("Already answered for " + this.buildKey(scheme, host, port, proxy) + ", returning null");
            return null;
        }
        Map<AuthScopeProxy, Credentials> credentials = proxy ? this.proxyCredentials_ : this.credentials_;
        for (Map.Entry<AuthScopeProxy, Credentials> entry : credentials.entrySet()) {
            AuthScope scope = entry.getKey().getAuthScope();
            Credentials c = entry.getValue();
            if (!this.matchScheme(scope, scheme) || !this.matchHost(scope, host) || !this.matchPort(scope, port) || !this.matchRealm(scope, scheme)) continue;
            this.markAsAnswered(scheme, host, port, proxy);
            LOG.debug("Returning " + c + " for " + this.buildKey(scheme, host, port, proxy));
            return c;
        }
        LOG.debug("No credential found for " + this.buildKey(scheme, host, port, proxy));
        return null;
    }

    protected boolean matchRealm(AuthScope scope, AuthScheme scheme) {
        return scope.getRealm() == AuthScope.ANY_REALM || scope.getRealm().equals(scheme.getRealm());
    }

    protected boolean matchPort(AuthScope scope, int port) {
        return scope.getPort() == -1 || scope.getPort() == port;
    }

    protected boolean matchHost(AuthScope scope, String host) {
        return scope.getHost() == AuthScope.ANY_HOST || scope.getHost().equals(host);
    }

    protected boolean matchScheme(AuthScope scope, AuthScheme scheme) {
        return scope.getScheme() == AuthScope.ANY_SCHEME || scope.getScheme().equals(scheme.getSchemeName());
    }

    protected boolean alreadyAnswered(AuthScheme scheme, String host, int port, boolean proxy) {
        return this.answerMarks_.contains(this.buildKey(scheme, host, port, proxy));
    }

    protected void markAsAnswered(AuthScheme scheme, String host, int port, boolean proxy) {
        this.answerMarks_.add(this.buildKey(scheme, host, port, proxy));
    }

    protected void clearAnswered() {
        this.answerMarks_.clear();
        LOG.debug("Flushed marked answers");
    }

    protected Object buildKey(AuthScheme scheme, String host, int port, boolean proxy) {
        return scheme.getSchemeName() + " " + scheme.getRealm() + " " + host + ":" + port + " " + proxy;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.answerMarks_.clear();
    }

    private static class NTCredentialsExt
    extends NTCredentials
    implements Serializable {
        private static final long serialVersionUID = 1390068355010421017L;

        public NTCredentialsExt(String username, String password, String host, String domain) {
            super(username, password, host, domain);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.getUserName());
            stream.writeObject(this.getPassword());
            stream.writeObject(this.getHost());
            stream.writeObject(this.getDomain());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            String username = (String)stream.readObject();
            String password = (String)stream.readObject();
            String host = (String)stream.readObject();
            String domain = (String)stream.readObject();
            this.setUserName(username);
            this.setPassword(password);
            this.setHost(host);
            this.setDomain(domain);
        }
    }

    private static class UsernamePasswordCredentialsExt
    extends UsernamePasswordCredentials
    implements Serializable {
        private static final long serialVersionUID = 6578356387067132849L;

        public UsernamePasswordCredentialsExt(String username, String password) {
            super(username, password);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.getUserName());
            stream.writeObject(this.getPassword());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            String username = (String)stream.readObject();
            String password = (String)stream.readObject();
            this.setUserName(username);
            this.setPassword(password);
        }
    }

    private static class AuthScopeProxy
    implements Serializable {
        private static final long serialVersionUID = 1464373861677912537L;
        private AuthScope authScope_;

        public AuthScopeProxy(String host, int port, String realm, String scheme) {
            this.authScope_ = new AuthScope(host, port, realm, scheme);
        }

        public AuthScope getAuthScope() {
            return this.authScope_;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.authScope_.getHost());
            stream.writeInt(this.authScope_.getPort());
            stream.writeObject(this.authScope_.getRealm());
            stream.writeObject(this.authScope_.getScheme());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            String host = (String)stream.readObject();
            int port = stream.readInt();
            String realm = (String)stream.readObject();
            String scheme = (String)stream.readObject();
            this.authScope_ = new AuthScope(host, port, realm, scheme);
        }

        public int hashCode() {
            return this.authScope_.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AuthScopeProxy && this.authScope_.equals(((AuthScopeProxy)obj).getAuthScope());
        }
    }
}

