/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlSerializer {
    private final StringBuilder buffer_ = new StringBuilder();
    private final StringBuilder indent_ = new StringBuilder();
    private File outputDir_;
    private WebClient webClient_;

    XmlSerializer() {
    }

    public void save(HtmlPage page, File file) throws IOException {
        File outputFile;
        this.webClient_ = page.getWebClient();
        String fileName = file.getName();
        if (!fileName.endsWith(".htm") && !fileName.endsWith(".html")) {
            fileName = fileName + ".html";
        }
        if ((outputFile = new File(file.getParentFile(), fileName)).exists()) {
            throw new IOException("File already exists: " + outputFile);
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        this.outputDir_ = new File(file.getParentFile(), fileName);
        FileUtils.writeStringToFile(outputFile, this.asXml(page.getDocumentElement()));
    }

    public String asXml(HtmlElement node) {
        this.buffer_.setLength(0);
        this.indent_.setLength(0);
        String charsetName = null;
        if (node.getPage() instanceof HtmlPage) {
            charsetName = node.getPage().getPageEncoding();
        }
        if (charsetName != null && node instanceof HtmlHtml) {
            this.buffer_.append("<?xml version=\"1.0\" encoding=\"").append(charsetName).append("\"?>").append('\n');
        }
        this.printXml(node);
        String response = this.buffer_.toString();
        this.buffer_.setLength(0);
        return response;
    }

    protected void printXml(DomElement node) {
        if (!this.isExcluded(node)) {
            boolean hasChildren = node.getFirstChild() != null;
            this.buffer_.append((CharSequence)this.indent_).append('<');
            this.printOpeningTag(node);
            if (!hasChildren && !this.isEmptyXmlTagExpanded(node)) {
                this.buffer_.append("/>").append('\n');
            } else {
                this.buffer_.append(">").append('\n');
                for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.indent_.append("  ");
                    if (child instanceof DomElement) {
                        this.printXml((DomElement)child);
                    } else {
                        this.buffer_.append(child);
                    }
                    this.indent_.setLength(this.indent_.length() - 2);
                }
                this.buffer_.append((CharSequence)this.indent_).append("</").append(node.getTagName()).append('>').append('\n');
            }
        }
    }

    protected boolean isEmptyXmlTagExpanded(DomNode node) {
        return node instanceof HtmlDivision || node instanceof HtmlInlineFrame || node instanceof HtmlOrderedList || node instanceof HtmlScript || node instanceof HtmlSpan || node instanceof HtmlStyle || node instanceof HtmlTable || node instanceof HtmlTitle || node instanceof HtmlUnorderedList;
    }

    protected void printOpeningTag(DomElement node) {
        this.buffer_.append(node.getTagName());
        Map<String, DomAttr> attributes = node instanceof HtmlScript ? this.getAttributesFor((HtmlScript)node) : (node instanceof HtmlImage ? this.getAttributesFor((HtmlImage)node) : (node instanceof HtmlLink ? this.getAttributesFor((HtmlLink)node) : node.getAttributesMap()));
        for (String name : attributes.keySet()) {
            this.buffer_.append(" ");
            this.buffer_.append(name);
            this.buffer_.append("=\"");
            this.buffer_.append(StringEscapeUtils.escapeXml(attributes.get(name).getNodeValue()));
            this.buffer_.append("\"");
        }
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlScript script) {
        HashMap<String, DomAttr> map = new HashMap<String, DomAttr>(script.getAttributesMap());
        String src = ((DomAttr)map.get("src")).getValue();
        try {
            File file = this.createFile(src, ".js");
            String content = this.webClient_.getPage(src).getWebResponse().getContentAsString();
            FileUtils.writeStringToFile(file, content);
            ((DomAttr)map.get("src")).setValue(this.outputDir_.getName() + File.separatorChar + file.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlLink link) {
        HashMap<String, DomAttr> map = new HashMap<String, DomAttr>(link.getAttributesMap());
        String src = ((DomAttr)map.get("href")).getValue();
        try {
            File file = this.createFile(src, ".css");
            FileUtils.writeStringToFile(file, link.getWebResponse(true).getContentAsString());
            ((DomAttr)map.get("href")).setValue(this.outputDir_.getName() + File.separatorChar + file.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlImage image) {
        HashMap<String, DomAttr> map = new HashMap<String, DomAttr>(image.getAttributesMap());
        String src = ((DomAttr)map.get("src")).getValue();
        try {
            ImageReader reader = image.getImageReader();
            File file = this.createFile(src, "." + reader.getFormatName());
            image.saveAs(file);
            this.outputDir_.mkdirs();
            ((DomAttr)map.get("src")).setValue(this.outputDir_.getName() + File.separatorChar + file.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    protected boolean isExcluded(DomElement element) {
        return element instanceof HtmlScript;
    }

    private File createFile(String url, String extension) throws IOException {
        String name = url.replaceFirst("/$", "").replaceAll(".*/", "");
        name = StringUtils.substringBefore(name, "?");
        if (!(name = StringUtils.substringBefore(name, ";")).endsWith(extension)) {
            name = name + extension;
        }
        int counter = 0;
        while (true) {
            String fileName = counter != 0 ? StringUtils.substringBeforeLast(name, ".") + "_" + counter + "." + StringUtils.substringAfterLast(name, ".") : name;
            this.outputDir_.mkdirs();
            File f = new File(this.outputDir_, fileName);
            if (f.createNewFile()) {
                return f;
            }
            ++counter;
        }
    }
}

