/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.impl;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import java.io.Serializable;
import java.util.Iterator;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class SimpleRange
implements Range,
Serializable {
    private static final long serialVersionUID = 5779974839466976193L;
    private Node startContainer_;
    private Node endContainer_;
    private int startOffset_;
    private int endOffset_;

    public SimpleRange() {
    }

    public SimpleRange(Node node) {
        this.startContainer_ = node;
        this.endContainer_ = node;
        this.startOffset_ = 0;
        this.endOffset_ = SimpleRange.getMaxOffset(node);
    }

    public SimpleRange(Node node, int offset) {
        this.startContainer_ = node;
        this.endContainer_ = node;
        this.startOffset_ = offset;
        this.endOffset_ = offset;
    }

    public SimpleRange(Node startNode, int startOffset, Node endNode, int endOffset) {
        this.startContainer_ = startNode;
        this.endContainer_ = endNode;
        this.startOffset_ = startOffset;
        this.endOffset_ = endOffset;
    }

    public DocumentFragment cloneContents() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public Range cloneRange() throws DOMException {
        return new SimpleRange(this.startContainer_, this.startOffset_, this.endContainer_, this.endOffset_);
    }

    public void collapse(boolean toStart) throws DOMException {
        if (toStart) {
            this.endContainer_ = this.startContainer_;
            this.endOffset_ = this.startOffset_;
        } else {
            this.startContainer_ = this.endContainer_;
            this.startOffset_ = this.endOffset_;
        }
    }

    public short compareBoundaryPoints(short how, Range sourceRange) throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void deleteContents() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void detach() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public DomDocumentFragment extractContents() throws DOMException {
        DomNode n;
        DomNode ancestor = (DomNode)this.getCommonAncestorContainer();
        DomNode ancestorClone = ancestor.cloneNode(true);
        DomNode startClone = null;
        DomNode endClone = null;
        DomNode start = (DomNode)this.startContainer_;
        DomNode end = (DomNode)this.endContainer_;
        if (start == ancestor) {
            startClone = ancestorClone;
        }
        if (end == ancestor) {
            endClone = ancestorClone;
        }
        Iterable<DomNode> descendants = ancestor.getDescendants();
        if (startClone == null || endClone == null) {
            Iterator<DomNode> i = descendants.iterator();
            Iterator<DomNode> ci = ancestorClone.getDescendants().iterator();
            while (i.hasNext()) {
                DomNode e = i.next();
                DomNode ce = ci.next();
                if (start == e) {
                    startClone = ce;
                    continue;
                }
                if (end != e) continue;
                endClone = ce;
                break;
            }
        }
        if (startClone == null) {
            throw Context.reportRuntimeError("Unable to find start node clone.");
        }
        SimpleRange.deleteBefore(startClone, this.startOffset_);
        for (n = startClone; n != null; n = n.getParentNode()) {
            for (DomNode prev = n.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                prev.remove();
            }
        }
        if (endClone == null) {
            throw Context.reportRuntimeError("Unable to find end node clone.");
        }
        SimpleRange.deleteAfter(endClone, this.endOffset_);
        for (n = endClone; n != null; n = n.getParentNode()) {
            for (DomNode next = n.getNextSibling(); next != null; next = next.getNextSibling()) {
                next.remove();
            }
        }
        boolean foundStartNode = ancestor == start;
        boolean started = false;
        boolean foundEndNode = false;
        Iterator<DomNode> i = ancestor.getDescendants().iterator();
        while (i.hasNext()) {
            DomNode n2 = i.next();
            if (!foundStartNode) {
                boolean bl = foundStartNode = n2 == start;
                if (foundStartNode && SimpleRange.isOffsetChars(n2)) {
                    started = true;
                    String text = SimpleRange.getText(n2);
                    text = text.substring(0, this.startOffset_);
                    SimpleRange.setText(n2, text);
                }
            } else if (!started) {
                boolean atStart = n2.getParentNode() == start && n2.getIndex() == this.startOffset_;
                boolean beyondStart = !start.isAncestorOf(n2);
                boolean bl = started = atStart || beyondStart;
            }
            if (!started) continue;
            if (!foundEndNode) {
                boolean bl = foundEndNode = n2 == end;
            }
            if (!foundEndNode) {
                if (n2.isAncestorOfAny(start, end)) continue;
                i.remove();
                continue;
            }
            if (SimpleRange.isOffsetChars(n2)) {
                String text = SimpleRange.getText(n2);
                text = text.substring(this.endOffset_);
                SimpleRange.setText(n2, text);
                break;
            }
            NodeList children = n2.getChildNodes();
            for (int j = this.endOffset_ - 1; j >= 0; --j) {
                ((DomNode)children.get(j)).remove();
            }
        }
        SgmlPage page = ancestor.getPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        Iterator i$ = ancestorClone.getChildNodes().iterator();
        while (i$.hasNext()) {
            DomNode n3 = (DomNode)i$.next();
            fragment.appendChild(n3);
        }
        return fragment;
    }

    public boolean getCollapsed() throws DOMException {
        return this.startContainer_ == this.endContainer_ && this.startOffset_ == this.endOffset_;
    }

    public Node getCommonAncestorContainer() throws DOMException {
        if (this.startContainer_ != null && this.endContainer_ != null) {
            for (Node p1 = this.startContainer_; p1 != null; p1 = p1.getParentNode()) {
                for (Node p2 = this.endContainer_; p2 != null; p2 = p2.getParentNode()) {
                    if (p1 != p2) continue;
                    return p1;
                }
            }
        }
        return null;
    }

    public Node getEndContainer() throws DOMException {
        return this.endContainer_;
    }

    public int getEndOffset() throws DOMException {
        return this.endOffset_;
    }

    public Node getStartContainer() throws DOMException {
        return this.startContainer_;
    }

    public int getStartOffset() throws DOMException {
        return this.startOffset_;
    }

    public void insertNode(Node newNode) throws DOMException, RangeException {
        throw new RuntimeException("Not implemented!");
    }

    public void selectNode(Node node) throws RangeException, DOMException {
        this.startContainer_ = node;
        this.startOffset_ = 0;
        this.endContainer_ = node;
        this.endOffset_ = SimpleRange.getMaxOffset(node);
    }

    public void selectNodeContents(Node node) throws RangeException, DOMException {
        this.startContainer_ = node.getFirstChild();
        this.startOffset_ = 0;
        this.endContainer_ = node.getLastChild();
        this.endOffset_ = SimpleRange.getMaxOffset(node.getLastChild());
    }

    public void setEnd(Node refNode, int offset) throws RangeException, DOMException {
        this.endContainer_ = refNode;
        this.endOffset_ = offset;
    }

    public void setEndAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setEndBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setStart(Node refNode, int offset) throws RangeException, DOMException {
        this.startContainer_ = refNode;
        this.startOffset_ = offset;
    }

    public void setStartAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setStartBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void surroundContents(Node newParent) throws DOMException, RangeException {
        throw new RuntimeException("Not implemented!");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleRange)) {
            return false;
        }
        SimpleRange other = (SimpleRange)obj;
        return new EqualsBuilder().append(this.startContainer_, other.startContainer_).append(this.endContainer_, other.endContainer_).append(this.startOffset_, other.startOffset_).append(this.endOffset_, other.endOffset_).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.startContainer_).append(this.endContainer_).append(this.startOffset_).append(this.endOffset_).toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }

    private void append(StringBuilder sb) {
        if (this.startContainer_ == this.endContainer_) {
            if (this.startOffset_ == this.endOffset_) {
                return;
            }
            if (SimpleRange.isOffsetChars(this.startContainer_)) {
                sb.append(SimpleRange.getText(this.startContainer_).substring(this.startOffset_, this.endOffset_));
                return;
            }
        }
        DomNode ancestor = (DomNode)this.getCommonAncestorContainer();
        DomNode start = (DomNode)this.startContainer_;
        DomNode end = (DomNode)this.endContainer_;
        boolean foundStartNode = ancestor == start;
        boolean started = false;
        boolean foundEndNode = false;
        for (DomNode n : ancestor.getDescendants()) {
            if (!foundStartNode) {
                boolean bl = foundStartNode = n == start;
                if (foundStartNode && SimpleRange.isOffsetChars(n)) {
                    started = true;
                    String text = SimpleRange.getText(n);
                    text = text.substring(this.startOffset_);
                    sb.append(text);
                }
            } else if (!started) {
                boolean atStart = n.getParentNode() == start && n.getIndex() == this.startOffset_;
                boolean beyondStart = !start.isAncestorOf(n);
                boolean bl = started = atStart || beyondStart;
            }
            if (!started) continue;
            if (!foundEndNode) {
                boolean bl = foundEndNode = n == end;
            }
            if (!foundEndNode) {
                if (n.isAncestorOfAny(start, end) || !SimpleRange.isOffsetChars(n)) continue;
                sb.append(SimpleRange.getText(n));
                continue;
            }
            if (SimpleRange.isOffsetChars(n)) {
                String text = SimpleRange.getText(n);
                text = text.substring(0, this.endOffset_);
                sb.append(text);
                break;
            }
            NodeList children = n.getChildNodes();
            for (int j = 0; j < this.endOffset_; ++j) {
                sb.append(SimpleRange.getText((Node)children.get(j)));
            }
        }
    }

    private static boolean isOffsetChars(Node node) {
        return node instanceof DomText || node instanceof SelectableTextInput;
    }

    private static String getText(Node node) {
        if (node instanceof SelectableTextInput) {
            return ((SelectableTextInput)node).getText();
        }
        return node.getTextContent();
    }

    private static void setText(Node node, String text) {
        if (node instanceof SelectableTextInput) {
            ((SelectableTextInput)node).setText(text);
        } else {
            node.setTextContent(text);
        }
    }

    private static void deleteBefore(DomNode node, int offset) {
        if (SimpleRange.isOffsetChars(node)) {
            String text = SimpleRange.getText(node);
            text = text.substring(offset);
            SimpleRange.setText(node, text);
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < offset && i < children.getLength(); --offset, ++i) {
                DomNode child = (DomNode)children.get(i);
                child.remove();
                --i;
            }
        }
    }

    private static void deleteAfter(DomNode node, int offset) {
        if (SimpleRange.isOffsetChars(node)) {
            String text = SimpleRange.getText(node);
            text = text.substring(0, offset);
            SimpleRange.setText(node, text);
        } else {
            NodeList children = node.getChildNodes();
            for (int i = offset; i < children.getLength(); ++i) {
                DomNode child = (DomNode)children.get(i);
                child.remove();
                --i;
            }
        }
    }

    private static int getMaxOffset(Node node) {
        return SimpleRange.isOffsetChars(node) ? SimpleRange.getText(node).length() : node.getChildNodes().getLength();
    }
}

