/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine {
    private static final long serialVersionUID = -5414040051465432088L;
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient ThreadLocal<Boolean> holdPostponedActions_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    LOG.error("Exception while initializing JavaScript for the page", e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        WebClient webClient = webWindow.getWebClient();
        HashMap<Class<? extends SimpleScriptable>, Scriptable> prototypes = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
        HashMap<String, ScriptableObject> prototypesPerJSName = new HashMap<String, ScriptableObject>();
        Window window = new Window();
        JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
        context.initStandardObjects(window);
        this.deleteProperties(window, "javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation");
        if (webClient.getBrowserVersion().isIE()) {
            this.deleteProperties(window, "Packages", "java", "getClass", "XML", "XMLList", "Namespace", "QName");
        }
        FallbackCaller fallbackCaller = new FallbackCaller();
        ScriptableObject.getObjectPrototype(window).setPrototype(fallbackCaller);
        for (String jsClassName : jsConfig.keySet()) {
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            boolean isWindow = Window.class.getName().equals(config.getLinkedClass().getName());
            if (isWindow) {
                this.configureConstantsPropertiesAndFunctions(config, window);
                continue;
            }
            ScriptableObject prototype = this.configureClass(config, window);
            if (config.isJsObject()) {
                if (!this.getWebClient().getBrowserVersion().isIE()) {
                    SimpleScriptable obj = config.getLinkedClass().newInstance();
                    prototype.defineProperty("__proto__", prototype, 2);
                    obj.defineProperty("prototype", prototype, 2);
                    obj.setParentScope(window);
                    ScriptableObject.defineProperty(window, config.getClassName(), obj, 2);
                    this.configureConstants(config, obj);
                    if (obj.getClass() == Element.class && webWindow.getEnclosedPage() instanceof HtmlPage) {
                        HtmlDivision domNode = new HtmlDivision(null, "", (SgmlPage)webWindow.getEnclosedPage(), null);
                        obj.setDomNode(domNode);
                    }
                }
                prototypes.put(config.getLinkedClass(), prototype);
            }
            prototypesPerJSName.put(config.getClassName(), prototype);
        }
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype(window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = jsConfig.getClassConfiguration(name);
            Scriptable prototype = (Scriptable)entry.getValue();
            if (prototype.getPrototype() != null) {
                prototype = prototype.getPrototype();
            }
            if (!StringUtils.isEmpty(config.getExtendedClass())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClass());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(objectPrototype);
        }
        Class[] evalFnTypes = new Class[]{String.class};
        Method evalFn = Window.class.getMethod("custom_eval", evalFnTypes);
        FunctionObject jsCustomEval = new FunctionObject("eval", evalFn, window);
        window.associateValue("custom_eval", jsCustomEval);
        for (String jsClassName : jsConfig.keySet()) {
            Scriptable prototype;
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            Method jsConstructor = config.getJsConstructor();
            if (jsConstructor == null || (prototype = (Scriptable)prototypesPerJSName.get(jsClassName)) == null) continue;
            FunctionObject jsCtor = new FunctionObject(jsClassName, jsConstructor, window);
            jsCtor.addAsConstructor(window, prototype);
        }
        this.removePrototypeProperties(window, "String", "equals", "equalsIgnoreCase", "trim");
        this.removePrototypeProperties(window, "Function", "bind");
        this.removePrototypeProperties(window, "Date", "toISOString", "toJSON");
        if (webClient.getBrowserVersion().isIE()) {
            this.deleteProperties(window, "isXMLName", "uneval");
            this.removePrototypeProperties(window, "Object", "__defineGetter__", "__defineSetter__", "__lookupGetter__", "__lookupSetter__", "toSource");
            this.removePrototypeProperties(window, "Array", "every", "filter", "forEach", "indexOf", "lastIndexOf", "map", "reduce", "reduceRight", "some", "toSource");
            this.removePrototypeProperties(window, "Date", "toSource");
            this.removePrototypeProperties(window, "Function", "toSource");
            this.removePrototypeProperties(window, "Number", "toSource");
            this.removePrototypeProperties(window, "String", "toSource");
        } else if ("FF2".equals(webClient.getBrowserVersion().getNickname())) {
            this.removePrototypeProperties(window, "Array", "reduce", "reduceRight");
        }
        window.setPrototypes(prototypes);
        window.initialize(webWindow);
    }

    private void deleteProperties(Window window, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            window.delete(property);
        }
    }

    private void removePrototypeProperties(Window window, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    private ScriptableObject configureClass(ClassConfiguration config, Scriptable window) throws InstantiationException, IllegalAccessException {
        Class<? extends SimpleScriptable> jsHostClass = config.getLinkedClass();
        ScriptableObject prototype = jsHostClass.newInstance();
        prototype.setParentScope(window);
        this.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        this.configureConstants(config, scriptable);
        for (String propertyName : config.propertyKeys()) {
            Method readMethod = config.getPropertyReadMethod(propertyName);
            Method writeMethod = config.getPropertyWriteMethod(propertyName);
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
        int attributes = 0;
        if (this.webClient_.getBrowserVersion().isIE()) {
            attributes = 2;
        }
        for (String functionName : config.functionKeys()) {
            Method method = config.getFunctionMethod(functionName);
            FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
            scriptable.defineProperty(functionName, functionObject, attributes);
        }
    }

    private void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (String constant : config.constants()) {
            Class<? extends SimpleScriptable> linkedClass = config.getLinkedClass();
            try {
                Object value = linkedClass.getField(constant).get(null);
                scriptable.defineProperty(constant, value, 0);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError("Cannot get field '" + constant + "' for type: " + config.getClassName());
            }
        }
    }

    public Script compile(HtmlPage htmlPage, String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        Scriptable scope = this.getScope(htmlPage, null);
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(htmlPage, sourceCode, sourceName, startLine);
        return this.execute(htmlPage, script);
    }

    public Object execute(HtmlPage htmlPage, final Script script) {
        final Scriptable scope = this.getScope(htmlPage, null);
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(final HtmlPage htmlPage, Object javaScriptFunction, final Object thisObject, final Object[] args, DomNode htmlElement) {
        final Scriptable scope = this.getScope(htmlPage, htmlElement);
        final Function function = (Function)javaScriptFunction;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return JavaScriptEngine.this.callFunction(htmlPage, function, cx, scope, (Scriptable)thisObject, args);
            }

            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private Scriptable getScope(HtmlPage htmlPage, DomNode htmlElement) {
        ScriptableObject scope = htmlElement != null ? htmlElement.getScriptObject() : (Window)htmlPage.getEnclosingWindow().getScriptObject();
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(HtmlPage htmlPage, Function function, Context context, Scriptable scope, Scriptable thisObject, Object[] args) {
        HtmlPage htmlPage2 = htmlPage;
        synchronized (htmlPage2) {
            Object result = function.call(context, scope, thisObject, args);
            this.doProcessPostponedActions();
            return result;
        }
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    private void doProcessPostponedActions() {
        if (Boolean.TRUE.equals(this.holdPostponedActions_.get())) {
            return;
        }
        try {
            this.getWebClient().loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        this.postponedActions_.set(null);
        if (actions != null) {
            try {
                for (PostponedAction action : actions) {
                    Page owningPage = action.getOwningPage();
                    if (owningPage == null || owningPage != owningPage.getEnclosingWindow().getEnclosedPage()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException) {
        Window w;
        WebWindow window;
        HtmlPage page = scriptException.getPage();
        if (page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptObject()) != null) {
            w.triggerOnError(scriptException);
        }
        if (this.getWebClient().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info("Caught script exception", scriptException);
    }

    public void holdPosponedActions() {
        this.holdPostponedActions_.set(Boolean.TRUE);
    }

    public void processPostponedActions() {
        this.holdPostponedActions_.set(Boolean.FALSE);
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = new ThreadLocal();
    }

    private static class FallbackCaller
    extends ScriptableObject {
        private static final long serialVersionUID = -7124423159070941606L;

        private FallbackCaller() {
        }

        public Object get(String name, Scriptable start) {
            if (start instanceof ScriptableWithFallbackGetter) {
                return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
            }
            return NOT_FOUND;
        }

        public String getClassName() {
            return "htmlUnitHelper-fallbackCaller";
        }
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final HtmlPage htmlPage_;

        public HtmlUnitContextAction(Scriptable scope, HtmlPage htmlPage) {
            this.scope_ = scope;
            this.htmlPage_ = htmlPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE, this.scope_);
                cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_PAGE, this.htmlPage_);
                HtmlPage htmlPage = this.htmlPage_;
                synchronized (htmlPage) {
                    try {
                        Object response = this.doRun(cx);
                        JavaScriptEngine.this.doProcessPostponedActions();
                        Object object = response;
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.htmlPage_, e, this.getSourceCode(cx)));
                            Object var4_7 = null;
                            return var4_7;
                        }
                        catch (TimeoutError e) {
                            if (JavaScriptEngine.this.getWebClient().isThrowExceptionOnScriptError()) {
                                throw new RuntimeException(e);
                            }
                            LOG.info("Caught script timeout error", e);
                            Object var4_8 = null;
                            return var4_8;
                        }
                    }
                }
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

