/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Iterator;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.CompilerEnvirons;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Parser;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstNode;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstRoot;
import net.sourceforge.htmlunit.corejs.javascript.ast.NodeVisitor;
import net.sourceforge.htmlunit.corejs.javascript.ast.StringLiteral;

public class StringScriptPreProcessor
implements ScriptPreProcessor {
    private ContextFactory contextFactory_;
    private int lineNo_;

    public StringScriptPreProcessor(ContextFactory contextFactory, int lineno) {
        if (contextFactory == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        this.contextFactory_ = contextFactory;
        this.lineNo_ = lineno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElement) {
        try {
            CompilerEnvirons environs = new CompilerEnvirons();
            environs.initFromContext(this.contextFactory_.enterContext());
            AstRoot root = new Parser(environs).parse(sourceCode, sourceName, this.lineNo_);
            final TreeMap strings = new TreeMap();
            ((AstNode)root).visit(new NodeVisitor(){

                public boolean visit(AstNode node) {
                    if (node instanceof StringLiteral) {
                        strings.put(node.getAbsolutePosition() + 1, node.getLength() - 2);
                    }
                    return true;
                }
            });
            int variant = 0;
            Iterator i$ = strings.keySet().iterator();
            while (i$.hasNext()) {
                int length;
                int index = (Integer)i$.next();
                String string = sourceCode.substring(index + variant, index + variant + (length = ((Integer)strings.get(index)).intValue()));
                String newString = this.replace(string);
                if (newString == null) continue;
                sourceCode = sourceCode.substring(0, index + variant) + newString + sourceCode.substring(index + variant + length);
                variant += newString.length() - string.length();
            }
        }
        finally {
            Context.exit();
        }
        return sourceCode;
    }

    private String replace(String string) {
        if (string.indexOf("\\x") == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (i + 3 < string.length() && string.charAt(i + 1) == 'x') {
                    char character;
                    char ch1 = Character.toUpperCase(string.charAt(i + 2));
                    char ch2 = Character.toUpperCase(string.charAt(i + 3));
                    if ((ch1 >= '0' && ch1 <= '9' || ch1 >= 'A' && ch1 <= 'F') && (ch2 >= '0' && ch2 <= '9' || ch2 >= 'A' && ch2 <= 'F') && (character = (char)Integer.parseInt(string.substring(i + 2, i + 4), 16)) >= ' ') {
                        sb.append(character);
                        i += 3;
                        continue;
                    }
                } else if (i + 1 < string.length()) {
                    sb.append(ch).append(string.charAt(i + 1));
                    ++i;
                    continue;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static int indexOf(String sourceCode, String str, int fromIndex) {
        PARSING_STATUS parsingStatus = PARSING_STATUS.NORMAL;
        char stringChar = '\u0000';
        block7: for (int i = 0; i < sourceCode.length(); ++i) {
            if ((parsingStatus == PARSING_STATUS.NORMAL || parsingStatus == PARSING_STATUS.IN_MULTI_LINE_COMMENT) && i >= fromIndex && i + str.length() <= sourceCode.length() && sourceCode.substring(i, i + str.length()).equals(str)) {
                return i;
            }
            char ch = sourceCode.charAt(i);
            switch (ch) {
                case '/': {
                    char nextCh;
                    if (parsingStatus == PARSING_STATUS.NORMAL && i + 1 < sourceCode.length()) {
                        nextCh = sourceCode.charAt(i + 1);
                        if (nextCh == '/') {
                            parsingStatus = PARSING_STATUS.IN_SINGLE_LINE_COMMENT;
                            continue block7;
                        }
                        if (nextCh == '*') {
                            parsingStatus = PARSING_STATUS.IN_MULTI_LINE_COMMENT;
                            continue block7;
                        }
                        stringChar = ch;
                        parsingStatus = PARSING_STATUS.IN_REG_EXP;
                        continue block7;
                    }
                    if (parsingStatus != PARSING_STATUS.IN_REG_EXP || ch != stringChar) continue block7;
                    stringChar = '\u0000';
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '*': {
                    char nextCh;
                    if (parsingStatus != PARSING_STATUS.IN_MULTI_LINE_COMMENT || i + 1 >= sourceCode.length() || (nextCh = sourceCode.charAt(i + 1)) != '/') continue block7;
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\n': {
                    if (parsingStatus != PARSING_STATUS.IN_SINGLE_LINE_COMMENT) continue block7;
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    if (parsingStatus == PARSING_STATUS.NORMAL) {
                        stringChar = ch;
                        parsingStatus = PARSING_STATUS.IN_STRING;
                        continue block7;
                    }
                    if (parsingStatus != PARSING_STATUS.IN_STRING || ch != stringChar) continue block7;
                    stringChar = '\u0000';
                    parsingStatus = PARSING_STATUS.NORMAL;
                    continue block7;
                }
                case '\\': {
                    if (parsingStatus != PARSING_STATUS.IN_STRING) continue block7;
                    if (i + 3 < sourceCode.length() && sourceCode.charAt(i + 1) == 'x') {
                        char character;
                        char ch1 = Character.toUpperCase(sourceCode.charAt(i + 2));
                        char ch2 = Character.toUpperCase(sourceCode.charAt(i + 3));
                        if ((ch1 < '0' || ch1 > '9') && (ch1 < 'A' || ch1 > 'F') || (ch2 < '0' || ch2 > '9') && (ch2 < 'A' || ch2 > 'F') || (character = (char)Integer.parseInt(sourceCode.substring(i + 2, i + 4), 16)) < ' ') continue block7;
                        i += 3;
                        continue block7;
                    }
                    if (i + 1 >= sourceCode.length()) continue block7;
                    ++i;
                    continue block7;
                }
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PARSING_STATUS {
        NORMAL,
        IN_MULTI_LINE_COMMENT,
        IN_SINGLE_LINE_COMMENT,
        IN_STRING,
        IN_REG_EXP;

    }
}

