/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.html.HtmlAbbreviated;
import com.gargoylesoftware.htmlunit.html.HtmlAcronym;
import com.gargoylesoftware.htmlunit.html.HtmlAddress;
import com.gargoylesoftware.htmlunit.html.HtmlBackgroundSound;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalOverride;
import com.gargoylesoftware.htmlunit.html.HtmlBig;
import com.gargoylesoftware.htmlunit.html.HtmlBlink;
import com.gargoylesoftware.htmlunit.html.HtmlBlockQuote;
import com.gargoylesoftware.htmlunit.html.HtmlBold;
import com.gargoylesoftware.htmlunit.html.HtmlCenter;
import com.gargoylesoftware.htmlunit.html.HtmlCitation;
import com.gargoylesoftware.htmlunit.html.HtmlCode;
import com.gargoylesoftware.htmlunit.html.HtmlDefinition;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionDescription;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionTerm;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmphasis;
import com.gargoylesoftware.htmlunit.html.HtmlExample;
import com.gargoylesoftware.htmlunit.html.HtmlHeading1;
import com.gargoylesoftware.htmlunit.html.HtmlHeading2;
import com.gargoylesoftware.htmlunit.html.HtmlHeading3;
import com.gargoylesoftware.htmlunit.html.HtmlHeading4;
import com.gargoylesoftware.htmlunit.html.HtmlHeading5;
import com.gargoylesoftware.htmlunit.html.HtmlHeading6;
import com.gargoylesoftware.htmlunit.html.HtmlInlineQuotation;
import com.gargoylesoftware.htmlunit.html.HtmlItalic;
import com.gargoylesoftware.htmlunit.html.HtmlKeyboard;
import com.gargoylesoftware.htmlunit.html.HtmlListing;
import com.gargoylesoftware.htmlunit.html.HtmlMarquee;
import com.gargoylesoftware.htmlunit.html.HtmlMultiColumn;
import com.gargoylesoftware.htmlunit.html.HtmlNoBreak;
import com.gargoylesoftware.htmlunit.html.HtmlNoEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPlainText;
import com.gargoylesoftware.htmlunit.html.HtmlS;
import com.gargoylesoftware.htmlunit.html.HtmlSample;
import com.gargoylesoftware.htmlunit.html.HtmlSmall;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStrike;
import com.gargoylesoftware.htmlunit.html.HtmlStrong;
import com.gargoylesoftware.htmlunit.html.HtmlSubscript;
import com.gargoylesoftware.htmlunit.html.HtmlSuperscript;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumn;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumnGroup;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTeletype;
import com.gargoylesoftware.htmlunit.html.HtmlUnderlined;
import com.gargoylesoftware.htmlunit.html.HtmlVariable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorHandler;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDivElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHeadingElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLQuoteElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSpanElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableColElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableSectionElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(JavaScriptConfiguration.class);
    private static Document XmlDocument_;
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int NOT_FOUND = 3;
    private static Map<BrowserVersion, JavaScriptConfiguration> ConfigurationMap_;
    private static Map<String, String> ClassnameMap_;
    private static Map<Class<? extends HtmlElement>, Class<? extends SimpleScriptable>> HtmlJavaScriptMap_;
    private final Map<String, ClassConfiguration> configuration_;

    private JavaScriptConfiguration(BrowserVersion browser) {
        if (XmlDocument_ == null) {
            JavaScriptConfiguration.loadConfiguration();
        }
        if (XmlDocument_ == null) {
            throw new IllegalStateException("Configuration was not initialized - see log for details");
        }
        this.configuration_ = this.buildUsageMap(browser);
    }

    protected static boolean isDocumentLoaded() {
        return XmlDocument_ != null;
    }

    protected static void resetClassForTesting() {
        XmlDocument_ = null;
        ConfigurationMap_ = new WeakHashMap<BrowserVersion, JavaScriptConfiguration>(11);
    }

    protected static void setXmlDocument(Document document) {
        XmlDocument_ = document;
    }

    protected static void loadConfiguration() {
        try {
            Reader reader = JavaScriptConfiguration.getConfigurationFileAsReader();
            if (reader == null) {
                LOG.error("Unable to load JavaScriptConfiguration.xml");
            } else {
                JavaScriptConfiguration.loadConfiguration(reader);
                reader.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error when loading JavascriptConfiguration.xml", e);
            e.printStackTrace();
        }
    }

    protected static void loadConfiguration(Reader configurationReader) {
        InputSource inputSource = new InputSource(configurationReader);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new StrictErrorHandler());
            XmlDocument_ = documentBuilder.parse(inputSource);
        }
        catch (SAXParseException parseException) {
            LOG.error("line=[" + parseException.getLineNumber() + "] columnNumber=[" + parseException.getColumnNumber() + "] systemId=[" + parseException.getSystemId() + "] publicId=[" + parseException.getPublicId() + "]", parseException);
        }
        catch (Exception e) {
            LOG.error("Error when loading JavascriptConfiguration.xml", e);
        }
    }

    public static synchronized JavaScriptConfiguration getInstance(BrowserVersion browserVersion) {
        if (browserVersion == null) {
            throw new IllegalStateException("BrowserVersion must be defined");
        }
        JavaScriptConfiguration configuration = ConfigurationMap_.get(browserVersion);
        if (configuration == null) {
            configuration = new JavaScriptConfiguration(browserVersion);
            ConfigurationMap_.put(browserVersion, configuration);
        }
        return configuration;
    }

    static JavaScriptConfiguration getAllEntries() {
        JavaScriptConfiguration configuration = new JavaScriptConfiguration(null);
        return configuration;
    }

    private static Reader getConfigurationFileAsReader() {
        String localizedName;
        Class<JavaScriptConfiguration> clazz = JavaScriptConfiguration.class;
        String name = clazz.getPackage().getName().replace('.', '/') + '/' + "JavaScriptConfiguration.xml";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            try {
                localizedName = name.replace('/', File.separatorChar);
                inputStream = new FileInputStream(localizedName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                localizedName = ("./src/java" + name).replace('/', File.separatorChar);
                inputStream = new FileInputStream(localizedName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new InputStreamReader(inputStream);
    }

    public Set<String> keySet() {
        return this.configuration_.keySet();
    }

    private Map<String, ClassConfiguration> buildUsageMap(BrowserVersion browser) {
        HashMap<String, ClassConfiguration> classMap = new HashMap<String, ClassConfiguration>(30);
        for (Node node = XmlDocument_.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals("class")) continue;
            String className = element.getAttribute("name");
            if (this.testToExcludeElement(element, browser)) continue;
            try {
                ClassConfiguration config = this.parseClassElement(className, element, browser);
                if (config == null) continue;
                classMap.put(className, config);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class was not found for '" + className + "'");
            }
        }
        return Collections.unmodifiableMap(classMap);
    }

    private ClassConfiguration parseClassElement(String className, Element element, BrowserVersion browser) throws ClassNotFoundException {
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return null;
        }
        String linkedClassname = element.getAttribute("classname");
        String jsConstructor = element.getAttribute("jsConstructor");
        String superclassName = element.getAttribute("extends");
        String htmlClassname = element.getAttribute("htmlClass");
        boolean jsObjectFlag = false;
        String jsObjectStr = element.getAttribute("JSObject");
        if ("true".equalsIgnoreCase(jsObjectStr)) {
            jsObjectFlag = true;
        }
        ClassConfiguration classConfiguration = new ClassConfiguration(className, linkedClassname, jsConstructor, superclassName, htmlClassname, jsObjectFlag);
        ClassnameMap_.put(linkedClassname, className);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tagName = childElement.getTagName();
            if (tagName.equals("property")) {
                this.parsePropertyElement(classConfiguration, childElement, browser);
                continue;
            }
            if (tagName.equals("function")) {
                this.parseFunctionElement(classConfiguration, childElement, browser);
                continue;
            }
            if (tagName.equals("constant")) {
                this.parseConstantElement(classConfiguration, childElement, browser);
                continue;
            }
            if (tagName.equals("browser")) {
                LOG.debug("browser tag not yet handled for class " + linkedClassname);
                continue;
            }
            if (tagName.equals("doclink")) continue;
            throw new IllegalStateException("Do not understand element type '" + tagName + "' in '" + linkedClassname + "'");
        }
        return classConfiguration;
    }

    private void parsePropertyElement(ClassConfiguration classConfiguration, Element element, BrowserVersion browser) {
        String writeFlag;
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return;
        }
        if (this.testToExcludeElement(element, browser)) {
            return;
        }
        String propertyName = element.getAttribute("name");
        boolean readable = false;
        boolean writeable = false;
        String readFlag = element.getAttribute("readable");
        if ("true".equalsIgnoreCase(readFlag)) {
            readable = true;
        }
        if ("true".equalsIgnoreCase(writeFlag = element.getAttribute("writable"))) {
            writeable = true;
        }
        classConfiguration.addProperty(propertyName, readable, writeable);
    }

    private void parseFunctionElement(ClassConfiguration classConfiguration, Element element, BrowserVersion browser) {
        String notImplemented = element.getAttribute("notImplemented");
        if ("true".equalsIgnoreCase(notImplemented)) {
            return;
        }
        String propertyName = element.getAttribute("name");
        if (this.testToExcludeElement(element, browser)) {
            return;
        }
        classConfiguration.addFunction(propertyName);
    }

    private void parseConstantElement(ClassConfiguration classConfiguration, Element element, BrowserVersion browser) {
        if (this.testToExcludeElement(element, browser)) {
            return;
        }
        String constantName = element.getAttribute("name");
        classConfiguration.addConstant(constantName);
    }

    private boolean testToExcludeElement(Element element, BrowserVersion browser) {
        if (browser == null) {
            return false;
        }
        boolean browserConstraint = false;
        boolean allowBrowser = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element childElement;
            if (!(node instanceof Element) || !(childElement = (Element)node).getTagName().equals("browser")) continue;
            browserConstraint = true;
            if (!this.testToIncludeForBrowserConstraint(childElement, browser)) continue;
            allowBrowser = true;
        }
        return browserConstraint && !allowBrowser;
    }

    protected boolean classConfigEquals(String classname, ClassConfiguration config) {
        ClassConfiguration myConfig = this.configuration_.get(classname);
        return config.equals(myConfig);
    }

    public ClassConfiguration getClassConfiguration(String classname) {
        return this.configuration_.get(classname);
    }

    private boolean testToIncludeForBrowserConstraint(Element element, BrowserVersion browser) {
        if (!(browser.isIE() && "Internet Explorer".equals(element.getAttribute("name")) || browser.isFirefox() && "Firefox".equals(element.getAttribute("name")))) {
            return false;
        }
        String max = element.getAttribute("max-version");
        float maxVersion = max.length() == 0 ? 0.0f : Float.parseFloat(max);
        if (maxVersion > 0.0f && browser.getBrowserVersionNumeric() > maxVersion) {
            return false;
        }
        String min = element.getAttribute("min-version");
        float minVersion = min.length() == 0 ? 0.0f : Float.parseFloat(min);
        return !(minVersion > 0.0f) || !(browser.getBrowserVersionNumeric() < minVersion);
    }

    protected Class<?> getClassObject(String classname) {
        ClassConfiguration config = this.configuration_.get(classname);
        return config.getLinkedClass();
    }

    public Method getPropertyReadMethod(Class<?> clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getPropertyReadMethod(classname, propertyName);
    }

    public Method getPropertyReadMethod(String classname, String propertyName) {
        while (classname.length() > 0) {
            ClassConfiguration config = this.configuration_.get(classname);
            if (config == null) {
                return null;
            }
            Method theMethod = config.getPropertyReadMethod(propertyName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    private ClassConfiguration.PropertyInfo findPropertyInChain(String classname, String propertyName) {
        String workname = classname;
        while (workname.length() > 0) {
            ClassConfiguration config = this.configuration_.get(workname);
            ClassConfiguration.PropertyInfo info = config.getPropertyInfo(propertyName);
            if (info != null) {
                return info;
            }
            workname = config.getExtendedClass();
        }
        return null;
    }

    public Method getPropertyWriteMethod(Class<?> clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getPropertyWriteMethod(classname, propertyName);
    }

    public Method getPropertyWriteMethod(String classname, String propertyName) {
        while (classname.length() > 0) {
            ClassConfiguration config = this.configuration_.get(classname);
            Method theMethod = config.getPropertyWriteMethod(propertyName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    public Method getFunctionMethod(Class<?> clazz, String functionName) {
        String classname = this.getClassnameForClass(clazz);
        return this.getFunctionMethod(classname, functionName);
    }

    public Method getFunctionMethod(String classname, String functionName) {
        while (classname.length() > 0) {
            ClassConfiguration config = this.configuration_.get(classname);
            Method theMethod = config.getFunctionMethod(functionName);
            if (theMethod != null) {
                return theMethod;
            }
            classname = config.getExtendedClass();
        }
        return null;
    }

    public boolean propertyExists(Class<?> clazz, String propertyName) {
        String classname = this.getClassnameForClass(clazz);
        return this.propertyExists(classname, propertyName);
    }

    public boolean propertyExists(String classname, String propertyName) {
        ClassConfiguration.PropertyInfo info = this.findPropertyInChain(classname, propertyName);
        return info != null;
    }

    private String getClassnameForClass(Class<?> clazz) {
        String name = ClassnameMap_.get(clazz.getName());
        if (name == null) {
            throw new IllegalStateException("Did not find the mapping of the class to the classname for " + clazz.getName());
        }
        return name;
    }

    public static synchronized Map<Class<? extends HtmlElement>, Class<? extends SimpleScriptable>> getHtmlJavaScriptMapping() {
        if (HtmlJavaScriptMap_ != null) {
            return HtmlJavaScriptMap_;
        }
        JavaScriptConfiguration configuration = JavaScriptConfiguration.getAllEntries();
        HashMap map = new HashMap();
        for (String jsClassname : configuration.keySet()) {
            ClassConfiguration classConfig = configuration.getClassConfiguration(jsClassname);
            String htmlClassname = classConfig.getHtmlClassname();
            if (htmlClassname == null) continue;
            try {
                Class<?> htmlClass = Class.forName(htmlClassname);
                LOG.debug("Mapping " + htmlClass.getName() + " to " + jsClassname);
                while (!classConfig.isJsObject()) {
                    jsClassname = classConfig.getExtendedClass();
                    classConfig = configuration.getClassConfiguration(jsClassname);
                }
                map.put(htmlClass, classConfig.getLinkedClass());
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        map.put(HtmlHeading1.class, HTMLHeadingElement.class);
        map.put(HtmlHeading2.class, HTMLHeadingElement.class);
        map.put(HtmlHeading3.class, HTMLHeadingElement.class);
        map.put(HtmlHeading4.class, HTMLHeadingElement.class);
        map.put(HtmlHeading5.class, HTMLHeadingElement.class);
        map.put(HtmlHeading6.class, HTMLHeadingElement.class);
        map.put(HtmlInlineQuotation.class, HTMLQuoteElement.class);
        map.put(HtmlBlockQuote.class, HTMLQuoteElement.class);
        map.put(HtmlAbbreviated.class, HTMLSpanElement.class);
        map.put(HtmlAcronym.class, HTMLSpanElement.class);
        map.put(HtmlAddress.class, HTMLSpanElement.class);
        map.put(HtmlBackgroundSound.class, HTMLSpanElement.class);
        map.put(HtmlBidirectionalOverride.class, HTMLSpanElement.class);
        map.put(HtmlBig.class, HTMLSpanElement.class);
        map.put(HtmlBold.class, HTMLSpanElement.class);
        map.put(HtmlBlink.class, HTMLSpanElement.class);
        map.put(HtmlCenter.class, HTMLSpanElement.class);
        map.put(HtmlCitation.class, HTMLSpanElement.class);
        map.put(HtmlCode.class, HTMLSpanElement.class);
        map.put(HtmlDefinition.class, HTMLSpanElement.class);
        map.put(HtmlDefinitionDescription.class, HTMLSpanElement.class);
        map.put(HtmlDefinitionTerm.class, HTMLSpanElement.class);
        map.put(HtmlEmphasis.class, HTMLSpanElement.class);
        map.put(HtmlItalic.class, HTMLSpanElement.class);
        map.put(HtmlKeyboard.class, HTMLSpanElement.class);
        map.put(HtmlListing.class, HTMLSpanElement.class);
        map.put(HtmlMultiColumn.class, HTMLSpanElement.class);
        map.put(HtmlNoBreak.class, HTMLSpanElement.class);
        map.put(HtmlPlainText.class, HTMLSpanElement.class);
        map.put(HtmlS.class, HTMLSpanElement.class);
        map.put(HtmlSample.class, HTMLSpanElement.class);
        map.put(HtmlSmall.class, HTMLSpanElement.class);
        map.put(HtmlSpan.class, HTMLSpanElement.class);
        map.put(HtmlStrike.class, HTMLSpanElement.class);
        map.put(HtmlStrong.class, HTMLSpanElement.class);
        map.put(HtmlSubscript.class, HTMLSpanElement.class);
        map.put(HtmlSuperscript.class, HTMLSpanElement.class);
        map.put(HtmlTeletype.class, HTMLSpanElement.class);
        map.put(HtmlUnderlined.class, HTMLSpanElement.class);
        map.put(HtmlVariable.class, HTMLSpanElement.class);
        map.put(HtmlExample.class, HTMLSpanElement.class);
        map.put(HtmlDivision.class, HTMLDivElement.class);
        map.put(HtmlMarquee.class, HTMLDivElement.class);
        map.put(HtmlNoEmbed.class, HTMLDivElement.class);
        map.put(HtmlNoFrames.class, HTMLDivElement.class);
        map.put(HtmlNoScript.class, HTMLDivElement.class);
        map.put(HtmlTableBody.class, HTMLTableSectionElement.class);
        map.put(HtmlTableHeader.class, HTMLTableSectionElement.class);
        map.put(HtmlTableFooter.class, HTMLTableSectionElement.class);
        map.put(HtmlTableColumn.class, HTMLTableColElement.class);
        map.put(HtmlTableColumnGroup.class, HTMLTableColElement.class);
        HtmlJavaScriptMap_ = Collections.unmodifiableMap(map);
        return HtmlJavaScriptMap_;
    }

    static {
        ConfigurationMap_ = new WeakHashMap<BrowserVersion, JavaScriptConfiguration>(11);
        ClassnameMap_ = new HashMap<String, String>();
    }
}

