/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.javascript.host.Text;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang.StringUtils;
import org.w3c.css.sac.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final long serialVersionUID = -1883166331827717255L;
    private static final int PIXELS_PER_CHAR = 10;
    private SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Map<String, String> defaultDisplays_;
    private Integer width_;
    private Integer height_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected String getStyleAttribute(String name, boolean camelCase) {
        HTMLElement parent;
        String s = super.getStyleAttribute(name, camelCase);
        if (s.length() == 0 && this.isInheritable(name, camelCase) && (parent = this.getElement().getParentHTMLElement()) != null) {
            s = this.getWindow().jsxFunction_getComputedStyle(parent, null).getStyleAttribute(name, camelCase);
        }
        return s;
    }

    private boolean isInheritable(String name, boolean camelCase) {
        if (!camelCase) {
            name = ComputedCSSStyleDeclaration.camelize(name);
        }
        return "azimuth".equals(name) || "borderCollapse".equals(name) || "borderSpacing".equals(name) || "captionSide".equals(name) || "color".equals(name) || "cursor".equals(name) || "direction".equals(name) || "elevation".equals(name) || "emptyCells".equals(name) || "fontFamily".equals(name) || "fontSize".equals(name) || "fontStyle".equals(name) || "fontVariant".equals(name) || "fontWeight".equals(name) || "font".equals(name) || "letterSpacing".equals(name) || "lineHeight".equals(name) || "listStyleImage".equals(name) || "listStylePosition".equals(name) || "listStyleType".equals(name) || "listStyle".equals(name) || "orphans".equals(name) || "pitchRange".equals(name) || "pitch".equals(name) || "quotes".equals(name) || "richness".equals(name) || "speakHeader".equals(name) || "speakNumeral".equals(name) || "speakPunctuation".equals(name) || "speak".equals(name) || "speechRate".equals(name) || "stress".equals(name) || "textAlign".equals(name) || "textIndent".equals(name) || "textTransform".equals(name) || "visibility".equals(name) || "voiceFamily".equals(name) || "volume".equals(name) || "whiteSpace".equals(name) || "widows".equals(name) || "wordSpacing".equals(name);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        CSSStyleDeclaration.StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, priority, specificity, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap(boolean camelCase) {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap(camelCase);
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement e : this.localModifications_.values()) {
                String key = e.getName();
                if (camelCase) {
                    key = ComputedCSSStyleDeclaration.camelize(key);
                }
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(key, e.getValue(), e.getIndex());
                if (existent != null) continue;
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundAttachment(), "scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        String value = super.jsxGet_backgroundColor();
        if (StringUtils.isEmpty(value)) {
            value = "transparent";
        } else if (this.getBrowserVersion().isFirefox()) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String jsxGet_backgroundImage() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundImage(), "none");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return StringUtils.defaultIfEmpty(super.jsxGet_backgroundRepeat(), "repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderBottomColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderBottomStyle(), "none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderBottomWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderCollapse() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderCollapse(), "separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderLeftColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderLeftStyle(), "none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderLeftWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderRightColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderRightColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderRightStyle(), "none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderRightWidth(), "0px"));
    }

    @Override
    public String jsxGet_borderSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderSpacing(), "0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderTopColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_borderTopStyle(), "none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_borderTopWidth(), "0px"));
    }

    @Override
    public String jsxGet_bottom() {
        return StringUtils.defaultIfEmpty(super.jsxGet_bottom(), "auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return StringUtils.defaultIfEmpty(super.jsxGet_captionSide(), "top");
    }

    @Override
    public String jsxGet_clear() {
        return StringUtils.defaultIfEmpty(super.jsxGet_clear(), "none");
    }

    @Override
    public String jsxGet_clip() {
        return StringUtils.defaultIfEmpty(super.jsxGet_clip(), "auto");
    }

    @Override
    public String jsxGet_color() {
        return StringUtils.defaultIfEmpty(super.jsxGet_color(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return StringUtils.defaultIfEmpty(super.jsxGet_counterIncrement(), "none");
    }

    @Override
    public String jsxGet_counterReset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_counterReset(), "none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return StringUtils.defaultIfEmpty(super.jsxGet_cssFloat(), "none");
    }

    @Override
    public String jsxGet_cursor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_cursor(), "auto");
    }

    @Override
    public String jsxGet_direction() {
        return StringUtils.defaultIfEmpty(super.jsxGet_direction(), "ltr");
    }

    @Override
    public String jsxGet_display() {
        return StringUtils.defaultIfEmpty(super.jsxGet_display(), this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue;
        if (this.defaultDisplays_ == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("A", "inline");
            map.put("CODE", "inline");
            map.put("SPAN", "inline");
            if (!this.getBrowserVersion().isIE()) {
                map.put("LI", "list-item");
                map.put("TABLE", "table");
                map.put("TBODY", "table-row-group");
                map.put("TD", "table-cell");
                map.put("TH", "table-cell");
                map.put("THEAD", "table-header-group");
                map.put("TR", "table-row");
            }
            this.defaultDisplays_ = Collections.unmodifiableMap(map);
        }
        if ((defaultValue = this.defaultDisplays_.get(this.getElement().jsxGet_tagName())) == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return StringUtils.defaultIfEmpty(super.jsxGet_emptyCells(), "-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontFamily(), "serif");
    }

    @Override
    public String jsxGet_fontSize() {
        HTMLElement parent;
        String value = super.jsxGet_fontSize();
        if (value.length() == 0 && (parent = this.getElement().getParentHTMLElement()) != null) {
            value = parent.jsxGet_currentStyle().jsxGet_fontSize();
        }
        if (value.length() == 0) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontSizeAdjust(), "none");
    }

    @Override
    public String jsxGet_fontStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontStyle(), "normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontVariant(), "normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_fontWeight(), "400");
    }

    @Override
    public String jsxGet_height() {
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(605){

            public String get(ComputedCSSStyleDeclaration style) {
                return StringUtils.defaultIfEmpty(style.getStyleAttribute("height", true), "363px");
            }
        });
    }

    @Override
    public String jsxGet_left() {
        return StringUtils.defaultIfEmpty(super.jsxGet_left(), "auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_letterSpacing(), "normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_lineHeight(), "normal");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStyleImage(), "none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStylePosition(), "outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return StringUtils.defaultIfEmpty(super.jsxGet_listStyleType(), "disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginBottom(), "0px"));
    }

    @Override
    public String jsxGet_marginLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginLeft(), "0px"));
    }

    @Override
    public String jsxGet_marginRight() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginRight(), "0px"));
    }

    @Override
    public String jsxGet_marginTop() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_marginTop(), "0px"));
    }

    @Override
    public String jsxGet_markerOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_markerOffset(), "none");
    }

    @Override
    public String jsxGet_maxHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_maxHeight(), "none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_maxWidth(), "none");
    }

    @Override
    public String jsxGet_minHeight() {
        return StringUtils.defaultIfEmpty(super.jsxGet_minHeight(), "0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_minWidth(), "0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozAppearance(), "none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundClip(), "border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundInlinePolicy(), "continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBackgroundOrigin(), "padding");
    }

    @Override
    public String jsxGet_MozBinding() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBinding(), "none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderBottomColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderLeftColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderRightColors(), "none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBorderTopColors(), "none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxAlign(), "stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxDirection(), "normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxFlex(), "0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxOrdinalGroup(), "1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxOrient(), "horizontal");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxPack(), "start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozBoxSizing(), "content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnCount(), "auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnGap(), "0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozColumnWidth(), "auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozFloatEdge(), "content-box");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozImageRegion(), "auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOpacity(), "1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineOffset(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusBottomleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusBottomright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusTopleft(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineRadiusTopright(), "0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineStyle(), "none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozOutlineWidth(), "0px");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserFocus(), "none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserInput(), "auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserModify(), "read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return StringUtils.defaultIfEmpty(super.jsxGet_MozUserSelect(), "auto");
    }

    @Override
    public String jsxGet_opacity() {
        return StringUtils.defaultIfEmpty(super.jsxGet_opacity(), "1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineColor(), "rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineOffset(), "0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineStyle(), "none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return StringUtils.defaultIfEmpty(super.jsxGet_outlineWidth(), "0px");
    }

    @Override
    public String jsxGet_overflow() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflow(), "visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflowX(), "visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return StringUtils.defaultIfEmpty(super.jsxGet_overflowY(), "visible");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingBottom(), "0px"));
    }

    @Override
    public String jsxGet_paddingLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingLeft(), "0px"));
    }

    @Override
    public String jsxGet_paddingRight() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingRight(), "0px"));
    }

    @Override
    public String jsxGet_paddingTop() {
        return this.pixelString(StringUtils.defaultIfEmpty(super.jsxGet_paddingTop(), "0px"));
    }

    @Override
    public String jsxGet_position() {
        return StringUtils.defaultIfEmpty(super.jsxGet_position(), "static");
    }

    @Override
    public String jsxGet_right() {
        return StringUtils.defaultIfEmpty(super.jsxGet_right(), "auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return StringUtils.defaultIfEmpty(super.jsxGet_tableLayout(), "auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textAlign(), "start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textDecoration(), "none");
    }

    @Override
    public String jsxGet_textIndent() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textIndent(), "0px");
    }

    @Override
    public String jsxGet_textTransform() {
        return StringUtils.defaultIfEmpty(super.jsxGet_textTransform(), "none");
    }

    @Override
    public String jsxGet_top() {
        return StringUtils.defaultIfEmpty(super.jsxGet_top(), "auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        return StringUtils.defaultIfEmpty(super.jsxGet_unicodeBidi(), "normal");
    }

    @Override
    public String jsxGet_verticalAlign() {
        return StringUtils.defaultIfEmpty(super.jsxGet_verticalAlign(), "baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return StringUtils.defaultIfEmpty(super.jsxGet_visibility(), "visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return StringUtils.defaultIfEmpty(super.jsxGet_whiteSpace(), "normal");
    }

    @Override
    public String jsxGet_width() {
        if (this.jsxGet_display().equals("none")) {
            return "auto";
        }
        final String defaultWidth = this.getBrowserVersion().isIE() ? "auto" : "1256px";
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

            public String get(ComputedCSSStyleDeclaration style) {
                return StringUtils.defaultIfEmpty(style.getStyleAttribute("width", true), defaultWidth);
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.getCalculatedWidth();
        if (includeBorder) {
            width += this.getBorderHorizontal();
        }
        if (includePadding) {
            width += this.getPaddingHorizontal();
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        String display = this.jsxGet_display();
        if ("none".equals(display)) {
            this.width_ = 0;
            return this.width_;
        }
        String styleWidth = super.jsxGet_width();
        DomNode parent = this.getElement().getDomNodeOrDie().getParentNode();
        if (StringUtils.isEmpty(styleWidth) && parent instanceof HtmlElement) {
            String cssFloat = this.jsxGet_cssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat)) {
                width = ((DomNode)this.getDomNodeOrDie()).getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
                String parentWidth = this.getWindow().jsxFunction_getComputedStyle(parentJS, null).jsxGet_width();
                width = this.getBrowserVersion().isIE() && "auto".equals(parentWidth) ? 1256 : ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(1256){

                    public String get(ComputedCSSStyleDeclaration style) {
                        return style.jsxGet_width();
                    }
                });
                width -= this.getBorderHorizontal() + this.getPaddingHorizontal();
            } else {
                width = 0;
                for (DomNode child : ((DomNode)this.getDomNodeOrDie()).getChildren()) {
                    if (child.getScriptObject() instanceof HTMLElement) {
                        HTMLElement e = (HTMLElement)child.getScriptObject();
                        int w = e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                        width += w;
                        continue;
                    }
                    if (!(child.getScriptObject() instanceof Text)) continue;
                    width += child.getTextContent().length() * 10;
                }
            }
        } else {
            width = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute("width", true);
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.getCalculatedHeight();
        if (includeBorder) {
            height += this.getBorderVertical();
        }
        if (includePadding) {
            height += this.getPaddingVertical();
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        if ("none".equals(this.jsxGet_display())) {
            this.height_ = 0;
            return this.height_;
        }
        if (this.getElement() instanceof HTMLBodyElement) {
            this.height_ = 605;
            return this.height_;
        }
        boolean ie = this.getBrowserVersion().isIE();
        int defaultHeight = ie ? 15 : 20;
        String h = super.jsxGet_height();
        int elementHeight = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(605){

            public String get(ComputedCSSStyleDeclaration style) {
                return style.getStyleAttribute("height", true);
            }
        });
        if (elementHeight == 0 || ie && elementHeight < defaultHeight) {
            elementHeight = defaultHeight;
        }
        Integer childrenHeight = null;
        for (DomNode child : ((DomNode)this.getDomNodeOrDie()).getChildren()) {
            if (!(child.getScriptObject() instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)child.getScriptObject();
            int x = e.jsxGet_currentStyle().getCalculatedHeight(true, true);
            childrenHeight = childrenHeight != null ? childrenHeight + x : x;
        }
        int height = childrenHeight != null && (ie && childrenHeight > elementHeight || !ie && h.length() == 0) ? childrenHeight : elementHeight;
        this.height_ = height;
        return this.height_;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        String p = this.getPositionWithInheritance();
        String t = this.getTopWithInheritance();
        String b = this.getBottomWithInheritance();
        if ("absolute".equals(p) && !"auto".equals(t)) {
            top = ComputedCSSStyleDeclaration.pixelValue(t);
        } else if ("absolute".equals(p) && !"auto".equals(b)) {
            top = 0;
            for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getPreviousSibling()) {
                if (!(child instanceof HtmlElement) || child instanceof HtmlHead) continue;
                top += 20;
            }
            top -= ComputedCSSStyleDeclaration.pixelValue(b);
        } else {
            top = 0;
            for (DomNode prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (!(prev instanceof HtmlElement) || prev instanceof HtmlHead) continue;
                top += 20;
            }
            if ("relative".equals(p)) {
                top += ComputedCSSStyleDeclaration.pixelValue(t);
            }
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTop();
            top += padding;
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("fixed".equals(p) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TREATS_POSITION_FIXED_LIKE_POSITION_STATIC)) {
            p = "static";
        }
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = this.getElement().getParentHTMLElement();
            int parentWidth = parent.jsxGet_currentStyle().getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = this.getElement().getParentHTMLElement();
            left = ComputedCSSStyleDeclaration.pixelValue(parent.jsxGet_currentStyle().getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (Object n = this.getDomNodeOrDie(); n != null; n = ((DomNode)n).getPreviousSibling()) {
                if (((DomNode)n).getScriptObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)((DomNode)n).getScriptObject();
                    String d = e.jsxGet_currentStyle().jsxGet_display();
                    if (!"block".equals(d)) {
                        if ("none".equals(d)) continue;
                        left += e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                        continue;
                    }
                    break;
                }
                if (!(((DomNode)n).getScriptObject() instanceof Text)) continue;
                left += ((DomNode)n).getTextContent().length() * 10;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeft();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeft();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.jsxGet_position();
        if ("inherit".equals(p)) {
            HTMLElement parent;
            p = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getPositionWithInheritance() : "static") : "static";
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.jsxGet_left();
        if ("inherit".equals(left)) {
            HTMLElement parent;
            left = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getLeftWithInheritance() : "auto") : "auto";
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.jsxGet_right();
        if ("inherit".equals(right)) {
            HTMLElement parent;
            right = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getRightWithInheritance() : "auto") : "auto";
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.jsxGet_top();
        if ("inherit".equals(top)) {
            HTMLElement parent;
            top = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getTopWithInheritance() : "auto") : "auto";
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.jsxGet_bottom();
        if ("inherit".equals(bottom)) {
            HTMLElement parent;
            bottom = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getBottomWithInheritance() : "auto") : "auto";
        }
        return bottom;
    }

    public int getMarginLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginLeft());
    }

    public int getMarginRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginRight());
    }

    public int getMarginTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
    }

    public int getMarginBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginBottom());
    }

    public int getPaddingLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingLeft());
    }

    public int getPaddingRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingRight());
    }

    public int getPaddingTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingTop());
    }

    public int getPaddingBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingLeft() + this.getPaddingRight();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingTop() + this.getPaddingBottom();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
    }

    public int getBorderRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderRightWidth());
    }

    public int getBorderTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
    }

    public int getBorderBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderLeft() + this.getBorderRight();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderTop() + this.getBorderBottom();
        }
        return this.borderVertical_;
    }

    @Override
    public String jsxGet_wordSpacing() {
        return StringUtils.defaultIfEmpty(super.jsxGet_wordSpacing(), "normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        String response = Context.toString(ComputedCSSStyleDeclaration.getProperty((Scriptable)this, ComputedCSSStyleDeclaration.camelize(name)));
        if (response == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return response;
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().isIE()) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(HTMLElement element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (this.getBrowserVersion().isIE()) {
            return s;
        }
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

