/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollectionTags;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLCollection
extends SimpleScriptable
implements Function,
NodeList {
    private static final long serialVersionUID = 4049916048017011764L;
    private static final Log LOG = LogFactory.getLog(HTMLCollection.class);
    private String xpath_;
    private DomNode node_;
    private boolean avoidObjectDetection_ = false;
    private Transformer transformer_;
    private List<Object> cachedElements_;
    private int currentIndex_ = 0;

    @Deprecated
    public HTMLCollection() {
    }

    public HTMLCollection(DomNode parentScope) {
        this(parentScope.getScriptObject());
    }

    public HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public void init(DomNode node, String xpath) {
        this.init(node, xpath, NOPTransformer.INSTANCE);
    }

    public void init(DomNode node, String xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    public void initFromChildren(DomNode node) {
        if (node != null) {
            this.node_ = node;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
        this.transformer_ = NOPTransformer.INSTANCE;
    }

    @Override
    public final Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError("Zero arguments; need an index or a key.");
        }
        return this.nullIfNotFound(this.getIt(args[0]));
    }

    @Override
    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    @Override
    public final Object get(int index, Scriptable start) {
        HTMLCollection array = (HTMLCollection)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(this.transformer_.transform(elements.get(index)));
        }
        return NOT_FOUND;
    }

    protected List<Object> getElements() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.computeElements();
        }
        return this.cachedElements_;
    }

    protected List<Object> computeElements() {
        List<Object> response;
        if (this.node_ != null) {
            if (this.xpath_ != null) {
                response = XPathUtils.getByXPath(this.node_, this.xpath_);
            } else {
                response = new ArrayList();
                for (Node node = this.node_.getFirstChild(); node != null; node = node.getNextSibling()) {
                    response.add(node);
                }
            }
        } else {
            response = new ArrayList();
        }
        boolean isXmlPage = this.node_ != null && this.node_.getOwnerDocument() instanceof XmlPage;
        boolean isIE = this.getBrowserVersion().isIE();
        block1: for (int i = 0; i < response.size(); ++i) {
            Boolean xmlSpaceDefault;
            DomNode element = (DomNode)response.get(i);
            if (isIE && isXmlPage && element instanceof DomText && ((DomText)element).getNodeValue().trim().length() == 0 && (xmlSpaceDefault = HTMLCollection.isXMLSpaceDefault(element.getParentNode())) != Boolean.FALSE) {
                response.remove(i--);
                continue;
            }
            for (DomNode parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlNoScript)) continue;
                response.remove(i--);
                continue block1;
            }
        }
        return response;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof DomElement) {
            String value = ((DomElement)node).getAttribute("xml:space");
            if (value.length() != 0) {
                if (value.equals("default")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if (this.xpath_ == null || "length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        CollectionUtils.transform(elements, this.transformer_);
        for (Object next : elements) {
            if (next instanceof DomElement) {
                String id = ((DomElement)next).getAttribute("id");
                if (id == null || !id.equals(name)) continue;
                if (this.getBrowserVersion().isIE() || "FF3".equals(this.getBrowserVersion().getNickname())) {
                    int totalIDs = 0;
                    for (Object o : elements) {
                        if (!(o instanceof DomElement) || !name.equals(((DomElement)o).getAttribute("id"))) continue;
                        ++totalIDs;
                    }
                    if (totalIDs > 1) {
                        HTMLCollectionTags collection = new HTMLCollectionTags((SimpleScriptable)this.getParentScope());
                        collection.setAvoidObjectDetection(!this.getBrowserVersion().isIE());
                        collection.init(this.node_, ".//*[@id='" + id + "']");
                        return collection;
                    }
                }
                LOG.debug("Property \"" + name + "\" evaluated (by id) to " + next);
                return this.getScriptableForElement(next);
            }
            if (next instanceof WebWindow) {
                WebWindow window = (WebWindow)next;
                String windowName = window.getName();
                if (windowName != null && windowName.equals(name)) {
                    LOG.debug("Property \"" + name + "\" evaluated (by name) to " + window);
                    return this.getScriptableForElement(window);
                }
                if (!this.getBrowserVersion().isIE() || !(window instanceof FrameWindow) || !((FrameWindow)window).getFrameElement().getAttribute("id").equals(name)) continue;
                LOG.debug("Property \"" + name + "\" evaluated (by id) to " + window);
                return this.getScriptableForElement(window);
            }
            LOG.warn("Unrecognized type in collection: " + next + " (" + next.getClass().getName() + ")");
        }
        HTMLCollection array = new HTMLCollection(this);
        String newCondition = "@name = '" + name.replaceAll("\\$", "\\\\\\$") + "'";
        String xpathExpr = this.xpath_.endsWith("]") ? this.xpath_.replaceAll("\\[([^\\]]*)\\]$", "[($1) and " + newCondition + "]") : this.xpath_ + "[" + newCondition + "]";
        array.init(this.node_, xpathExpr);
        List<Object> subElements = array.getElements();
        if (subElements.size() > 1) {
            LOG.debug("Property \"" + name + "\" evaluated (by name) to " + array + " with " + subElements.size() + " elements");
            return array;
        }
        if (subElements.size() == 1) {
            Scriptable singleResult = this.getScriptableForElement(subElements.get(0));
            LOG.debug("Property \"" + name + "\" evaluated (by name) to " + singleResult);
            return singleResult;
        }
        return NOT_FOUND;
    }

    public final int jsxGet_length() {
        return this.getElements().size();
    }

    public final Object jsxFunction_item(Object index) {
        return this.nullIfNotFound(this.getIt(index));
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().isIE()) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    public final Object jsxFunction_namedItem(String name) {
        return this.nullIfNotFound(this.getIt(name));
    }

    public Object jsxFunction_nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    public void jsxFunction_reset() {
        this.currentIndex_ = 0;
    }

    public Object jsxFunction_tags(String tagName) {
        HTMLCollection array = new HTMLCollection(this);
        array.init(this.node_, this.xpath_ + "[name() = '" + tagName.toLowerCase() + "']");
        return array;
    }

    public String toString() {
        if (this.xpath_ != null) {
            return super.toString() + '<' + this.xpath_ + '>';
        }
        return super.toString();
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)other;
            if (this.node_ == otherArray.node_ && this.xpath_.toString().equals(otherArray.xpath_.toString()) && this.transformer_.equals(otherArray.transformer_)) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        try {
            int index = Integer.parseInt(name);
            List<Object> elements = this.getElements();
            CollectionUtils.transform(elements, this.transformer_);
            if (index >= 0 && index < elements.size()) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (name.equals("length")) {
            return true;
        }
        if (!this.getBrowserVersion().isIE()) {
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            for (String functionName : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                if (!name.equals(functionName)) continue;
                return true;
            }
            return false;
        }
        return this.getWithPreemption(name) != NOT_FOUND;
    }

    @Override
    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        CollectionUtils.transform(elements, this.transformer_);
        if (!this.getBrowserVersion().isIE()) {
            int length = this.getElements().size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            int index = 0;
            for (Object next : elements) {
                if (next instanceof HtmlElement) {
                    HtmlElement element = (HtmlElement)next;
                    String name = element.getAttribute("name");
                    if (name != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                        idList.add(name);
                    } else {
                        String id = element.getId();
                        if (id != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                            idList.add(id);
                        } else {
                            idList.add(Integer.toString(index));
                        }
                    }
                    ++index;
                    continue;
                }
                if (next instanceof WebWindow) {
                    WebWindow window = (WebWindow)next;
                    String windowName = window.getName();
                    if (windowName == null) continue;
                    idList.add(windowName);
                    continue;
                }
                LOG.debug("Unrecognized type in array: \"" + next.getClass().getName() + "\"");
            }
        }
        return idList.toArray();
    }

    @Override
    public int getLength() {
        return this.jsxGet_length();
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.transformer_.transform(this.getElements().get(index));
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getBrowserVersion().isIE()) {
                return "[object]";
            }
            return "[object HTMLCollection]";
        }
        return super.getDefaultValue(hint);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object instanceof WebWindow) {
            return new WindowProxy((WebWindow)object);
        }
        return this.getScriptableFor(object);
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private static final long serialVersionUID = -6690451155079053212L;

        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }
    }
}

