/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang.StringUtils;

public class HTMLFormElement
extends HTMLElement {
    private static final long serialVersionUID = -1860993922147246513L;
    private HTMLCollection elements_;

    public final void jsConstructor() {
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptObject(this);
    }

    public String jsxGet_name() {
        return this.getHtmlForm().getNameAttribute();
    }

    public void jsxSet_name(String name) {
        WebAssert.notNull("name", name);
        this.getHtmlForm().setNameAttribute(name);
    }

    public HTMLCollection jsxGet_elements() {
        if (this.elements_ == null) {
            final HtmlForm htmlForm = this.getHtmlForm();
            this.elements_ = new HTMLCollection(this){
                private static final long serialVersionUID = -2554743215194459203L;

                @Override
                protected List<Object> computeElements() {
                    List<Object> response = super.computeElements();
                    response.addAll(htmlForm.getLostChildren());
                    return response;
                }
            };
            String xpath = ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]";
            this.elements_.init(htmlForm, ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]");
        }
        return this.elements_;
    }

    public int jsxGet_length() {
        int all = this.jsxGet_elements().jsxGet_length();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    public String jsxGet_action() {
        String action = this.getHtmlForm().getActionAttribute();
        if (this.getBrowserVersion().isFirefox()) {
            try {
                action = ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return action;
    }

    public void jsxSet_action(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    public String jsxGet_method() {
        return this.getHtmlForm().getMethodAttribute();
    }

    public void jsxSet_method(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    public String jsxGet_target() {
        return this.getHtmlForm().getTargetAttribute();
    }

    public Object jsxGet_onsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    public void jsxSet_onsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    public void jsxSet_target(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    public String jsxGet_encoding() {
        return this.getHtmlForm().getEnctypeAttribute();
    }

    public void jsxSet_encoding(String encoding) {
        WebAssert.notNull("encoding", encoding);
        this.getHtmlForm().setEnctypeAttribute(encoding);
    }

    private HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    public void jsxFunction_submit() throws IOException {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        WebClient webClient = page.getWebClient();
        String action = this.getHtmlForm().getActionAttribute();
        if (action.startsWith("javascript:")) {
            String js = StringUtils.substringAfter(action, "javascript:");
            webClient.getJavaScriptEngine().execute(page, js, "Form action", 0);
        } else {
            WebRequestSettings requestSettings = this.getHtmlForm().getWebRequestSettings(null);
            String target = page.getResolvedTarget(this.jsxGet_target());
            webClient.download(page.getEnclosingWindow(), target, requestSettings, "JS form.submit()");
        }
    }

    public Object jsxFunction_item(Object index, Object subIndex) {
        if (index instanceof Number) {
            return this.jsxGet_elements().jsxFunction_item(index);
        }
        final HtmlForm htmlForm = this.getHtmlForm();
        HTMLCollection elements = new HTMLCollection(this){
            private static final long serialVersionUID = -2554743215194459203L;

            @Override
            protected List<Object> computeElements() {
                List<Object> response = super.computeElements();
                response.addAll(htmlForm.getLostChildren());
                return response;
            }
        };
        String xpath = ".//*[((name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')) and @name='" + index + "']";
        elements.init(htmlForm, xpath);
        if (elements.getLength() == 0) {
            return null;
        }
        if (elements.getLength() == 1) {
            return elements.jsxFunction_item(0);
        }
        if (subIndex instanceof Number) {
            return elements.jsxFunction_item(subIndex);
        }
        return elements;
    }

    public void jsxFunction_reset() {
        this.getHtmlForm().reset();
    }

    protected Object getWithPreemption(String name) {
        HtmlForm form = this.getHtmlForm();
        SgmlPage page = form.getPage();
        if (page instanceof HtmlPage) {
            List<HtmlElement> elements = ((HtmlPage)page).getElementsByIdAndOrName(name);
            if (elements.isEmpty()) {
                return NOT_FOUND;
            }
            Iterator<HtmlElement> iter = elements.iterator();
            while (iter.hasNext()) {
                if (this.isAccessibleByIdOrName(form, iter.next())) continue;
                iter.remove();
            }
            if (elements.isEmpty()) {
                return NOT_FOUND;
            }
            if (elements.size() == 1) {
                return this.getScriptableFor(elements.get(0));
            }
        }
        HTMLCollection collection = new HTMLCollection(this);
        String xpath = "//*[is-descendant-of-contextual-form() and (@name = '" + name + "' or @id = '" + name + "')" + " and ((name() = 'input' and translate(@type, 'IMAGE', 'image') != 'image') or name() = 'button'" + " or name() = 'select' or name() = 'textarea')]";
        collection.init(form, xpath);
        int length = collection.jsxGet_length();
        if (length == 0) {
            collection = new HTMLCollection(this);
            String xpath2 = "//*[is-descendant-of-contextual-form() and (@name = '" + name + "' or @id = '" + name + "')" + " and name() = 'img']";
            collection.init(form, xpath2);
        }
        Object result = collection;
        length = collection.jsxGet_length();
        if (length == 0) {
            result = NOT_FOUND;
        } else if (length == 1) {
            result = collection.get(0, (Scriptable)collection);
        }
        return result;
    }

    private boolean isAccessibleByIdOrName(HtmlForm form, HtmlElement element) {
        String tagName = element.getTagName();
        String type = element.getAttribute("type").toLowerCase();
        return ("input".equals(tagName) && !"image".equals(type) || "button".equals(tagName) || "select".equals(tagName) || "textarea".equals(tagName) || "img".equals(tagName)) && (form.isAncestorOf(element) || form.getLostChildren().contains(element));
    }

    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.jsxGet_elements().get(index, (Scriptable)((HTMLFormElement)start).jsxGet_elements());
    }
}

