/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLHttpRequest
extends SimpleScriptable {
    private static final long serialVersionUID = 2369039843039430664L;
    private static final Log LOG = LogFactory.getLog(XMLHttpRequest.class);
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public static final int STATE_INTERACTIVE = 3;
    public static final int STATE_COMPLETED = 4;
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private int state_;
    private Function stateChangeHandler_;
    private Function loadHandler_;
    private Function errorHandler_;
    private WebRequestSettings requestSettings_;
    private boolean async_;
    private int threadID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private HtmlPage containingPage_;
    private boolean caseSensitiveProperties_;

    public XMLHttpRequest() {
        this(true);
    }

    public XMLHttpRequest(boolean caseSensitiveProperties) {
        this.caseSensitiveProperties_ = caseSensitiveProperties;
        this.state_ = 0;
    }

    public void jsConstructor() {
    }

    public Function jsxGet_onreadystatechange() {
        return this.stateChangeHandler_;
    }

    public void jsxSet_onreadystatechange(Function stateChangeHandler) {
        this.stateChangeHandler_ = stateChangeHandler;
        if (this.state_ == 1) {
            this.setState(this.state_, null);
        }
    }

    private void setState(int state, Context context) {
        JavaScriptEngine jsEngine;
        Scriptable scope;
        this.state_ = state;
        boolean ie = this.getBrowserVersion().isIE();
        if (this.stateChangeHandler_ != null && (ie || this.async_)) {
            if (context == null) {
                context = Context.getCurrentContext();
            }
            scope = this.stateChangeHandler_.getParentScope();
            jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            int nbExecutions = this.async_ && 1 == state ? 2 : 1;
            Scriptable thisValue = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XMLHTTPREQUEST_HANDLER_THIS_IS_FUNCTION) ? this.stateChangeHandler_ : this;
            for (int i = 0; i < nbExecutions; ++i) {
                LOG.debug("Calling onreadystatechange handler for state " + state);
                jsEngine.callFunction(this.containingPage_, this.stateChangeHandler_, context, scope, thisValue, ArrayUtils.EMPTY_OBJECT_ARRAY);
                LOG.debug("onreadystatechange handler: " + context.decompileFunction(this.stateChangeHandler_, 4));
                LOG.debug("Calling onreadystatechange handler for state " + state + ". Done.");
            }
        }
        if (!ie && this.loadHandler_ != null && state == 4) {
            if (context == null) {
                context = Context.getCurrentContext();
            }
            scope = this.loadHandler_.getParentScope();
            jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction(this.containingPage_, this.loadHandler_, context, scope, this, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public Function jsxGet_onload() {
        return this.loadHandler_;
    }

    public void jsxSet_onload(Function loadHandler) {
        this.loadHandler_ = loadHandler;
    }

    public Function jsxGet_onerror() {
        return this.errorHandler_;
    }

    public void jsxSet_onerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    private void processError(Context context) {
        if (this.errorHandler_ != null && !this.getBrowserVersion().isIE()) {
            if (context == null) {
                context = Context.getCurrentContext();
            }
            Scriptable scope = this.errorHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            LOG.debug("Calling onerror handler");
            jsEngine.callFunction(this.containingPage_, this.errorHandler_, context, this, scope, ArrayUtils.EMPTY_OBJECT_ARRAY);
            LOG.debug("onerror handler: " + context.decompileFunction(this.errorHandler_, 4));
            LOG.debug("Calling onerror handler done.");
        }
    }

    public int jsxGet_readyState() {
        return this.state_;
    }

    public String jsxGet_responseText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getContentAsString();
        }
        LOG.debug("XMLHttpRequest.responseText was retrieved before the response was available.");
        return "";
    }

    public Object jsxGet_responseXML() {
        if (this.webResponse_ == null) {
            return null;
        }
        String contentType = this.webResponse_.getContentType();
        if (contentType.length() == 0 || contentType.contains("xml")) {
            try {
                XMLDocument doc;
                XmlPage page = new XmlPage(this.webResponse_, this.getWindow().getWebWindow());
                if (this.getBrowserVersion().isIE()) {
                    doc = ActiveXObject.buildXMLDocument(null);
                } else {
                    doc = new XMLDocument();
                    doc.setPrototype(this.getPrototype(doc.getClass()));
                }
                doc.setParentScope(this.getWindow());
                doc.setDomNode(page);
                return doc;
            }
            catch (IOException e) {
                LOG.warn("Failed parsing XML document " + this.webResponse_.getRequestSettings().getUrl() + ": " + e.getMessage());
                return null;
            }
        }
        LOG.debug("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType());
        return null;
    }

    public int jsxGet_status() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        LOG.error("XMLHttpRequest.status was retrieved before the response was available.");
        return 0;
    }

    public String jsxGet_statusText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        LOG.error("XMLHttpRequest.statusText was retrieved before the response was available.");
        return null;
    }

    public void jsxFunction_abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.threadID_);
    }

    public String jsxFunction_getAllResponseHeaders() {
        if (this.webResponse_ != null) {
            StringBuilder buffer = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                buffer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            }
            return buffer.toString();
        }
        LOG.error("XMLHttpRequest.getAllResponseHeaders() was called before the response was available.");
        return null;
    }

    public String jsxFunction_getResponseHeader(String headerName) {
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        return null;
    }

    public void jsxFunction_open(String method, Object urlParam, boolean async, String user, String password) {
        if (urlParam == null || "".equals(urlParam)) {
            throw Context.reportRuntimeError("URL for XHR.open can't be empty!");
        }
        String url = Context.toString(urlParam);
        this.containingPage_ = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            URL fullUrl = this.containingPage_.getFullyQualifiedUrl(url);
            URL originUrl = this.containingPage_.getWebResponse().getRequestSettings().getUrl();
            if (!this.isSameOrigin(originUrl, fullUrl)) {
                throw Context.reportRuntimeError("Access to restricted URI denied");
            }
            WebRequestSettings settings = new WebRequestSettings(fullUrl);
            settings.setCharset("UTF-8");
            settings.setAdditionalHeader("Referer", this.containingPage_.getWebResponse().getRequestSettings().getUrl().toExternalForm());
            HttpMethod submitMethod = HttpMethod.valueOf(method.toUpperCase());
            settings.setHttpMethod(submitMethod);
            if (user != null) {
                DefaultCredentialsProvider dcp = new DefaultCredentialsProvider();
                dcp.addCredentials(user, password);
                settings.setCredentialsProvider(dcp);
            }
            this.requestSettings_ = settings;
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'.");
            return;
        }
        this.async_ = async;
        this.setState(1, null);
    }

    private boolean isSameOrigin(URL originUrl, URL newUrl) {
        if (this.getBrowserVersion().isIE() && "about".equals(newUrl.getProtocol())) {
            return true;
        }
        return originUrl.getHost().equals(newUrl.getHost());
    }

    public void jsxFunction_send(Object content) {
        this.prepareRequest(content);
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        AjaxController ajaxController = client.getAjaxController();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        boolean synchron = ajaxController.processSynchron(page, this.requestSettings_, this.async_);
        if (synchron) {
            this.doSend(Context.getCurrentContext());
        } else {
            final Window startingScope = this.getWindow();
            final HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
            final ContextAction action = new ContextAction(){

                public Object run(Context cx) {
                    cx.putThreadLocal("startingScope", startingScope);
                    XMLHttpRequest.this.doSend(cx);
                    return null;
                }
            };
            JavaScriptJob job = new JavaScriptJob(){

                public void run() {
                    cf.call(action);
                }

                public String toString() {
                    return "XMLHttpRequest Job " + this.getId();
                }
            };
            LOG.debug("Starting XMLHttpRequest thread for asynchronous request");
            this.threadID_ = this.getWindow().getWebWindow().getJobManager().addJob(job, page);
        }
    }

    private void prepareRequest(Object content) {
        String body;
        if (!(content == null || HttpMethod.POST != this.requestSettings_.getHttpMethod() && HttpMethod.PUT != this.requestSettings_.getHttpMethod() || Context.getUndefinedValue().equals(content) || (body = Context.toString(content)).length() <= 0)) {
            LOG.debug("Setting request body to: " + body);
            this.requestSettings_.setRequestBody(body);
        }
    }

    private void doSend(Context context) {
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        try {
            this.setState(2, context);
            WebResponse webResponse = wc.loadWebResponse(this.requestSettings_);
            LOG.debug("Web response loaded successfully.");
            this.webResponse_ = this.overriddenMimeType_ == null ? webResponse : new WebResponseWrapper(webResponse){
                private static final long serialVersionUID = -3359539772772336918L;

                public String getContentType() {
                    return XMLHttpRequest.this.overriddenMimeType_;
                }
            };
            this.setState(3, context);
            this.setState(4, context);
        }
        catch (IOException e) {
            LOG.debug("IOException: returning a network error response.");
            this.webResponse_ = new NetworkErrorWebResponse(this.requestSettings_);
            this.setState(4, context);
            this.processError(context);
        }
    }

    public void jsxFunction_setRequestHeader(String name, String value) {
        if (this.requestSettings_ == null) {
            throw Context.reportRuntimeError("The open() method must be called before setRequestHeader().");
        }
        this.requestSettings_.setAdditionalHeader(name, value);
    }

    public void jsxFunction_overrideMimeType(String mimeType) {
        this.overriddenMimeType_ = mimeType;
    }

    public Object get(String name, Scriptable start) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        super.put(name, start, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NetworkErrorWebResponse
    implements WebResponse {
        private static final long serialVersionUID = 6354426394575804571L;
        private final WebRequestSettings webRequestSettings_;

        private NetworkErrorWebResponse(WebRequestSettings webRequestSettings) {
            this.webRequestSettings_ = webRequestSettings;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return "";
        }

        @Override
        public String getContentType() {
            return "";
        }

        @Override
        public String getContentAsString() {
            return "";
        }

        @Override
        public String getContentAsString(String encoding) {
            return "";
        }

        @Override
        public InputStream getContentAsStream() throws IOException {
            return null;
        }

        @Override
        public byte[] getContentAsBytes() {
            return new byte[0];
        }

        @Override
        @Deprecated
        public URL getRequestUrl() {
            return this.webRequestSettings_.getUrl();
        }

        @Override
        @Deprecated
        public HttpMethod getRequestMethod() {
            return this.webRequestSettings_.getHttpMethod();
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return "";
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public String getContentCharSet() {
            return "";
        }

        @Override
        public String getContentCharset() {
            return "";
        }

        @Override
        public String getContentCharsetOrNull() {
            return "";
        }

        @Override
        public WebRequestSettings getRequestSettings() {
            return this.webRequestSettings_;
        }
    }
}

