/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookie
implements Serializable {
    private static final long serialVersionUID = 1960945152963263900L;
    private final String name_;
    private final String value_;
    private final String domain_;
    private final String path_;
    private final Date expires_;
    private final boolean secure_;

    public Cookie(String name, String value) {
        this(null, name, value);
    }

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        this.domain_ = domain;
        this.name_ = name;
        this.value_ = value != null ? value : "";
        this.path_ = path;
        this.expires_ = expires;
        this.secure_ = secure;
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this.domain_ = domain;
        this.name_ = name;
        this.value_ = value != null ? value : "";
        this.path_ = path;
        this.secure_ = secure;
        if (maxAge < -1) {
            throw new IllegalArgumentException("invalid max age:  " + maxAge);
        }
        this.expires_ = maxAge >= 0 ? new Date(System.currentTimeMillis() + (long)maxAge * 1000L) : null;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getDomain() {
        return this.domain_;
    }

    public String getPath() {
        return this.path_;
    }

    public Date getExpires() {
        return this.expires_;
    }

    public boolean isSecure() {
        return this.secure_;
    }

    public String toString() {
        return this.name_ + "=" + this.value_ + (this.domain_ != null ? ";domain=" + this.domain_ : "") + (this.path_ != null ? ";path=" + this.path_ : "") + (this.expires_ != null ? ";expires=" + this.expires_ : "") + (this.secure_ ? ";secure" : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)o;
        return new EqualsBuilder().append(this.name_, other.name_).append(this.domain_, other.domain_).append(this.path_, other.path_).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.name_).append(this.domain_).append(this.path_).toHashCode();
    }

    public org.apache.commons.httpclient.Cookie toHttpClient() {
        return new org.apache.commons.httpclient.Cookie(this.domain_, this.name_, this.value_, this.path_, this.expires_, this.secure_);
    }

    public static org.apache.commons.httpclient.Cookie[] toHttpClient(Collection<Cookie> cookies) {
        org.apache.commons.httpclient.Cookie[] array = new org.apache.commons.httpclient.Cookie[cookies.size()];
        Iterator<Cookie> it = cookies.iterator();
        for (int i = 0; i < cookies.size(); ++i) {
            array[i] = it.next().toHttpClient();
        }
        return array;
    }

    public static List<Cookie> fromHttpClient(org.apache.commons.httpclient.Cookie[] cookies) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.length);
        for (int i = 0; i < cookies.length; ++i) {
            org.apache.commons.httpclient.Cookie c = cookies[i];
            Cookie cookie = new Cookie(c.getDomain(), c.getName(), c.getValue(), c.getPath(), c.getExpiryDate(), c.getSecure());
            list.add(cookie);
        }
        return list;
    }
}

