/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.extension.jetty;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.cactus.internal.configuration.BaseConfiguration;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.internal.configuration.DefaultFilterConfiguration;
import org.apache.cactus.internal.configuration.DefaultServletConfiguration;
import org.apache.cactus.internal.configuration.FilterConfiguration;
import org.apache.cactus.internal.configuration.ServletConfiguration;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class JettyTestSetup
extends TestSetup {
    private static final String CACTUS_JETTY_CONFIG_PROPERTY = "cactus.jetty.config";
    private static final String CACTUS_JETTY_RESOURCE_DIR_PROPERTY = "cactus.jetty.resourceDir";
    private File configFile;
    private File resourceDir;
    private Object server;
    private boolean alreadyRunning;
    private boolean isRunning = false;
    private boolean forceShutdown = false;
    private ServletConfiguration servletConfiguration;
    private FilterConfiguration filterConfiguration;
    private Configuration baseConfiguration = new BaseConfiguration();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    public JettyTestSetup(Test theTest) {
        super(theTest);
        this.servletConfiguration = new DefaultServletConfiguration();
        this.filterConfiguration = new DefaultFilterConfiguration();
    }

    public JettyTestSetup(Test theTest, Configuration theBaseConfiguration, ServletConfiguration theServletConfiguration, FilterConfiguration theFilterConfiguration) {
        this(theTest);
        this.baseConfiguration = theBaseConfiguration;
        this.servletConfiguration = theServletConfiguration;
        this.filterConfiguration = theFilterConfiguration;
    }

    public void run(TestResult testResult) {
        TestResult testResult2 = testResult;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, testResult2);
        JettyTestSetup.run_aroundBody1$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    protected void setUp() throws Exception {
        URL contextURL = new URL(String.valueOf(this.baseConfiguration.getContextURL()) + "/" + this.servletConfiguration.getDefaultRedirectorName() + "?Cactus_Service=RUN_TEST");
        this.alreadyRunning = this.isAvailable(this.testConnectivity(contextURL));
        if (this.alreadyRunning) {
            this.isRunning = true;
            return;
        }
        this.server = this.createServer(this.baseConfiguration);
        Object context = this.createContext(this.server, this.baseConfiguration);
        this.addServletRedirector(context, this.servletConfiguration);
        this.addJspRedirector(context);
        this.addFilterRedirector(context, this.filterConfiguration);
        if (this.getConfigFile() != null) {
            Class<?> clazz = this.server.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            clazz.getMethod("configure", classArray).invoke(this.server, this.getConfigFile().toString());
        }
        this.server.getClass().getMethod("start", null).invoke(this.server, null);
        this.isRunning = true;
    }

    protected void tearDown() throws Exception {
        boolean started;
        if (!this.forceShutdown && this.alreadyRunning) {
            return;
        }
        if (this.server != null && (started = ((Boolean)this.server.getClass().getMethod("isStarted", null).invoke(this.server, null)).booleanValue())) {
            this.server.getClass().getMethod("stop", null).invoke(this.server, null);
            this.server.getClass().getMethod("destroy", null).invoke(this.server, null);
        }
        this.isRunning = false;
    }

    public final void setConfigFile(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, file2);
        JettyTestSetup.setConfigFile_aroundBody3$advice(this, file2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public final void setResourceDir(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, file2);
        JettyTestSetup.setResourceDir_aroundBody5$advice(this, file2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public final void setForceShutdown(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        JettyTestSetup.setForceShutdown_aroundBody7$advice(this, bl2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    protected final File getConfigFile() {
        String configFileProperty;
        if (this.configFile == null && (configFileProperty = System.getProperty(CACTUS_JETTY_CONFIG_PROPERTY)) != null) {
            this.configFile = new File(configFileProperty);
        }
        return this.configFile;
    }

    protected final File getResourceDir() {
        String resourceDirProperty;
        if (this.resourceDir == null && (resourceDirProperty = System.getProperty(CACTUS_JETTY_RESOURCE_DIR_PROPERTY)) != null) {
            this.resourceDir = new File(resourceDirProperty);
        }
        return this.resourceDir;
    }

    private Object createServer(Configuration theConfiguration) throws Exception {
        Class serverClass = ClassLoaderUtils.loadClass("org.mortbay.jetty.Server", this.getClass());
        Object server = serverClass.newInstance();
        URL contextURL = new URL(theConfiguration.getContextURL());
        Class<?> clazz = server.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        clazz.getMethod("addListener", classArray).invoke(server, "" + contextURL.getPort());
        return server;
    }

    private Object createContext(Object theServer, Configuration theConfiguration) throws Exception {
        URL contextURL = new URL(theConfiguration.getContextURL());
        if (this.getResourceDir() != null) {
            Class<?> clazz = theServer.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            clazz.getMethod("addWebApplication", classArray).invoke(theServer, contextURL.getPath(), this.getResourceDir().toString());
        }
        Class<?> clazz = theServer.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz4;
        Object context = clazz.getMethod("getContext", classArray).invoke(theServer, contextURL.getPath());
        return context;
    }

    private void addServletRedirector(Object theContext, ServletConfiguration theConfiguration) throws Exception {
        Class<?> clazz = theContext.getClass();
        Class[] classArray = new Class[3];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Method method = clazz.getMethod("addServlet", classArray);
        Object[] objectArray = new Object[3];
        objectArray[0] = theConfiguration.getDefaultRedirectorName();
        objectArray[1] = "/" + theConfiguration.getDefaultRedirectorName();
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("org.apache.cactus.server.ServletTestRedirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[2] = clazz5.getName();
        method.invoke(theContext, objectArray);
    }

    private void addJspRedirector(Object theContext) throws Exception {
        if (this.getResourceDir() != null) {
            Class<?> clazz = theContext.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            clazz.getMethod("addServlet", classArray).invoke(theContext, "*.jsp", "org.apache.jasper.servlet.JspServlet");
            Object handler = theContext.getClass().getMethod("getWebApplicationHandler", new Class[0]).invoke(theContext, new Object[0]);
            Class<?> clazz4 = handler.getClass();
            Class[] classArray2 = new Class[4];
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz5;
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[1] = clazz6;
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[2] = clazz7;
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[3] = clazz8;
            clazz4.getMethod("addServlet", classArray2).invoke(handler, "JspRedirector", "/JspRedirector", "org.apache.jasper.servlet.JspServlet", "/jspRedirector.jsp");
        }
    }

    private void addFilterRedirector(Object theContext, FilterConfiguration theConfiguration) throws Exception {
        if (this.getResourceDir() != null) {
            Object handler = theContext.getClass().getMethod("getWebApplicationHandler", new Class[0]).invoke(theContext, new Object[0]);
            Class<?> clazz = handler.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Method method = clazz.getMethod("defineFilter", classArray);
            Object[] objectArray = new Object[2];
            objectArray[0] = theConfiguration.getDefaultRedirectorName();
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.apache.cactus.server.FilterTestRedirector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[1] = clazz4.getName();
            Object filterHolder = method.invoke(handler, objectArray);
            Class<?> clazz5 = filterHolder.getClass();
            Class[] classArray2 = new Class[1];
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz6;
            clazz5.getMethod("addAppliesTo", classArray2).invoke(filterHolder, "REQUEST");
            Class<?> clazz7 = handler.getClass();
            Class[] classArray3 = new Class[2];
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[0] = clazz8;
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[1] = clazz9;
            clazz7.getMethod("mapPathToFilter", classArray3).invoke(handler, "/" + theConfiguration.getDefaultRedirectorName(), theConfiguration.getDefaultRedirectorName());
        }
    }

    protected int testConnectivity(URL theUrl) {
        int code;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestProperty("Connection", "close");
            connection.connect();
            this.readFully(connection);
            connection.disconnect();
            code = connection.getResponseCode();
        }
        catch (IOException iOException) {
            code = -1;
        }
        return code;
    }

    protected boolean isAvailable(int theCode) {
        boolean result = theCode != -1 && theCode < 300;
        return result;
    }

    protected void readFully(HttpURLConnection theConnection) throws IOException {
        if (theConnection.getContentLength() != 0) {
            byte[] buf = new byte[256];
            InputStream in = theConnection.getInputStream();
            while (in.read(buf) != -1) {
            }
        }
    }

    protected boolean isRunning() {
        return this.isRunning;
    }

    static {
        Factory factory = new Factory("JettyTestSetup.java", Class.forName("org.apache.cactus.extension.jetty.JettyTestSetup"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.apache.cactus.extension.jetty.JettyTestSetup-junit.framework.TestResult:-theResult:--void-"), 157);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11-setConfigFile-org.apache.cactus.extension.jetty.JettyTestSetup-java.io.File:-theConfigFile:--void-"), 280);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11-setResourceDir-org.apache.cactus.extension.jetty.JettyTestSetup-java.io.File:-theResourceDir:--void-"), 291);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11-setForceShutdown-org.apache.cactus.extension.jetty.JettyTestSetup-boolean:-isForcedShutdown:--void-"), 300);
    }

    private static final void run_aroundBody0(JettyTestSetup jettyTestSetup, final TestResult testResult, JoinPoint joinPoint) {
        Protectable protectable = new Protectable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void protect() throws Exception {
                try {
                    JettyTestSetup.this.setUp();
                    JettyTestSetup.this.basicRun(testResult);
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    JettyTestSetup.this.tearDown();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                }
                JettyTestSetup.this.tearDown();
            }
        };
        testResult.runProtected(jettyTestSetup, protectable);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object run_aroundBody1$advice(JettyTestSetup this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var9_8 = logger;
            JettyTestSetup.run_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var8_9;
        }
        void var10_10 = logger;
        JettyTestSetup.run_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setConfigFile_aroundBody2(JettyTestSetup jettyTestSetup, File file, JoinPoint joinPoint) {
        jettyTestSetup.configFile = file;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setConfigFile_aroundBody3$advice(JettyTestSetup this_, File ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var9_8 = logger;
            JettyTestSetup.setConfigFile_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var8_9;
        }
        void var10_10 = logger;
        JettyTestSetup.setConfigFile_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setResourceDir_aroundBody4(JettyTestSetup jettyTestSetup, File file, JoinPoint joinPoint) {
        jettyTestSetup.resourceDir = file;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setResourceDir_aroundBody5$advice(JettyTestSetup this_, File ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var9_8 = logger;
            JettyTestSetup.setResourceDir_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var8_9;
        }
        void var10_10 = logger;
        JettyTestSetup.setResourceDir_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setForceShutdown_aroundBody6(JettyTestSetup jettyTestSetup, boolean bl, JoinPoint joinPoint) {
        jettyTestSetup.forceShutdown = bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setForceShutdown_aroundBody7$advice(JettyTestSetup this_, boolean ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var9_8 = logger;
            JettyTestSetup.setForceShutdown_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var8_9;
        }
        void var10_10 = logger;
        JettyTestSetup.setForceShutdown_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

