/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.spi.DeployerWatchdog;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public abstract class AbstractCopyingDeployer
extends MonitoredObject
implements Deployer {
    protected Container container;
    protected AntUtils antUtils = new AntUtils();

    public AbstractCopyingDeployer(Container container) {
        this.container = container;
        this.setMonitor(container.getMonitor());
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected Container getContainer() {
        return this.container;
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setMonitor(this.getMonitor());
        watchdog.waitForDeployment();
    }

    public void deploy(Deployable deployable) {
        File deployableDir = this.getDeployableDir();
        this.getMonitor().info("Deploying [" + deployable.getFile().getPath() + "] to [" + deployableDir.getPath() + "]...", this.getClass().getName());
        if (deployable instanceof WAR) {
            if (!this.getContainer().getCapability().supportsWar()) {
                throw new ContainerException("WAR archives are not supported for deployment in " + this.getContainer().getId() + ". Got [" + deployable.getFile() + "]");
            }
            try {
                if (!((WAR)deployable).isExpandedWar()) {
                    this.deployWar(deployableDir, (WAR)deployable);
                }
                this.deployExpandedWar(deployableDir, (WAR)deployable);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir.getPath() + "]", e);
            }
        } else {
            if (!this.getContainer().getCapability().supportsEar()) {
                throw new ContainerException("EAR archives are not supported for deployment in " + this.getContainer().getId() + ". Got [" + deployable.getFile() + "]");
            }
            try {
                this.deployEar(deployableDir, (EAR)deployable);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir.getPath() + "]", e);
            }
        }
    }

    public abstract File getDeployableDir();

    protected void deployEar(File deployableDir, EAR ear) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        fileUtils.copyFile(ear.getFile(), new File(deployableDir, ear.getFile().getName()), null, true);
    }

    protected void deployWar(File deployableDir, WAR war) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        fileUtils.copyFile(war.getFile(), new File(deployableDir, war.getFile().getName()), null, true);
    }

    protected void deployExpandedWar(File deployableDir, WAR war) {
        Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
        copyTask.setTodir(new File(deployableDir, war.getFile().getName()));
        FileSet fileSet = new FileSet();
        fileSet.setDir(war.getFile());
        copyTask.addFileset(fileSet);
        copyTask.setFailOnError(true);
        copyTask.setIncludeEmptyDirs(true);
        copyTask.setOverwrite(true);
        copyTask.execute();
    }

    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }
}

