/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.AbstractTomcatStandaloneConfiguration;

public class TomcatStandaloneConfiguration
extends AbstractTomcatStandaloneConfiguration {
    public TomcatStandaloneConfiguration(Container container) {
        super(container);
    }

    public TomcatStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public void configure() {
        try {
            FilterChain filterChain = this.createTomcatFilterChain();
            this.createConfigurationDir();
            File confDir = this.getFileUtils().createDirectory(this.getDir(), "conf");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
            File usersDir = this.getFileUtils().createDirectory(confDir, "users");
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/tomcat-users.xml", new File(usersDir, "tomcat-users.xml"), filterChain);
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/modules.xml", new File(confDir, "modules.xml"));
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/apps.xml", new File(confDir, "apps.xml"), filterChain);
            this.setupWebApps();
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private void setupWebApps() {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            File appDir = this.getFileUtils().createDirectory(this.getDir(), "webapps");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable instanceof WAR && !((WAR)deployable).isExpandedWar()) {
                    fileUtils.copyFile(deployable.getFile(), new File(appDir, deployable.getFile().getName()), null, true);
                    continue;
                }
                if (deployable instanceof WAR) continue;
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        String logEventsEnabled = "false";
        String logLevel = this.getPropertyValue("cargo.logging");
        if (logLevel.equalsIgnoreCase("error")) {
            logEventsEnabled = "true";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat3x.logEvents.enabled", logEventsEnabled);
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat3x.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        StringBuffer webappTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            WAR deployable = (WAR)it.next();
            if (!deployable.isExpandedWar()) continue;
            webappTokenValue.append("<Context path=\"");
            webappTokenValue.append("/" + deployable.getContext());
            webappTokenValue.append("\" docBase=\"");
            webappTokenValue.append(deployable.getFile());
            webappTokenValue.append("\" debug=\"");
            webappTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
            webappTokenValue.append("\"/>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "FATAL" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "WARNING" : "DEBUG");
        return level;
    }
}

