/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

public class Environment {
    private static final Class appClass = Environment.loadClass("javax.faces.application.Application");
    private static final boolean is12Compatible;
    private static final boolean is20Compatible;

    private Environment() {
    }

    private static boolean appHasMethod(String methodName, Class ... params) {
        try {
            return appClass.getMethod(methodName, params) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean is20Compatible() {
        return is20Compatible;
    }

    public static boolean is12Compatible() {
        return is12Compatible;
    }

    public static int getJSFMajorVersion() {
        if (Environment.is20Compatible()) {
            return 2;
        }
        return 1;
    }

    public static int getJSFMinorVersion() {
        if (Environment.is20Compatible()) {
            return 0;
        }
        if (Environment.is12Compatible()) {
            return 2;
        }
        return 1;
    }

    public static Class loadClass(String clazz) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        if (appClass != null) {
            is12Compatible = Environment.appHasMethod("getELResolver", new Class[0]) && Environment.appHasMethod("getExpressionFactory", new Class[0]);
            is20Compatible = Environment.appHasMethod("getResourceHandler", new Class[0]) && Environment.appHasMethod("getProjectStage", new Class[0]);
        } else {
            is12Compatible = false;
            is20Compatible = false;
        }
    }
}

