/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession;

import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.jboss.jsfunit.framework.RequestListener;

public class HtmlUnitSnooper
implements RequestListener {
    public static final String SNOOP_PROPERTY = "jsfunit.htmlunitsnooper";

    public static boolean enabled() {
        return System.getProperty(SNOOP_PROPERTY) != null;
    }

    public void beforeRequest(WebRequestSettings webRequestSettings) {
        System.out.println("-----------Snooping HtmlUnit Request---------------------------");
        System.out.println("url=" + webRequestSettings.getUrl());
        System.out.println("method=" + (Object)((Object)webRequestSettings.getHttpMethod()));
        System.out.println("encoding=" + webRequestSettings.getEncodingType());
        System.out.println();
        System.out.println("Additional Headers:");
        Map<String, String> addlHeaders = webRequestSettings.getAdditionalHeaders();
        for (String string : addlHeaders.keySet()) {
            System.out.println(string + "=" + addlHeaders.get(string));
        }
        System.out.println();
        System.out.println("Request Params:");
        for (NameValuePair nameValuePair : webRequestSettings.getRequestParameters()) {
            System.out.println(nameValuePair.getName() + "=" + nameValuePair.getValue());
        }
        System.out.println("---------------------------------------------------------------");
    }

    public void afterRequest(WebResponse webResponse) {
        System.out.println("-----------Snooping HtmlUnit Response---------------------------");
        if (webResponse == null) {
            System.out.println("REQUEST THREW IOException.  Response is null.");
            System.out.println("---------------------------------------------------------------");
        }
        System.out.println("Response time=" + webResponse.getLoadTime() + "ms");
        System.out.println("Status code=" + webResponse.getStatusCode());
        System.out.println("Status message=" + webResponse.getStatusMessage());
        System.out.println("Content type=" + webResponse.getContentType());
        System.out.println("Content char set=" + webResponse.getContentCharset());
        System.out.println();
        System.out.println("Response Headers:");
        for (NameValuePair nameValuePair : webResponse.getResponseHeaders()) {
            System.out.println(nameValuePair.getName() + "=" + nameValuePair.getValue());
        }
        System.out.println();
        System.out.println("Response body:");
        System.out.println(webResponse.getContentAsString());
        System.out.println("---------------------------------------------------------------");
    }
}

