/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.microdeployer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUnitDeployer
extends AbstractSimpleVFSRealDeployer<JBossWebMetaData> {
    private static final VirtualFileFilter JAR_FILTER = new SuffixMatchFilter(".jar");
    private Collection<String> classpathUrls = new ArrayList<String>();
    private Collection<String> warSuffixes;
    private Web25MetaData jsfunitWebMD;
    private boolean disabled = false;
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();

    public JSFUnitDeployer() {
        super(JBossWebMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.parseJSFUnitWebMetaData();
        this.classpathUrls.add(this.findDeployerBaseURL());
        this.log.info((Object)"JSFUnit Deployer is initialized");
    }

    private String findDeployerBaseURL() {
        URL descriptorURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/META-INF/jsfunit-deployers-jboss-beans.xml");
        String urlString = descriptorURL.toString();
        return urlString.substring(0, urlString.lastIndexOf("/META-INF/jsfunit-deployers-jboss-beans.xml"));
    }

    private void parseJSFUnitWebMetaData() {
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        URL webXml = ((Object)((Object)this)).getClass().getClassLoader().getResource("META-INF/web.xml");
        if (webXml == null) {
            throw new IllegalStateException("Unable to find jsfunit web.xml");
        }
        SchemaBinding schema = JBossXBBuilder.build(Web25MetaData.class);
        try {
            this.jsfunitWebMD = (Web25MetaData)unmarshaller.unmarshal(webXml.toString(), schema);
        }
        catch (JBossXBException e) {
            this.disabled = true;
            this.log.error((Object)"Unable to parse jsfunit web.xml", (Throwable)e);
        }
    }

    public void setWarSuffixes(Collection<String> warSuffixes) {
        this.warSuffixes = warSuffixes;
    }

    public void setClasspathURLs(Collection<String> classpathUrls) {
        this.classpathUrls.addAll(classpathUrls);
    }

    private boolean isJSFUnitDeployment(VFSDeploymentUnit unit) {
        if (this.warSuffixes == null) {
            return false;
        }
        for (String warSuffix : this.warSuffixes) {
            if (!unit.getSimpleName().toLowerCase().endsWith(warSuffix + ".war")) continue;
            return true;
        }
        return false;
    }

    public void deploy(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws DeploymentException {
        if (!this.isJSFUnitDeployment(unit)) {
            return;
        }
        if (this.disabled) {
            this.log.warn((Object)(unit.getSimpleName() + " could not be deployed.  JSFUnitDeployer disabled from previous errors."));
            return;
        }
        this.mergeWebXml(metaData);
        try {
            this.addClasspaths(unit);
        }
        catch (MalformedURLException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Malformed URL", (Throwable)e);
        }
        this.log.info((Object)("Added JSFUnit to " + unit.getName()));
    }

    private void addClasspaths(VFSDeploymentUnit unit) throws MalformedURLException {
        if (this.classpathUrls == null) {
            return;
        }
        for (String testUrl : this.classpathUrls) {
            testUrl = StringPropertyReplacer.replaceProperties((String)testUrl);
            URL url = new URL(testUrl);
            try {
                VirtualFile vFile = VFS.getRoot((URL)url);
                unit.addClassPath(new VirtualFile[]{vFile});
                if (vFile.isLeaf()) continue;
                for (VirtualFile jarFile : vFile.getChildrenRecursively(JAR_FILTER)) {
                    unit.addClassPath(new VirtualFile[]{jarFile});
                }
            }
            catch (IOException e) {
                this.log.warn((Object)("Unable to add URL to classpath: " + url.toString()));
            }
        }
    }

    private void mergeWebXml(JBossWebMetaData metaData) {
        FiltersMetaData filters = metaData.getFilters();
        if (filters == null) {
            filters = new FiltersMetaData();
        }
        filters.addAll((Collection)this.jsfunitWebMD.getFilters());
        metaData.setFilters(filters);
        ArrayList filterMappings = metaData.getFilterMappings();
        if (filterMappings == null) {
            filterMappings = new ArrayList();
        }
        filterMappings.addAll(this.jsfunitWebMD.getFilterMappings());
        metaData.setFilterMappings(filterMappings);
        JBossServletsMetaData servlets = metaData.getServlets();
        if (servlets == null) {
            servlets = new JBossServletsMetaData();
        }
        ServletsMetaData servletsMD = this.jsfunitWebMD.getServlets();
        servlets.addAll(this.makeJBossServletsMetaData(servletsMD));
        metaData.setServlets(servlets);
        ArrayList servletMappings = metaData.getServletMappings();
        if (servletMappings == null) {
            servletMappings = new ArrayList();
        }
        servletMappings.addAll(this.jsfunitWebMD.getServletMappings());
        metaData.setServletMappings(servletMappings);
    }

    private Collection<JBossServletMetaData> makeJBossServletsMetaData(ServletsMetaData servletsMD) {
        HashSet<JBossServletMetaData> servletSet = new HashSet<JBossServletMetaData>();
        for (ServletMetaData servletMD : servletsMD) {
            JBossServletMetaData jbossMD = new JBossServletMetaData();
            servletSet.add(jbossMD.merge(servletMD));
        }
        return servletSet;
    }
}

