/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.seam;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.ServerConversationContext;

public class ConversationScope {
    private ConversationScope() {
    }

    static Map getConversationCache() {
        HashMap<String, Object> convCache = new HashMap<String, Object>();
        String convId = ConversationScope.findConversationId();
        if (convId == null) {
            return convCache;
        }
        ServerConversationContext conversationContext = new ServerConversationContext(ConversationScope.sessionMap(), convId);
        for (String name : conversationContext.getNames()) {
            Object value = conversationContext.get(name);
            convCache.put(name, value);
        }
        return convCache;
    }

    private static String findConversationId() {
        HttpSession session = WebConversationFactory.getSessionFromThreadLocal();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(ScopeType.CONVERSATION.getPrefix())) continue;
            String conversationKey = name.substring(ScopeType.CONVERSATION.getPrefix().length() + 1);
            return conversationKey.substring(0, conversationKey.indexOf(36));
        }
        return null;
    }

    private static Map sessionMap() {
        HttpSession session = WebConversationFactory.getSessionFromThreadLocal();
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            sessionMap.put(name, session.getAttribute(name));
        }
        return sessionMap;
    }
}

