/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnectionInsecureSSL;
import com.gargoylesoftware.htmlunit.SocksSocketFactory;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpWebConnection
implements WebConnection {
    private AbstractHttpClient httpClient_;
    private final WebClient webClient_;
    private String virtualHost_;
    private static final long MAX_IN_MEMORY = 512000L;

    public HttpWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
    }

    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        AbstractHttpClient httpClient = this.getHttpClient();
        this.webClient_.getCookieManager().updateState(this.getHttpClient().getCookieStore());
        HttpUriRequest httpMethod = null;
        try {
            httpMethod = this.makeHttpMethod(request);
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            HttpWebConnection.setProxy(httpClient, request);
            long startTime = System.currentTimeMillis();
            HttpResponse httpResponse = httpClient.execute(hostConfiguration, httpMethod);
            DownloadedContent downloadedBody = this.downloadResponseBody(httpResponse);
            long endTime = System.currentTimeMillis();
            this.webClient_.getCookieManager().updateFromState(this.getHttpClient().getCookieStore());
            WebResponse webResponse = this.makeWebResponse(httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to create URI from URL: " + url.toExternalForm() + " (reason: " + e.getMessage() + ")");
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) throws IOException {
        URL url = webRequest.getUrl();
        HttpHost hostConfiguration = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        return hostConfiguration;
    }

    private static void setProxy(HttpClient httpClient, WebRequest webRequest) {
        if (webRequest.getProxyHost() != null) {
            String proxyHost = webRequest.getProxyHost();
            int proxyPort = webRequest.getProxyPort();
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            if (webRequest.isSocksProxy()) {
                SocksSocketFactory factory = (SocksSocketFactory)httpClient.getConnectionManager().getSchemeRegistry().getScheme("http").getSocketFactory();
                factory.setSocksProxy(proxy);
            } else {
                httpClient.getParams().setParameter("http.route.default-proxy", proxy);
            }
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest) throws IOException, URISyntaxException {
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false);
        String charset = webRequest.getCharset();
        URI uri = URIUtils.createURI(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), charset);
                uri = URIUtils.createURI(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), query, null);
                httpMethod.setURI(uri);
            }
        } else {
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)((Object)httpMethod);
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                HttpPost postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), charset);
                    StringEntity urlEncodedEntity = new StringEntity(query, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity(urlEncodedEntity);
                } else {
                    String body = StringUtils.defaultString(webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity(body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity(urlEncodedEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                StringBuilder boundary = new StringBuilder();
                boundary.append("---------------------------");
                Random rand = new Random();
                char[] chars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
                for (int i = 0; i < 14; ++i) {
                    boundary.append(chars[rand.nextInt(chars.length)]);
                }
                Charset c = this.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, boundary.toString(), c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        KeyDataPair pairWithFile = (KeyDataPair)pair;
                        ContentBody contentBody = this.buildFilePart(pairWithFile, charset);
                        multipartEntity.addPart(pair.getName(), contentBody);
                        this.fixBugContentType(multipartEntity, contentBody.getMimeType());
                        continue;
                    }
                    StringBody stringBody = new StringBody(pair.getValue(), Charset.forName(webRequest.getCharset()));
                    multipartEntity.addPart(pair.getName(), stringBody);
                }
                method.setEntity(multipartEntity);
            } else {
                String body = webRequest.getRequestBody();
                if (body != null) {
                    method.setEntity(new StringEntity(body, charset));
                }
            }
        }
        if (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_HOST_FIRST)) {
            int port = webRequest.getUrl().getPort();
            String host = webRequest.getUrl().getHost();
            if (port != 80 && port > 0) {
                host = host + ":" + port;
            }
            httpMethod.setHeader(new BasicHeader("Host", host));
        }
        httpMethod.setHeader(new BasicHeader("User-Agent", this.webClient_.getBrowserVersion().getUserAgent()));
        HttpWebConnection.writeRequestHeadersToHttpMethod(httpMethod, webRequest.getAdditionalHeaders());
        if (webRequest.getCredentialsProvider() != null) {
            this.getHttpClient().setCredentialsProvider(webRequest.getCredentialsProvider());
        }
        if (this.webClient_.getCookieManager().isCookiesEnabled()) {
            this.getHttpClient().getParams().setParameter("http.protocol.single-cookie-header", true);
            this.getHttpClient().getParams().setParameter("http.protocol.cookie-policy", "compatibility");
        } else {
            this.getHttpClient().setCookieStore(new CookieStore(){

                @Override
                public void addCookie(Cookie cookie) {
                }

                @Override
                public void clear() {
                }

                @Override
                public boolean clearExpired(Date date) {
                    return false;
                }

                @Override
                public List<Cookie> getCookies() {
                    return Collections.EMPTY_LIST;
                }
            });
        }
        return httpMethod;
    }

    private Charset getCharset(String charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return CharsetUtil.getCharset(charset);
            }
        }
        return null;
    }

    private void fixBugContentType(MultipartEntity multipartEntity, final String contentType) {
        try {
            Field field = MultipartEntity.class.getDeclaredField("multipart");
            field.setAccessible(true);
            HttpMultipart multipart = (HttpMultipart)field.get(multipartEntity);
            BodyPart lastOne = multipart.getBodyParts().get(multipart.getBodyParts().size() - 1);
            Header header = lastOne.getHeader();
            final org.apache.james.mime4j.parser.Field cntDispHeader = header.getField("Content-Disposition");
            header.removeFields("Content-Disposition");
            org.apache.james.mime4j.parser.Field newCntDispHeader = new org.apache.james.mime4j.parser.Field(){

                public String getBody() {
                    return cntDispHeader.getBody() + "\r\nContent-Type: " + contentType;
                }

                public String getName() {
                    return "Content-Disposition";
                }

                public ByteSequence getRaw() {
                    throw new RuntimeException("No in the hack");
                }
            };
            header.addField(newCntDispHeader);
        }
        catch (Exception e) {
            throw new RuntimeException("Hack to fix Content-Type submission failed", e);
        }
    }

    ContentBody buildFilePart(final KeyDataPair pairWithFile, String charset) throws FileNotFoundException {
        String contentType = pairWithFile.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (pairWithFile.getData() != null) {
            return new InputStreamBody(new ByteArrayInputStream(pairWithFile.getData()), contentType, "");
        }
        if (pairWithFile.getFile() == null) {
            return new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, ""){

                public long getContentLength() {
                    return 0L;
                }
            };
        }
        return new FileBody(pairWithFile.getFile(), contentType){

            public String getFilename() {
                if (this.getFile() == null) {
                    return pairWithFile.getValue();
                }
                if (HttpWebConnection.this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH)) {
                    return this.getFile().getAbsolutePath();
                }
                return super.getFilename();
            }
        };
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpRequestBase method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected synchronized AbstractHttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            this.httpClient_.setRedirectHandler(new DefaultRedirectHandler(){

                public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
                    return super.isRedirectRequested(response, context) && response.getFirstHeader("location") != null;
                }
            });
            this.httpClient_.getParams().setParameter("http.socket.timeout", this.getTimeout());
            this.httpClient_.getParams().setParameter("http.connection.timeout", this.getTimeout());
            if (this.virtualHost_ != null) {
                this.httpClient_.getParams().setParameter("http.virtual-host", this.virtualHost_);
            }
            Scheme httpScheme = new Scheme("http", new SocksSocketFactory(), 80);
            this.httpClient_.getConnectionManager().getSchemeRegistry().register(httpScheme);
        }
        this.httpClient_.setCredentialsProvider(this.webClient_.getCredentialsProvider());
        this.httpClient_.getParams().setParameter("http.socket.timeout", this.webClient_.getTimeout());
        this.httpClient_.getParams().setParameter("http.connection.timeout", this.webClient_.getTimeout());
        return this.httpClient_;
    }

    protected int getTimeout() {
        return this.webClient_.getTimeout();
    }

    protected AbstractHttpClient createHttpClient() {
        BasicHttpParams httpsParams = new BasicHttpParams();
        HttpClientParams.setRedirecting(httpsParams, false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(httpsParams, schemeRegistry);
        return new DefaultHttpClient(connectionManager, httpsParams);
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
        if (this.virtualHost_ != null) {
            this.getHttpClient().getParams().setParameter("http.virtual-host", this.virtualHost_);
        }
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) throws IOException {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (org.apache.http.Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        return HttpWebConnection.downloadContent(httpEntity.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadedContent downloadContent(InputStream is) throws IOException {
        if (is == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int nbRead;
            while ((nbRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, nbRead);
                if ((long)bos.size() <= 512000L) continue;
                File file = File.createTempFile("htmlunit", ".tmp");
                file.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(file);
                bos.writeTo(fos);
                IOUtils.copyLarge(is, fos);
                fos.close();
                DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file);
                return onFile;
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return new DownloadedContent.InMemory(bos.toByteArray());
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestHeadersToHttpMethod(HttpUriRequest httpMethod, Map<String, String> requestHeaders) {
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setUseInsecureSSL(boolean useInsecureSSL) throws GeneralSecurityException {
        HttpWebConnectionInsecureSSL.setUseInsecureSSL(this.getHttpClient(), useInsecureSSL);
    }

    public void shutdown() {
        if (this.httpClient_ != null) {
            this.httpClient_.getConnectionManager().shutdown();
            this.httpClient_ = null;
        }
    }
}

