/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.ImmediateRefreshHandler;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.IncorrectnessListenerImpl;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.UrlFetchWebConnection;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseFromCache;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.attachment.Attachment;
import com.gargoylesoftware.htmlunit.attachment.AttachmentHandler;
import com.gargoylesoftware.htmlunit.gae.GAEUtils;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.ProxyAutoConfig;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.protocol.data.DataUrlDecoder;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.CredentialsProvider;
import org.w3c.css.sac.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
implements Serializable {
    private static final long serialVersionUID = -7214321203864969635L;
    private static final Log LOG = LogFactory.getLog(WebClient.class);
    private static final int ALLOWED_REDIRECTIONS_SAME_URL = 20;
    private transient WebConnection webConnection_ = this.createWebConnection();
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private CredentialsProvider credentialsProvider_ = new DefaultCredentialsProvider();
    private ProxyConfig proxyConfig_;
    private CookieManager cookieManager_ = new CookieManager();
    private transient JavaScriptEngine scriptEngine_;
    private boolean javaScriptEnabled_ = true;
    private boolean cssEnabled_ = true;
    private boolean appletEnabled_;
    private boolean popupBlockerEnabled_;
    private String homePage_;
    private final Map<String, String> requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private IncorrectnessListener incorrectnessListener_ = new IncorrectnessListenerImpl();
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private StatusHandler statusHandler_;
    private AttachmentHandler attachmentHandler_;
    private AjaxController ajaxController_ = new AjaxController();
    private BrowserVersion browserVersion_;
    private boolean isRedirectEnabled_ = true;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private final Set<WebWindowListener> webWindowListeners_ = new HashSet<WebWindowListener>(5);
    private final Stack<TopLevelWindow> topLevelWindows_ = new Stack();
    private final List<WebWindow> windows_ = Collections.synchronizedList(new ArrayList());
    private WebWindow currentWindow_;
    private int timeout_;
    private HTMLParserListener htmlParserListener_;
    private ErrorHandler cssErrorHandler_ = new DefaultCssErrorHandler();
    private OnbeforeunloadHandler onbeforeunloadHandler_;
    private Cache cache_ = new Cache();
    public static final URL URL_ABOUT_BLANK = UrlUtils.toUrlSafe("about:blank");
    private static final WebResponse WEB_RESPONSE_FOR_ABOUT_BLANK = new StringWebResponse("", URL_ABOUT_BLANK);
    private ScriptPreProcessor scriptPreProcessor_;
    private Map<String, String> activeXObjectMap_ = Collections.emptyMap();
    private boolean activeXNative_;
    private RefreshHandler refreshHandler_ = new ImmediateRefreshHandler();
    private boolean throwExceptionOnScriptError_ = true;
    private final List<LoadJob> loadQueue_ = new ArrayList<LoadJob>();

    public WebClient() {
        this(BrowserVersion.getDefault());
    }

    public WebClient(BrowserVersion browserVersion) {
        WebAssert.notNull("browserVersion", browserVersion);
        this.init(browserVersion, new ProxyConfig());
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        WebAssert.notNull("browserVersion", browserVersion);
        WebAssert.notNull("proxyHost", proxyHost);
        this.init(browserVersion, new ProxyConfig(proxyHost, proxyPort));
    }

    private void init(BrowserVersion browserVersion, ProxyConfig proxyConfig) {
        this.homePage_ = "http://htmlunit.sf.net/";
        this.browserVersion_ = browserVersion;
        this.proxyConfig_ = proxyConfig;
        this.scriptEngine_ = new JavaScriptEngine(this);
        this.addWebWindowListener(new CurrentWindowTracker());
        this.currentWindow_ = new TopLevelWindow("", this);
        this.fireWindowOpened(new WebWindowEvent(this.currentWindow_, 1, null, null));
    }

    public WebConnection getWebConnection() {
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        WebAssert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public <P extends Page> P getPage(WebWindow webWindow, WebRequest parameters) throws IOException, FailingHttpStatusCodeException {
        WebResponse webResponse;
        String protocol;
        HtmlPage htmlPage;
        Page page = webWindow.getEnclosedPage();
        if (page != null) {
            URL prev = page.getWebResponse().getWebRequest().getUrl();
            URL current = parameters.getUrl();
            if (current.sameFile(prev) && current.getRef() != null && !StringUtils.equals(current.getRef(), prev.getRef())) {
                page.getWebResponse().getWebRequest().setUrl(current);
                webWindow.getHistory().addPage(page);
                return (P)page;
            }
        }
        if (page instanceof HtmlPage && !(htmlPage = (HtmlPage)page).isOnbeforeunloadAccepted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The registered OnbeforeunloadHandler rejected to load a new page.");
            }
            return (P)page;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get page for window named '" + webWindow.getName() + "', using " + parameters);
        }
        if ((protocol = parameters.getUrl().getProtocol()).equals("javascript")) {
            webResponse = this.makeWebResponseForJavaScriptUrl(webWindow, parameters.getUrl(), parameters.getCharset());
            if (webWindow.getEnclosedPage() != null && webWindow.getEnclosedPage().getWebResponse() == webResponse) {
                return (P)webWindow.getEnclosedPage();
            }
        } else {
            webResponse = this.loadWebResponse(parameters);
        }
        this.printContentIfNecessary(webResponse);
        this.loadWebResponseInto(webResponse, webWindow);
        this.throwFailingHttpStatusCodeExceptionIfNecessary(webResponse);
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.registerWindowAndMaybeStartEventLoop(webWindow);
        }
        return (P)webWindow.getEnclosedPage();
    }

    public <P extends Page> P getPage(WebWindow opener, String target, WebRequest params) throws FailingHttpStatusCodeException, IOException {
        return this.getPage(this.openTargetWindow(opener, target, "_self"), params);
    }

    public <P extends Page> P getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        return this.getPage(UrlUtils.toUrlUnsafe(url));
    }

    public <P extends Page> P getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), new WebRequest(url));
    }

    public <P extends Page> P getPage(WebRequest request) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), request);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException, FailingHttpStatusCodeException {
        WebAssert.notNull("webResponse", webResponse);
        WebAssert.notNull("webWindow", webWindow);
        if (webResponse.getStatusCode() == 204) {
            return webWindow.getEnclosedPage();
        }
        if (this.attachmentHandler_ != null && Attachment.isAttachment(webResponse)) {
            WebWindow w = this.openWindow(null, null, webWindow);
            Page page = this.pageCreator_.createPage(webResponse, w);
            this.attachmentHandler_.handleAttachment(page);
            return page;
        }
        Page oldPage = webWindow.getEnclosedPage();
        if (oldPage != null) {
            oldPage.cleanUp();
        }
        Page newPage = null;
        if (this.windows_.contains(webWindow) || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_150)) {
            newPage = this.pageCreator_.createPage(webResponse, webWindow);
            if (this.windows_.contains(webWindow)) {
                this.fireWindowContentChanged(new WebWindowEvent(webWindow, 3, oldPage, newPage));
                if (webWindow.getEnclosedPage() == newPage) {
                    FrameWindow fw;
                    BaseFrame frame;
                    newPage.initialize();
                    if (webWindow instanceof FrameWindow && !(newPage instanceof HtmlPage) && (frame = (fw = (FrameWindow)webWindow).getFrameElement()).hasEventHandlers("onload")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Executing onload handler for " + frame);
                        }
                        Event event = new Event(frame, "load");
                        ((Node)frame.getScriptObject()).executeEvent(event);
                    }
                }
            }
        }
        return newPage;
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean getPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void printContentIfNecessary(WebResponse webResponse) {
        boolean successful;
        String contentType = webResponse.getContentType();
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300;
        if (this.getPrintContentOnFailingStatusCode() && !successful) {
            LOG.info("statusCode=[" + statusCode + "] contentType=[" + contentType + "]");
            LOG.info(webResponse.getContentAsString());
        }
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean isThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public void throwFailingHttpStatusCodeExceptionIfNecessary(WebResponse webResponse) {
        boolean successful;
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300 || statusCode == 305 || statusCode == 304;
        if (this.isThrowExceptionOnFailingStatusCode() && !successful) {
            throw new FailingHttpStatusCodeException(webResponse);
        }
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        WebAssert.notNull("credentialsProvider", credentialsProvider);
        this.credentialsProvider_ = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    public void setJavaScriptEngine(JavaScriptEngine engine) {
        if (engine == null) {
            throw new NullPointerException("Can't set JavaScriptEngine to null");
        }
        this.scriptEngine_ = engine;
    }

    public void setJavaScriptEnabled(boolean enabled) {
        this.javaScriptEnabled_ = enabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_;
    }

    public void setCssEnabled(boolean enabled) {
        this.cssEnabled_ = enabled;
    }

    public boolean isCssEnabled() {
        return this.cssEnabled_;
    }

    public void setAppletEnabled(boolean enabled) {
        this.appletEnabled_ = enabled;
    }

    public boolean isAppletEnabled() {
        return this.appletEnabled_;
    }

    public void setPopupBlockerEnabled(boolean enabled) {
        this.popupBlockerEnabled_ = enabled;
    }

    public boolean isPopupBlockerEnabled() {
        return this.popupBlockerEnabled_;
    }

    public String getHomePage() {
        return this.homePage_;
    }

    public void setHomePage(String homePage) {
        this.homePage_ = homePage;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig_;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        WebAssert.notNull("proxyConfig", proxyConfig);
        this.proxyConfig_ = proxyConfig;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager_;
    }

    public void setCookieManager(CookieManager cookieManager) {
        WebAssert.notNull("cookieManager", cookieManager);
        this.cookieManager_ = cookieManager;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler_ = statusHandler;
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        Window jsWindow;
        HtmlElement focusedElement;
        Page enclosedPage;
        WebAssert.notNull("window", window);
        if (this.currentWindow_ == window) {
            return;
        }
        if (this.currentWindow_ != null && !this.currentWindow_.isClosed() && (enclosedPage = this.currentWindow_.getEnclosedPage()) instanceof HtmlPage && (focusedElement = ((HtmlPage)enclosedPage).getFocusedElement()) != null) {
            focusedElement.fireEvent("blur");
        }
        this.currentWindow_ = window;
        enclosedPage = this.currentWindow_.getEnclosedPage();
        if (enclosedPage instanceof HtmlPage && (jsWindow = (Window)this.currentWindow_.getScriptObject()) != null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.WINDOW_ACTIVE_ELEMENT_FOCUSED)) {
                HTMLElement activeElement = (HTMLElement)jsWindow.getDocument().jsxGet_activeElement();
                if (activeElement != null) {
                    ((HtmlPage)enclosedPage).setFocusedElement(activeElement.getDomNodeOrDie(), true);
                }
            } else {
                HtmlElement focusedElement2 = ((HtmlPage)enclosedPage).getFocusedElement();
                if (focusedElement2 != null) {
                    ((HtmlPage)enclosedPage).setFocusedElement(focusedElement2, true);
                }
            }
        }
    }

    public void addWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowOpened(event);
        }
    }

    private void fireWindowClosed(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowClosed(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        WebAssert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, this.getCurrentWindow());
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window = this.openTargetWindow(opener, windowName, "_blank");
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        if (url != null) {
            try {
                WebRequest request = new WebRequest(url);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DIALOGWINDOW_REFERER) && openerPage != null) {
                    String referer = openerPage.getWebResponse().getWebRequest().getUrl().toExternalForm();
                    request.setAdditionalHeader("Referer", referer);
                }
                this.getPage(window, request);
            }
            catch (IOException e) {
                LOG.error("Error loading content into window", e);
            }
        } else {
            this.initializeEmptyWindow(window);
            if (openerPage != null) {
                Window jsWindow = (Window)window.getScriptObject();
                jsWindow.setDomNode(openerPage);
                jsWindow.getDocument().setDomNode(openerPage);
            }
        }
        return window;
    }

    private WebWindow openTargetWindow(WebWindow opener, String windowName, String defaultName) {
        WebWindow webWindow;
        WebAssert.notNull("opener", opener);
        WebAssert.notNull("defaultName", defaultName);
        String windowToOpen = windowName;
        if (windowToOpen == null || windowToOpen.length() == 0) {
            windowToOpen = defaultName;
        }
        if ((webWindow = this.resolveWindow(opener, windowToOpen)) == null) {
            if ("_blank".equals(windowToOpen)) {
                windowToOpen = "";
            }
            webWindow = new TopLevelWindow(windowToOpen, this);
            this.fireWindowOpened(new WebWindowEvent(webWindow, 1, null, null));
        }
        if (webWindow instanceof TopLevelWindow && webWindow != opener.getTopWindow()) {
            ((TopLevelWindow)webWindow).setOpener(opener);
        }
        return webWindow;
    }

    private WebWindow resolveWindow(WebWindow opener, String name) {
        if (name == null || name.length() == 0 || name.equals("_self")) {
            return opener;
        }
        if (name.equals("_parent")) {
            return opener.getParentWindow();
        }
        if (name.equals("_top")) {
            return opener.getTopWindow();
        }
        if (name.equals("_blank")) {
            return null;
        }
        if (name.length() != 0) {
            try {
                return this.getWebWindowByName(name);
            }
            catch (WebWindowNotFoundException webWindowNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public DialogWindow openDialogWindow(URL url, WebWindow opener, Object dialogArguments) throws IOException {
        WebAssert.notNull("url", url);
        WebAssert.notNull("opener", opener);
        DialogWindow window = new DialogWindow(this, dialogArguments);
        this.fireWindowOpened(new WebWindowEvent(window, 1, null, null));
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        WebRequest request = new WebRequest(url);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DIALOGWINDOW_REFERER)) {
            String referer = openerPage.getWebResponse().getWebRequest().getUrl().toExternalForm();
            request.setAdditionalHeader("Referer", referer);
        }
        this.getPage(window, request);
        return window;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setUseInsecureSSL(boolean useInsecureSSL) throws GeneralSecurityException {
        if (this.webConnection_ instanceof HttpWebConnection) {
            ((HttpWebConnection)this.webConnection_).setUseInsecureSSL(useInsecureSSL);
        }
    }

    public void setPageCreator(PageCreator pageCreator) {
        WebAssert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        WebAssert.notNull("name", name);
        for (WebWindow webWindow : this.windows_) {
            if (!webWindow.getName().equals(name)) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void initialize(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.scriptEngine_.initialize(webWindow);
    }

    public void initialize(Page newPage) {
        WebAssert.notNull("newPage", newPage);
        ((Window)newPage.getEnclosingWindow().getScriptObject()).initialize(newPage);
    }

    public void initializeEmptyWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.initialize(webWindow);
        ((Window)webWindow.getScriptObject()).initialize();
    }

    public void registerWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.windows_.add(webWindow);
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.windows_.remove(webWindow);
        this.fireWindowClosed(new WebWindowEvent(webWindow, 2, webWindow.getEnclosedPage(), null));
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String newUrl = UrlUtils.resolveUrl(baseUrl, relativeUrl);
        return UrlUtils.toUrlUnsafe(newUrl);
    }

    private WebResponse makeWebResponseForDataUrl(WebRequest webRequest) throws IOException {
        DataUrlDecoder decoder;
        URL url = webRequest.getUrl();
        ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>();
        try {
            decoder = DataUrlDecoder.decode(url);
        }
        catch (DecoderException e) {
            throw new IOException(e.getMessage());
        }
        responseHeaders.add(new NameValuePair("content-type", decoder.getMediaType() + ";charset=" + decoder.getCharset()));
        DownloadedContent downloadedContent = HttpWebConnection.downloadContent(url.openStream());
        WebResponseData data = new WebResponseData(downloadedContent, 200, "OK", responseHeaders);
        return new WebResponse(data, url, webRequest.getHttpMethod(), 0L);
    }

    private WebResponse makeWebResponseForAboutUrl(URL url) {
        String urlWithoutQuery = StringUtils.substringBefore(url.toExternalForm(), "?");
        if (!StringUtils.substringAfter(urlWithoutQuery, "about:").equalsIgnoreCase("blank")) {
            throw new IllegalArgumentException(url + " is not supported, only about:blank is supported now.");
        }
        return WEB_RESPONSE_FOR_ABOUT_BLANK;
    }

    private WebResponse makeWebResponseForFileUrl(WebRequest webRequest) throws IOException {
        URL cleanUrl = webRequest.getUrl();
        if (cleanUrl.getQuery() != null) {
            cleanUrl = UrlUtils.getUrlWithNewQuery(cleanUrl, null);
        }
        if (cleanUrl.getRef() != null) {
            cleanUrl = UrlUtils.getUrlWithNewRef(cleanUrl, null);
        }
        File file = FileUtils.toFile(cleanUrl);
        String contentType = this.guessContentType(file);
        DownloadedContent.OnFile content = new DownloadedContent.OnFile(file);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        WebResponseData responseData = new WebResponseData(content, 200, "OK", compiledHeaders);
        return new WebResponse(responseData, webRequest, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String guessContentType(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (file.getName().endsWith(".xhtml")) {
            contentType = "application/xhtml+xml";
        }
        if (contentType == null) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                contentType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(inputStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
        }
        if (contentType == null) {
            contentType = file.getName().endsWith(".js") ? "text/javascript" : "application/octet-stream";
        }
        return contentType;
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, URL url, String charset) throws FailingHttpStatusCodeException, IOException {
        HtmlPage page;
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            page = frameWindow.getEnclosingPage();
        } else {
            Page currentPage = webWindow.getEnclosedPage();
            if (currentPage == null) {
                currentPage = this.getPage(webWindow, new WebRequest(URL_ABOUT_BLANK));
            }
            page = (HtmlPage)currentPage;
        }
        ScriptResult r = page.executeJavaScriptIfPossible(url.toExternalForm(), "JavaScript URL", 1);
        if (r != null && r.getJavaScriptResult() == null || ScriptResult.isUndefined(r)) {
            return webWindow.getEnclosedPage().getWebResponse();
        }
        String contentString = r.getJavaScriptResult().toString();
        return new StringWebResponse(contentString, charset, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
        String protocol = webRequest.getUrl().getProtocol();
        if (protocol.equals("about")) {
            return this.makeWebResponseForAboutUrl(webRequest.getUrl());
        }
        if (protocol.equals("file")) {
            return this.makeWebResponseForFileUrl(webRequest);
        }
        if (!protocol.equals("data")) return this.loadWebResponseFromWebConnection(webRequest, 20);
        if (!this.browserVersion_.hasFeature(BrowserVersionFeatures.PROTOCOL_DATA)) throw new MalformedURLException("Unknown protocol: data");
        return this.makeWebResponseForDataUrl(webRequest);
    }

    private WebResponse loadWebResponseFromWebConnection(WebRequest webRequest, int allowedRedirects) throws IOException {
        WebResponse webResponse;
        URL url = webRequest.getUrl();
        HttpMethod method = webRequest.getHttpMethod();
        List<NameValuePair> parameters = webRequest.getRequestParameters();
        WebAssert.notNull("url", url);
        WebAssert.notNull("method", (Object)method);
        WebAssert.notNull("parameters", parameters);
        url = UrlUtils.encodeUrl(url, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_MINIMAL_QUERY_ENCODING));
        webRequest.setUrl(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Load response for " + (Object)((Object)method) + " " + url.toExternalForm());
        }
        if (webRequest.getProxyHost() == null) {
            if (this.proxyConfig_.getProxyAutoConfigUrl() != null) {
                if (!this.proxyConfig_.getProxyAutoConfigUrl().equals(url.toExternalForm())) {
                    int colonIndex;
                    String value;
                    String content = this.proxyConfig_.getProxyAutoConfigContent();
                    if (content == null) {
                        content = this.getPage(this.proxyConfig_.getProxyAutoConfigUrl()).getWebResponse().getContentAsString();
                        this.proxyConfig_.setProxyAutoConfigContent(content);
                    }
                    String allValue = ProxyAutoConfig.evaluate(content, url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy Auto-Config: value '" + allValue + "' for URL " + url);
                    }
                    if ((value = allValue.split(";")[0].trim()).startsWith("PROXY")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(false);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    } else if (value.startsWith("SOCKS")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(true);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    }
                }
            } else if (!this.proxyConfig_.shouldBypassProxy(webRequest.getUrl().getHost())) {
                webRequest.setProxyHost(this.proxyConfig_.getProxyHost());
                webRequest.setProxyPort(this.proxyConfig_.getProxyPort());
                webRequest.setSocksProxy(this.proxyConfig_.isSocksProxy());
            }
        }
        this.addDefaultHeaders(webRequest);
        Object fromCache = this.getCache().getCachedObject(webRequest);
        if (fromCache != null && fromCache instanceof WebResponse) {
            webResponse = new WebResponseFromCache((WebResponse)fromCache, webRequest);
        } else {
            webResponse = this.getWebConnection().getResponse(webRequest);
            this.getCache().cacheIfPossible(webRequest, webResponse, webResponse);
        }
        int status = webResponse.getStatusCode();
        if (status == 305) {
            this.getIncorrectnessListener().notify("Ignoring HTTP status code [305] 'Use Proxy'", this);
        } else if (status >= 301 && status <= 307 && status != 304 && this.isRedirectEnabled()) {
            URL newUrl;
            String locationString = null;
            try {
                locationString = webResponse.getResponseHeaderValue("Location");
                if (locationString == null) {
                    return webResponse;
                }
                newUrl = WebClient.expandUrl(url, locationString);
            }
            catch (MalformedURLException e) {
                this.getIncorrectnessListener().notify("Got a redirect status code [" + status + " " + webResponse.getStatusMessage() + "] but the location is not a valid URL [" + locationString + "]. Skipping redirection processing.", this);
                return webResponse;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got a redirect status code [" + status + "] new location = [" + locationString + "]");
            }
            if (allowedRedirects == 0) {
                throw new FailingHttpStatusCodeException("Too much redirect for " + webResponse.getWebRequest().getUrl(), webResponse);
            }
            if ((status == 301 || status == 307) && method.equals((Object)HttpMethod.GET)) {
                WebRequest wrs = new WebRequest(newUrl);
                wrs.setRequestParameters(parameters);
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
            if (status <= 303) {
                WebRequest wrs = new WebRequest(newUrl);
                wrs.setHttpMethod(HttpMethod.GET);
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
        }
        return webResponse;
    }

    private void addDefaultHeaders(WebRequest wrs) {
        if (!wrs.isAdditionalHeader("Accept-Language")) {
            wrs.setAdditionalHeader("Accept-Language", this.getBrowserVersion().getBrowserLanguage());
        }
        wrs.getAdditionalHeaders().putAll(this.requestHeaders_);
    }

    public List<WebWindow> getWebWindows() {
        return Collections.unmodifiableList(this.windows_);
    }

    public List<TopLevelWindow> getTopLevelWindows() {
        return Collections.unmodifiableList(this.topLevelWindows_);
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler_ = handler == null ? new ImmediateRefreshHandler() : handler;
    }

    public RefreshHandler getRefreshHandler() {
        return this.refreshHandler_;
    }

    public void setScriptPreProcessor(ScriptPreProcessor scriptPreProcessor) {
        this.scriptPreProcessor_ = scriptPreProcessor;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor_;
    }

    public void setActiveXObjectMap(Map<String, String> activeXObjectMap) {
        this.activeXObjectMap_ = activeXObjectMap;
    }

    public Map<String, String> getActiveXObjectMap() {
        return this.activeXObjectMap_;
    }

    public void setActiveXNative(boolean allow) {
        this.activeXNative_ = allow;
    }

    public boolean isActiveXNative() {
        return this.activeXNative_;
    }

    public void setHTMLParserListener(HTMLParserListener listener) {
        this.htmlParserListener_ = listener;
    }

    public HTMLParserListener getHTMLParserListener() {
        return this.htmlParserListener_;
    }

    public ErrorHandler getCssErrorHandler() {
        return this.cssErrorHandler_;
    }

    public void setCssErrorHandler(ErrorHandler cssErrorHandler) {
        WebAssert.notNull("cssErrorHandler", cssErrorHandler);
        this.cssErrorHandler_ = cssErrorHandler;
    }

    public void setJavaScriptTimeout(long timeout) {
        this.scriptEngine_.getContextFactory().setTimeout(timeout);
    }

    public long getJavaScriptTimeout() {
        return this.scriptEngine_.getContextFactory().getTimeout();
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public boolean isThrowExceptionOnScriptError() {
        return this.throwExceptionOnScriptError_;
    }

    public void setThrowExceptionOnScriptError(boolean newValue) {
        this.throwExceptionOnScriptError_ = newValue;
    }

    public IncorrectnessListener getIncorrectnessListener() {
        return this.incorrectnessListener_;
    }

    public void setIncorrectnessListener(IncorrectnessListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null incorrectness listener.");
        }
        this.incorrectnessListener_ = listener;
    }

    public AjaxController getAjaxController() {
        return this.ajaxController_;
    }

    public void setAjaxController(AjaxController newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.ajaxController_ = newValue;
    }

    public void setAttachmentHandler(AttachmentHandler handler) {
        this.attachmentHandler_ = handler;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler_;
    }

    public void setOnbeforeunloadHandler(OnbeforeunloadHandler onbeforeunloadHandler) {
        this.onbeforeunloadHandler_ = onbeforeunloadHandler;
    }

    public OnbeforeunloadHandler getOnbeforeunloadHandler() {
        return this.onbeforeunloadHandler_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache should not be null!");
        }
        this.cache_ = cache;
    }

    public void closeAllWindows() {
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.shutdownJavaScriptExecutor();
        }
        ArrayList<TopLevelWindow> topWindows = new ArrayList<TopLevelWindow>();
        for (TopLevelWindow window : this.topLevelWindows_) {
            if (!(window instanceof TopLevelWindow)) continue;
            topWindows.add(window);
        }
        for (TopLevelWindow topWindow : topWindows) {
            if (!this.topLevelWindows_.contains(topWindow)) continue;
            topWindow.close();
        }
        if (this.webConnection_ instanceof HttpWebConnection) {
            ((HttpWebConnection)this.webConnection_).shutdown();
        }
    }

    public int waitForBackgroundJavaScript(long timeoutMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            long newTimeout = endTime - System.currentTimeMillis();
            count += window.getJobManager().waitForJobs(newTimeout);
        }
        if (count != this.getAggregateJobCount()) {
            long newTimeout = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScript(newTimeout);
        }
        return count;
    }

    public int waitForBackgroundJavaScriptStartingBefore(long delayMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + delayMillis;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            long newDelay = endTime - System.currentTimeMillis();
            count += window.getJobManager().waitForJobsStartingBefore(newDelay);
        }
        if (count != this.getAggregateJobCount()) {
            long newDelay = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScriptStartingBefore(newDelay);
        }
        return count;
    }

    private int getAggregateJobCount() {
        int count = 0;
        Iterator<WebWindow> i = this.windows_.iterator();
        while (i.hasNext()) {
            WebWindow window;
            try {
                window = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.windows_.iterator();
                count = 0;
                continue;
            }
            count += window.getJobManager().getJobCount();
        }
        return count;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webConnection_ = this.createWebConnection();
        this.scriptEngine_ = new JavaScriptEngine(this);
    }

    private WebConnection createWebConnection() {
        if (GAEUtils.isGaeMode()) {
            return new UrlFetchWebConnection(this);
        }
        return new HttpWebConnection(this);
    }

    public void download(WebWindow requestingWindow, String target, WebRequest request, String description) {
        LoadJob loadJob;
        WebWindow win = this.resolveWindow(requestingWindow, target);
        URL url = request.getUrl();
        boolean justHashJump = false;
        if (win != null) {
            Page page = win.getEnclosedPage();
            if (page instanceof HtmlPage && !((HtmlPage)page).isOnbeforeunloadAccepted()) {
                return;
            }
            URL current = page.getWebResponse().getWebRequest().getUrl();
            if (url.sameFile(current) && !StringUtils.equals(current.getRef(), url.getRef())) {
                justHashJump = true;
            }
        }
        for (LoadJob loadJob2 : this.loadQueue_) {
            if (loadJob2.response_ == null) continue;
            WebRequest otherRequest = loadJob2.response_.getWebRequest();
            URL otherUrl = otherRequest.getUrl();
            if (!url.getPath().equals(otherUrl.getPath()) || !url.getHost().equals(otherUrl.getHost()) || !url.getProtocol().equals(otherUrl.getProtocol()) || url.getPort() != otherUrl.getPort() || request.getHttpMethod() != otherRequest.getHttpMethod()) continue;
            return;
        }
        if (justHashJump) {
            loadJob = new LoadJob(win, target, url);
        } else {
            try {
                WebResponse response = this.loadWebResponse(request);
                loadJob = new LoadJob(requestingWindow, target, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.loadQueue_.add(loadJob);
    }

    public void loadDownloadedResponses() throws FailingHttpStatusCodeException, IOException {
        if (this.loadQueue_.isEmpty()) {
            return;
        }
        ArrayList<LoadJob> queue = new ArrayList<LoadJob>(this.loadQueue_);
        this.loadQueue_.clear();
        HashSet<WebWindow> updatedWindows = new HashSet<WebWindow>();
        for (int i = queue.size() - 1; i >= 0; --i) {
            WebWindow window;
            LoadJob downloadedResponse = (LoadJob)queue.get(i);
            if (downloadedResponse.isOutdated()) {
                LOG.info("No usage of download: " + downloadedResponse);
                continue;
            }
            if (downloadedResponse.urlWithOnlyHashChange_ != null) {
                window = downloadedResponse.requestingWindow_;
                HtmlPage page = (HtmlPage)window.getEnclosedPage();
                page.getWebResponse().getWebRequest().setUrl(downloadedResponse.urlWithOnlyHashChange_);
                window.getHistory().addPage(page);
                continue;
            }
            window = this.resolveWindow(downloadedResponse.requestingWindow_, downloadedResponse.target_);
            if (!updatedWindows.contains(window)) {
                WebWindow win = this.openTargetWindow(downloadedResponse.requestingWindow_, downloadedResponse.target_, "_self");
                Page pageBeforeLoad = win.getEnclosedPage();
                this.loadWebResponseInto(downloadedResponse.response_, win);
                this.throwFailingHttpStatusCodeExceptionIfNecessary(downloadedResponse.response_);
                if (pageBeforeLoad == win.getEnclosedPage()) continue;
                updatedWindows.add(win);
                continue;
            }
            LOG.info("No usage of download: " + downloadedResponse);
        }
    }

    private static class LoadJob {
        private final WebWindow requestingWindow_;
        private final String target_;
        private final WebResponse response_;
        private final URL urlWithOnlyHashChange_;
        private final WeakReference<Page> originalPage_;

        LoadJob(WebWindow requestingWindow, String target, WebResponse response) {
            this.requestingWindow_ = requestingWindow;
            this.target_ = target;
            this.response_ = response;
            this.urlWithOnlyHashChange_ = null;
            this.originalPage_ = new WeakReference<Page>(requestingWindow.getEnclosedPage());
        }

        LoadJob(WebWindow requestingWindow, String target, URL urlWithOnlyHashChange) {
            this.requestingWindow_ = requestingWindow;
            this.target_ = target;
            this.response_ = null;
            this.urlWithOnlyHashChange_ = urlWithOnlyHashChange;
            this.originalPage_ = new WeakReference<Page>(requestingWindow.getEnclosedPage());
        }

        public boolean isOutdated() {
            if (this.target_ != null && this.target_.length() != 0) {
                return false;
            }
            if (this.requestingWindow_.isClosed()) {
                return true;
            }
            return this.requestingWindow_.getEnclosedPage() != this.originalPage_.get();
        }
    }

    class CurrentWindowTracker
    implements WebWindowListener,
    Serializable {
        private static final long serialVersionUID = -987538223249485123L;

        CurrentWindowTracker() {
        }

        public void webWindowClosed(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)event.getWebWindow();
                WebClient.this.topLevelWindows_.remove(tlw);
                if (tlw.equals(WebClient.this.getCurrentWindow())) {
                    if (WebClient.this.topLevelWindows_.isEmpty()) {
                        TopLevelWindow newWindow = new TopLevelWindow("", WebClient.this);
                        WebClient.this.topLevelWindows_.push(newWindow);
                        WebClient.this.setCurrentWindow(newWindow);
                    } else {
                        WebClient.this.setCurrentWindow((WebWindow)WebClient.this.topLevelWindows_.peek());
                    }
                }
            } else if (event.getWebWindow() == WebClient.this.getCurrentWindow()) {
                WebClient.this.setCurrentWindow((WebWindow)WebClient.this.topLevelWindows_.peek());
            }
        }

        public void webWindowContentChanged(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            boolean use = false;
            if (window instanceof DialogWindow) {
                use = true;
            } else if (window instanceof TopLevelWindow) {
                use = event.getOldPage() == null;
            } else if (window instanceof FrameWindow) {
                FrameWindow fw = (FrameWindow)window;
                String enclosingPageState = fw.getEnclosingPage().getDocumentElement().getReadyState();
                URL frameUrl = fw.getEnclosedPage().getWebResponse().getWebRequest().getUrl();
                if (!"complete".equals(enclosingPageState) || frameUrl == URL_ABOUT_BLANK) {
                    return;
                }
                BaseFrame frameElement = fw.getFrameElement();
                if (frameElement.isDisplayed()) {
                    ScriptableObject scriptableObject = frameElement.getScriptObject();
                    ComputedCSSStyleDeclaration style = ((HTMLElement)scriptableObject).jsxGet_currentStyle();
                    boolean bl = use = style.getCalculatedWidth(false, false) != 0 && style.getCalculatedHeight(false, false) != 0;
                }
            }
            if (use) {
                WebClient.this.setCurrentWindow(window);
            }
        }

        public void webWindowOpened(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)event.getWebWindow();
                WebClient.this.topLevelWindows_.push(tlw);
            }
        }
    }
}

