/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptFunctionJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptStringJob;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.ClipboardData;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.External;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.OfflineResourceList;
import com.gargoylesoftware.htmlunit.javascript.host.Popup;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.Storage;
import com.gargoylesoftware.htmlunit.javascript.host.StorageList;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLUnknownElement;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends SimpleScriptable
implements ScriptableWithFallbackGetter,
Function {
    private static final long serialVersionUID = -7730298149962810325L;
    private static final Log LOG = LogFactory.getLog(Window.class);
    public static final int WINDOW_WIDTH = 1256;
    public static final int WINDOW_HEIGHT = 605;
    private static final int MIN_TIMER_DELAY = 1;
    private HTMLDocument document_;
    private HTMLDocumentProxy documentProxy_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private WindowProxy windowProxy_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private OfflineResourceList applicationCache_;
    private Selection selection_;
    private Event currentEvent_;
    private String status_ = "";
    private HTMLCollection frames_;
    private Map<Class<? extends SimpleScriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
    private EventListenersContainer eventListenersContainer_;
    private Object controllers_;
    private Object opener_;
    private transient WeakHashMap<Node, ComputedCSSStyleDeclaration> computedStyles_ = new WeakHashMap();

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.computedStyles_ = new WeakHashMap();
    }

    @Override
    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map<Class<? extends SimpleScriptable>, Scriptable> map) {
        this.prototypes_ = map;
    }

    public void jsxFunction_alert(Object message) {
        String stringMessage = Context.toString(message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            LOG.warn("window.alert(\"" + stringMessage + "\") no alert handler installed");
        } else {
            handler.handleAlert(this.document_.getHtmlPage(), stringMessage);
        }
    }

    public String jsxFunction_btoa(String stringToEncode) {
        return new String(Base64.encodeBase64(stringToEncode.getBytes()));
    }

    public String jsxFunction_atob(String encodedData) {
        return new String(Base64.decodeBase64(encodedData.getBytes()));
    }

    public boolean jsxFunction_confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            LOG.warn("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button");
            return true;
        }
        return handler.handleConfirm(this.document_.getHtmlPage(), message);
    }

    public String jsxFunction_prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            LOG.warn("window.prompt(\"" + message + "\") no prompt handler installed");
            return null;
        }
        return handler.handlePrompt(this.document_.getHtmlPage(), message);
    }

    public HTMLDocumentProxy jsxGet_document() {
        return this.documentProxy_;
    }

    public HTMLDocument getDocument() {
        return this.document_;
    }

    public OfflineResourceList jsxGet_applicationCache() {
        return this.applicationCache_;
    }

    public Object jsxGet_event() {
        return this.currentEvent_;
    }

    public Event getCurrentEvent() {
        return this.currentEvent_;
    }

    void setCurrentEvent(Event event) {
        this.currentEvent_ = event;
    }

    public WindowProxy jsxFunction_open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (url != Undefined.instance) {
            urlString = Context.toString(url);
        }
        String windowName = "";
        if (name != Undefined.instance) {
            windowName = Context.toString(name);
        }
        String featuresString = null;
        if (features != Undefined.instance) {
            featuresString = Context.toString(features);
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (replace != Undefined.instance) {
            replaceCurrentEntryInBrowsingHistory = (Boolean)replace;
        }
        if ((webClient = this.webWindow_.getWebClient()).isPopupBlockerEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring window.open() invocation because popups are blocked.");
            }
            return null;
        }
        if ((featuresString != null || replaceCurrentEntryInBrowsingHistory) && LOG.isDebugEnabled()) {
            LOG.debug("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]");
        }
        if (StringUtils.isEmpty(urlString) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return Window.getProxy(webWindow);
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return Window.getProxy(newWebWindow);
    }

    public Popup jsxFunction_createPopup() {
        Popup popup = new Popup();
        popup.setParentScope(this);
        popup.setPrototype(this.getPrototype(Popup.class));
        popup.init(this);
        return popup;
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.length() == 0) {
            return WebClient.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.webWindow_.getEnclosedPage();
            if (page != null && page instanceof HtmlPage) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]", e);
            return null;
        }
    }

    public int jsxFunction_setTimeout(Object code, int timeout, Object language) {
        int id;
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow w = this.getWebWindow();
        Page page = (Page)this.getDomNodeOrNull();
        String description = "window.setTimeout(" + timeout + ")";
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        if (code instanceof String) {
            String s = (String)code;
            JavaScriptStringJob job = new JavaScriptStringJob(timeout, null, description, w, s);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            JavaScriptFunctionJob job = new JavaScriptFunctionJob(timeout, null, description, w, f);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    public void jsxFunction_clearTimeout(int timeoutId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearTimeout(" + timeoutId + ")");
        }
        this.getWebWindow().getJobManager().removeJob(timeoutId);
    }

    public Navigator jsxGet_navigator() {
        return this.navigator_;
    }

    public Navigator jsxGet_clientInformation() {
        return this.navigator_;
    }

    public ClipboardData jsxGet_clipboardData() {
        ClipboardData clipboardData = new ClipboardData();
        clipboardData.setParentScope(this);
        clipboardData.setPrototype(this.getPrototype(clipboardData.getClass()));
        return clipboardData;
    }

    public WindowProxy jsxGet_window() {
        return this.windowProxy_;
    }

    public WindowProxy jsxGet_self() {
        return this.windowProxy_;
    }

    public Storage jsxGet_localStorage() {
        Storage storage = new Storage();
        storage.setParentScope(this);
        storage.setPrototype(this.getPrototype(storage.getClass()));
        storage.setType(Storage.Type.LOCAL_STORAGE);
        return storage;
    }

    public Storage jsxGet_sessionStorage() {
        Storage storage = new Storage();
        storage.setParentScope(this);
        storage.setPrototype(this.getPrototype(storage.getClass()));
        storage.setType(Storage.Type.SESSION_STORAGE);
        return storage;
    }

    public StorageList jsxGet_globalStorage() {
        StorageList list = new StorageList();
        list.setParentScope(this);
        list.setPrototype(this.getPrototype(list.getClass()));
        return list;
    }

    public Location jsxGet_location() {
        return this.location_;
    }

    public void jsxSet_location(String newLocation) throws IOException {
        this.location_.jsxSet_href(newLocation);
    }

    public Screen jsxGet_screen() {
        return this.screen_;
    }

    public History jsxGet_history() {
        return this.history_;
    }

    public External jsxGet_external() {
        External external = new External();
        external.setParentScope(this);
        external.setPrototype(this.getPrototype(external.getClass()));
        return external;
    }

    public void initialize(WebWindow webWindow) {
        WebWindow opener;
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptObject(this);
        this.windowProxy_ = new WindowProxy(this.webWindow_);
        this.document_ = new HTMLDocument();
        this.document_.setParentScope(this);
        this.document_.setPrototype(this.getPrototype(this.document_.getClass()));
        this.document_.setWindow(this);
        if (webWindow.getEnclosedPage() instanceof SgmlPage) {
            SgmlPage page = (SgmlPage)webWindow.getEnclosedPage();
            this.document_.setDomNode(page);
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            page.addDomChangeListener(listener);
            if (page instanceof HtmlPage) {
                ((HtmlPage)page).addHtmlAttributeChangeListener(listener);
            }
        }
        this.documentProxy_ = new HTMLDocumentProxy(this.webWindow_);
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope(this);
        this.navigator_.setPrototype(this.getPrototype(this.navigator_.getClass()));
        this.screen_ = new Screen();
        this.screen_.setParentScope(this);
        this.screen_.setPrototype(this.getPrototype(this.screen_.getClass()));
        this.history_ = new History();
        this.history_.setParentScope(this);
        this.history_.setPrototype(this.getPrototype(this.history_.getClass()));
        this.location_ = new Location();
        this.location_.setParentScope(this);
        this.location_.setPrototype(this.getPrototype(this.location_.getClass()));
        this.location_.initialize(this);
        this.applicationCache_ = new OfflineResourceList();
        this.applicationCache_.setParentScope(this);
        this.applicationCache_.setPrototype(this.getPrototype(this.applicationCache_.getClass()));
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject(this);
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            this.opener_ = opener.getScriptObject();
        }
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.eventListenersContainer_ = null;
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    public WindowProxy jsxGet_top() {
        WebWindow top = this.webWindow_.getTopWindow();
        return Window.getProxy(top);
    }

    public WindowProxy jsxGet_parent() {
        WebWindow parent = this.webWindow_.getParentWindow();
        return Window.getProxy(parent);
    }

    public Object jsxGet_opener() {
        Object opener = this.opener_;
        if (opener instanceof Window) {
            opener = ((Window)opener).windowProxy_;
        }
        return opener;
    }

    public void jsxSet_opener(Object newValue) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_177) && newValue != this.opener_) {
            if (this.opener_ == null || newValue == null || newValue == Context.getUndefinedValue()) {
                newValue = null;
            } else {
                throw Context.reportRuntimeError("Can't set opener!");
            }
        }
        this.opener_ = newValue;
    }

    public Object jsxGet_frameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptObject();
        }
        return null;
    }

    public WindowProxy jsxGet_frames() {
        return this.windowProxy_;
    }

    public int jsxGet_length() {
        return this.getFrames().jsxGet_length();
    }

    private HTMLCollection getFrames() {
        if (this.frames_ == null) {
            String xpath = ".//*[(name() = 'frame' or name() = 'iframe')]";
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = new HTMLCollection(this);
            FrameToWindowTransformer toEnclosedWindow = new FrameToWindowTransformer();
            this.frames_.init(page, ".//*[(name() = 'frame' or name() = 'iframe')]", toEnclosedWindow);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void jsxFunction_focus() {
        this.webWindow_.getWebClient().setCurrentWindow(this.webWindow_);
    }

    public void jsxFunction_blur() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.blur() not implemented");
        }
    }

    public void jsxFunction_close() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof TopLevelWindow) {
            ((TopLevelWindow)webWindow).close();
        } else {
            webWindow.getWebClient().deregisterWebWindow(webWindow);
        }
    }

    public boolean jsxGet_closed() {
        return !this.getWebWindow().getWebClient().getWebWindows().contains(this.getWebWindow());
    }

    public void jsxFunction_moveTo(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveTo() not implemented");
        }
    }

    public void jsxFunction_moveBy(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveBy() not implemented");
        }
    }

    public void jsxFunction_resizeBy(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeBy() not implemented");
        }
    }

    public void jsxFunction_resizeTo(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeTo() not implemented");
        }
    }

    public void jsxFunction_scroll(int x, int y) {
        this.jsxFunction_scrollTo(x, y);
    }

    public void jsxFunction_scrollBy(int x, int y) {
        HTMLElement body = this.document_.jsxGet_body();
        if (body != null) {
            body.jsxSet_scrollLeft(body.jsxGet_scrollLeft() + x);
            body.jsxSet_scrollTop(body.jsxGet_scrollTop() + y);
        }
    }

    public void jsxFunction_scrollByLines(int lines) {
        HTMLElement body = this.document_.jsxGet_body();
        if (body != null) {
            body.jsxSet_scrollTop(body.jsxGet_scrollTop() + 19 * lines);
        }
    }

    public void jsxFunction_scrollByPages(int pages) {
        HTMLElement body = this.document_.jsxGet_body();
        if (body != null) {
            body.jsxSet_scrollTop(body.jsxGet_scrollTop() + 605 * pages);
        }
    }

    public void jsxFunction_scrollTo(int x, int y) {
        HTMLElement body = this.document_.jsxGet_body();
        if (body != null) {
            body.jsxSet_scrollLeft(x);
            body.jsxSet_scrollTop(y);
        }
    }

    public void jsxSet_onload(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("load", newOnload);
    }

    public void jsxSet_onclick(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("click", newOnload);
    }

    public Object jsxGet_onclick() {
        return this.getEventListenersContainer().getEventHandlerProp("click");
    }

    public void jsxSet_ondblclick(Object newHandler) {
        this.getEventListenersContainer().setEventHandlerProp("dblclick", newHandler);
    }

    public Object jsxGet_ondblclick() {
        return this.getEventListenersContainer().getEventHandlerProp("dblclick");
    }

    public Object jsxGet_onload() {
        Object onload = this.getEventListenersContainer().getEventHandlerProp("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            HtmlElement body = page.getBody();
            if (body != null) {
                HTMLBodyElement b = (HTMLBodyElement)body.getScriptObject();
                return b.getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    public EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring(type, 2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.getEventListenersContainer().removeEventListener(StringUtils.substring(type, 2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    public String jsxGet_name() {
        return this.webWindow_.getName();
    }

    public void jsxSet_name(String name) {
        this.webWindow_.setName(name);
    }

    public Object jsxGet_onbeforeunload() {
        return this.getHandlerForJavaScript("beforeunload");
    }

    public void jsxSet_onbeforeunload(Object onbeforeunload) {
        this.setHandlerForJavaScript("beforeunload", onbeforeunload);
    }

    public Object jsxGet_onerror() {
        return this.getHandlerForJavaScript("error");
    }

    public void jsxSet_onerror(Object onerror) {
        this.setHandlerForJavaScript("error", onerror);
    }

    public void triggerOnError(ScriptException e) {
        Object o = this.jsxGet_onerror();
        if (o instanceof Function) {
            Function f = (Function)o;
            String msg = e.getMessage();
            String url = e.getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            int line = e.getFailingLineNumber();
            Object[] args = new Object[]{msg, url, line};
            f.call(Context.getCurrentContext(), this, this, args);
        }
    }

    private Object getHandlerForJavaScript(String eventName) {
        Object handler = this.getEventListenersContainer().getEventHandlerProp(eventName);
        if (handler == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_129)) {
            handler = Scriptable.NOT_FOUND;
        }
        return handler;
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        if (handler instanceof Function) {
            this.getEventListenersContainer().setEventHandlerProp(eventName, handler);
        }
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_130)) {
            throw Context.reportRuntimeError("Window is not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)arg);
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, ((Number)arg).intValue());
            }
        }
        return Context.getUndefinedValue();
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_131)) {
            throw Context.reportRuntimeError("Window is not a function.");
        }
        return null;
    }

    @Override
    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        Object domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            HtmlElement unknownElement;
            HtmlPage page = (HtmlPage)((DomNode)domNode).getPage();
            result = Window.getFrameWindowByName(page, name);
            if (result == NOT_FOUND) {
                List<HtmlElement> elements = page.getElementsByName(name);
                if (elements.size() == 1) {
                    result = this.getScriptableFor(elements.get(0));
                } else if (elements.size() > 1) {
                    result = this.document_.jsxFunction_getElementsByName(name);
                } else {
                    try {
                        Object htmlElement = page.getHtmlElementById(name);
                        result = this.getScriptableFor(htmlElement);
                    }
                    catch (ElementNotFoundException e) {
                        result = NOT_FOUND;
                    }
                }
            }
            if (result instanceof Window) {
                WebWindow webWindow = ((Window)result).getWebWindow();
                result = Window.getProxy(webWindow);
            } else if (result instanceof HTMLUnknownElement && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_132) && (unknownElement = ((HTMLUnknownElement)result).getDomNodeOrDie()).getNodeName().equals("xml")) {
                XMLDocument document = ActiveXObject.buildXMLDocument(this.getWebWindow());
                document.setParentScope(this);
                Iterator<HtmlElement> children = unknownElement.getHtmlElementDescendants().iterator();
                if (children.hasNext()) {
                    HtmlElement root = children.next();
                    document.jsxFunction_loadXML(root.asXml().trim());
                }
                result = document;
            }
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        HTMLCollection frames = this.getFrames();
        if (index >= frames.jsxGet_length()) {
            return Context.getUndefinedValue();
        }
        return frames.jsxFunction_item(index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("eval".equals(name)) {
            Window w = (Window)Window.getTopScope(this.getStartingScope());
            if (w != this) {
                return this.getAssociatedValue("custom_eval");
            }
        } else if ("Option".equals(name)) {
            name = "HTMLOptionElement";
        } else if ("Image".equals(name)) {
            name = "HTMLImageElement";
        }
        return super.get(name, start);
    }

    private static Scriptable getTopScope(Scriptable s) {
        Scriptable top;
        for (top = s; top != null && top.getParentScope() != null; top = top.getParentScope()) {
        }
        return top;
    }

    private static Object getFrameWindowByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    public static WindowProxy getProxy(WebWindow w) {
        return ((Window)w.getScriptObject()).windowProxy_;
    }

    public void jsxFunction_execScript(String script, Object language) {
        String languageStr = Context.toString(language);
        if (language == Undefined.instance || "javascript".equalsIgnoreCase(languageStr) || "jscript".equalsIgnoreCase(languageStr)) {
            this.custom_eval(script);
        } else if ("vbscript".equalsIgnoreCase(languageStr)) {
            LOG.warn("VBScript not supported in Window.execScript().");
        } else {
            throw Context.reportRuntimeError("Invalid class string");
        }
    }

    public Object custom_eval(String scriptCode) {
        Context context = Context.getCurrentContext();
        Script script = context.compileString(scriptCode, "eval body", 0, null);
        return script.exec(context, this);
    }

    public String jsxGet_status() {
        return this.status_;
    }

    public void jsxSet_status(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    public int jsxFunction_setInterval(Object code, int timeout, Object language) {
        int id;
        if (timeout == 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_133)) {
            return this.jsxFunction_setTimeout(code, timeout, language);
        }
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow w = this.getWebWindow();
        Page page = (Page)this.getDomNodeOrNull();
        String description = "window.setInterval(" + timeout + ")";
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        if (code instanceof String) {
            String s = (String)code;
            JavaScriptStringJob job = new JavaScriptStringJob(timeout, timeout, description, w, s);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            JavaScriptFunctionJob job = new JavaScriptFunctionJob(timeout, timeout, description, w, f);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    public void jsxFunction_clearInterval(int intervalID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearInterval(" + intervalID + ")");
        }
        this.getWebWindow().getJobManager().removeJob(intervalID);
    }

    public int jsxGet_innerWidth() {
        return 1256;
    }

    public int jsxGet_outerWidth() {
        return 1264;
    }

    public int jsxGet_innerHeight() {
        return 605;
    }

    public int jsxGet_outerHeight() {
        return 755;
    }

    public void jsxFunction_print() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.print() not implemented");
        }
    }

    public void jsxFunction_captureEvents(String type) {
    }

    public void jsxFunction_CollectGarbage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputedCSSStyleDeclaration jsxFunction_getComputedStyle(HTMLElement element, String pseudo) {
        ComputedCSSStyleDeclaration style;
        WeakHashMap<Node, ComputedCSSStyleDeclaration> weakHashMap = this.computedStyles_;
        synchronized (weakHashMap) {
            style = this.computedStyles_.get(element);
        }
        if (style != null) {
            return style;
        }
        CSSStyleDeclaration original = element.jsxGet_style();
        style = new ComputedCSSStyleDeclaration(original);
        StyleSheetList sheets = this.document_.jsxGet_styleSheets();
        for (int i = 0; i < sheets.jsxGet_length(); ++i) {
            CSSStyleSheet sheet = (CSSStyleSheet)sheets.jsxFunction_item(i);
            if (!sheet.isActive()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("modifyIfNecessary: " + sheet + ", " + style + ", " + element);
            }
            sheet.modifyIfNecessary(style, element);
        }
        WeakHashMap<Node, ComputedCSSStyleDeclaration> weakHashMap2 = this.computedStyles_;
        synchronized (weakHashMap2) {
            this.computedStyles_.put(element, style);
        }
        return style;
    }

    public Selection jsxFunction_getSelection() {
        FrameWindow frameWindow;
        if (this.webWindow_ instanceof FrameWindow && !(frameWindow = (FrameWindow)this.webWindow_).getFrameElement().isDisplayed()) {
            return null;
        }
        return this.getSelection();
    }

    public Selection getSelection() {
        if (this.selection_ == null) {
            this.selection_ = new Selection();
            this.selection_.setParentScope(this);
            this.selection_.setPrototype(this.getPrototype(this.selection_.getClass()));
        }
        return this.selection_;
    }

    public Object jsxFunction_showModalDialog(String url, Object arguments, String features) {
        WebWindow ww = this.getWebWindow();
        WebClient client = ww.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, ww, arguments);
            ScriptableObject jsDialog = (ScriptableObject)dialog.getScriptObject();
            return jsDialog.get("returnValue", (Scriptable)jsDialog);
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public Object jsxFunction_showModelessDialog(String url, Object arguments, String features) {
        WebWindow ww = this.getWebWindow();
        WebClient client = ww.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, ww, arguments);
            Window jsDialog = (Window)dialog.getScriptObject();
            return jsDialog;
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public Object jsxGet_controllers() {
        return this.controllers_;
    }

    public void jsxSet_controllers(Object value) {
        this.controllers_ = value;
    }

    public String jsxFunction_ScriptEngine() {
        return "JScript";
    }

    public int jsxFunction_ScriptEngineBuildVersion() {
        return 12345;
    }

    public int jsxFunction_ScriptEngineMajorVersion() {
        return 5;
    }

    public int jsxFunction_ScriptEngineMinorVersion() {
        return (int)this.getBrowserVersion().getBrowserVersionNumeric();
    }

    public void jsxFunction_stop() {
    }

    public int jsxGet_pageXOffset() {
        return 0;
    }

    public int jsxGet_pageYOffset() {
        return 0;
    }

    public int jsxGet_scrollX() {
        return 0;
    }

    public int jsxGet_scrollY() {
        return 0;
    }

    private static class FrameToWindowTransformer
    implements Transformer,
    Serializable {
        private static final long serialVersionUID = -8504605115217901029L;

        private FrameToWindowTransformer() {
        }

        public Object transform(Object obj) {
            if (obj instanceof BaseFrame) {
                return ((BaseFrame)obj).getEnclosedWindow();
            }
            return ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
        }
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener,
    Serializable {
        private static final long serialVersionUID = -4651000523078926322L;

        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode());
        }

        public void nodeDeleted(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode());
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nodeChanged(DomNode changed) {
            String rel;
            if (changed instanceof HtmlStyle) {
                WeakHashMap weakHashMap = Window.this.computedStyles_;
                synchronized (weakHashMap) {
                    Window.this.computedStyles_.clear();
                }
                return;
            }
            if (changed instanceof HtmlLink && "stylesheet".equals(rel = ((HtmlLink)changed).getRelAttribute().toLowerCase())) {
                WeakHashMap weakHashMap = Window.this.computedStyles_;
                synchronized (weakHashMap) {
                    Window.this.computedStyles_.clear();
                }
                return;
            }
            WeakHashMap weakHashMap = Window.this.computedStyles_;
            synchronized (weakHashMap) {
                Iterator i = Window.this.computedStyles_.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object node = ((Node)entry.getKey()).getDomNodeOrDie();
                    if (changed != node && changed.getParentNode() != ((DomNode)node).getParentNode() && !changed.isAncestorOf((DomNode)node)) continue;
                    i.remove();
                }
            }
        }
    }
}

