/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLFormElement
extends HTMLElement
implements Function {
    private static final long serialVersionUID = -1860993922147246513L;
    private HTMLCollection elements_;

    @Override
    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptObject(this);
    }

    public String jsxGet_name() {
        return this.getHtmlForm().getNameAttribute();
    }

    public void jsxSet_name(String name) {
        WebAssert.notNull("name", name);
        this.getHtmlForm().setNameAttribute(name);
    }

    public HTMLCollection jsxGet_elements() {
        if (this.elements_ == null) {
            final HtmlForm htmlForm = this.getHtmlForm();
            this.elements_ = new HTMLCollection(this){
                private static final long serialVersionUID = -2554743215194459203L;

                @Override
                protected List<Object> computeElements() {
                    List<Object> response = super.computeElements();
                    response.addAll(htmlForm.getLostChildren());
                    return response;
                }

                @Override
                protected Object getWithPreemption(String name) {
                    ArrayList<HtmlElement> matchingElements = new ArrayList<HtmlElement>();
                    for (Object o : this.getElements()) {
                        HtmlElement elt = (HtmlElement)o;
                        if (!HTMLFormElement.this.isAccessibleByIdOrName(elt, name)) continue;
                        matchingElements.add(elt);
                    }
                    if (matchingElements.isEmpty()) {
                        return NOT_FOUND;
                    }
                    if (matchingElements.size() == 1) {
                        return ((HtmlElement)matchingElements.get(0)).getScriptObject();
                    }
                    return new HTMLCollection(htmlForm, matchingElements);
                }
            };
            String xpath = ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]";
            this.elements_.init(htmlForm, ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]");
        }
        return this.elements_;
    }

    public int jsxGet_length() {
        int all = this.jsxGet_elements().jsxGet_length();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    public String jsxGet_action() {
        String action = this.getHtmlForm().getActionAttribute();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_169)) {
            try {
                action = ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return action;
    }

    public void jsxSet_action(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    public String jsxGet_method() {
        return this.getHtmlForm().getMethodAttribute();
    }

    public void jsxSet_method(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    public String jsxGet_target() {
        return this.getHtmlForm().getTargetAttribute();
    }

    public Object jsxGet_onsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    public void jsxSet_onsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    public void jsxSet_target(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    public String jsxGet_encoding() {
        return this.getHtmlForm().getEnctypeAttribute();
    }

    public void jsxSet_encoding(String encoding) {
        WebAssert.notNull("encoding", encoding);
        this.getHtmlForm().setEnctypeAttribute(encoding);
    }

    private HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    public void jsxFunction_submit() throws IOException {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        WebClient webClient = page.getWebClient();
        String action = this.getHtmlForm().getActionAttribute();
        if (action.startsWith("javascript:")) {
            String js = StringUtils.substringAfter(action, "javascript:");
            webClient.getJavaScriptEngine().execute(page, js, "Form action", 0);
        } else {
            WebRequest request = this.getHtmlForm().getWebRequest(null);
            String target = page.getResolvedTarget(this.jsxGet_target());
            webClient.download(page.getEnclosingWindow(), target, request, "JS form.submit()");
        }
    }

    public Object jsxFunction_item(Object index, Object subIndex) {
        if (index instanceof Number) {
            return this.jsxGet_elements().jsxFunction_item(index);
        }
        final HtmlForm htmlForm = this.getHtmlForm();
        HTMLCollection elements = new HTMLCollection(this){
            private static final long serialVersionUID = -2554743215194459203L;

            @Override
            protected List<Object> computeElements() {
                List<Object> response = super.computeElements();
                response.addAll(htmlForm.getLostChildren());
                return response;
            }
        };
        String xpath = ".//*[((name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')) and @name='" + index + "']";
        elements.init(htmlForm, xpath);
        if (elements.getLength() == 0) {
            return null;
        }
        if (elements.getLength() == 1) {
            return elements.jsxFunction_item(0);
        }
        if (subIndex instanceof Number) {
            return elements.jsxFunction_item(subIndex);
        }
        return elements;
    }

    public void jsxFunction_reset() {
        this.getHtmlForm().reset();
    }

    @Override
    protected Object getWithPreemption(final String name) {
        List<HtmlElement> elements = this.findElements(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        HTMLCollection collection = new HTMLCollection(this.getHtmlForm(), elements){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(HTMLFormElement.this.findElements(name));
            }
        };
        return collection;
    }

    private List<HtmlElement> findElements(String name) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        this.addElements(name, this.getHtmlForm().getHtmlElementDescendants(), elements);
        this.addElements(name, this.getHtmlForm().getLostChildren(), elements);
        if (elements.isEmpty()) {
            for (DomNode node : this.getHtmlForm().getChildren()) {
                HtmlImage img;
                if (!(node instanceof HtmlImage) || !name.equals((img = (HtmlImage)node).getId()) && !name.equals(img.getNameAttribute())) continue;
                elements.add(img);
            }
        }
        return elements;
    }

    private void addElements(String name, Iterable<HtmlElement> nodes, List<HtmlElement> addTo) {
        for (HtmlElement node : nodes) {
            if (!this.isAccessibleByIdOrName(node, name)) continue;
            addTo.add(node);
        }
    }

    private boolean isAccessibleByIdOrName(HtmlElement element, String name) {
        if (element instanceof FormFieldWithNameHistory && !(element instanceof HtmlImageInput)) {
            FormFieldWithNameHistory elementWithNames = (FormFieldWithNameHistory)((Object)element);
            if (name.equals(elementWithNames.getOriginalName()) || name.equals(element.getId())) {
                return true;
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_NEW_NAMES)) {
                return false;
            }
            if (name.equals(element.getAttribute("name")) || elementWithNames.getPreviousNames().contains(name)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.jsxGet_elements().get(index, (Scriptable)((HTMLFormElement)start).jsxGet_elements());
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_80)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)arg);
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, ((Number)arg).intValue());
            }
        }
        return Context.getUndefinedValue();
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_81)) {
            throw Context.reportRuntimeError("Not a function.");
        }
        return null;
    }
}

