/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.resin.ResinStandaloneConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public abstract class AbstractResinStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private ConfigurationCapability capability = new ResinStandaloneConfigurationCapability();
    private File resinConf;

    public AbstractResinStandaloneConfiguration(Container container) {
        super(container);
    }

    public AbstractResinStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    public final void setResinConf(File config) {
        this.resinConf = config;
    }

    protected File getResinConf() {
        return this.resinConf;
    }

    protected abstract void prepareAdditions(FilterChain var1) throws IOException;

    protected abstract FilterChain createResinFilterChain();

    public void configure() {
        try {
            this.createConfigurationDir();
            FileUtils fileUtils = FileUtils.newFileUtils();
            FilterChain filterChain = this.createResinFilterChain();
            if (this.getResinConf() != null) {
                fileUtils.copyFile(this.getResinConf(), new File(this.getDir(), "resin.conf"));
            } else {
                this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.getContainer().getId() + "/resin.conf", new File(this.getDir(), "resin.conf"), filterChain);
            }
            File webappsDir = this.getFileUtils().createDirectory(this.getDir(), "webapps");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable instanceof WAR) {
                    if (((WAR)deployable).isExpandedWar()) continue;
                    fileUtils.copyFile(deployable.getFile(), new File(webappsDir, deployable.getFile().getName()), null, true);
                    continue;
                }
                throw new ContainerException("Only WAR archives are supported for deployment in Resin. Got [" + deployable.getFile() + "]");
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
            this.prepareAdditions(filterChain);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " standalone configuration", e);
        }
    }

    protected String createExpandedWarTokenValue(String dirAttribute) {
        StringBuffer expandedWarValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (!(deployable instanceof WAR) || !((WAR)deployable).isExpandedWar()) continue;
            File tmp = new File(this.getDir(), "tmp/" + ((WAR)deployable).getContext());
            File work = new File(this.getDir(), "work/" + ((WAR)deployable).getContext());
            expandedWarValue.append("<web-app id='");
            expandedWarValue.append(((WAR)deployable).getContext());
            expandedWarValue.append("' " + dirAttribute + "='");
            expandedWarValue.append(((WAR)deployable).getFile());
            expandedWarValue.append("'><temp-dir>");
            expandedWarValue.append(tmp.getPath());
            expandedWarValue.append("</temp-dir><work-dir>");
            expandedWarValue.append(work.getPath());
            expandedWarValue.append("</work-dir></web-app>");
        }
        return expandedWarValue.toString();
    }

    protected String getSecurityToken(String prefix, String suffix) {
        StringBuffer token = new StringBuffer(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            Iterator users = User.parseUsers(this.getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                token.append(prefix);
                token.append(user.getName());
                token.append(':');
                token.append(user.getPassword());
                token.append(':');
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    token.append(role);
                    if (!roles.hasNext()) continue;
                    token.append(',');
                }
                token.append(suffix);
            }
        }
        return token.toString();
    }
}

