/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.orion.OrionStandaloneConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public class OrionStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private ConfigurationCapability capability = new OrionStandaloneConfigurationCapability();

    public OrionStandaloneConfiguration(Container container) {
        super(container);
    }

    public OrionStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    public void configure() {
        try {
            this.createConfigurationDir();
            FileUtils fileUtils = FileUtils.newFileUtils();
            FilterChain filterChain = this.createOrionFilterChain();
            File confDir = this.getFileUtils().createDirectory(this.getDir(), "conf");
            String resourcePath = "/org/codehaus/cargo/container/internal/resources/orion1x2x";
            this.getResourceUtils().copyResource(resourcePath + "/server.xml", new File(confDir, "server.xml"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/application.xml", new File(confDir, "application.xml"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/default-web-site.xml", new File(confDir, "default-web-site.xml"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/global-web-application.xml", new File(confDir, "global-web-application.xml"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/mime.types", new File(confDir, "mime.types"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/principals.xml", new File(confDir, "principals.xml"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/rmi.xml", new File(confDir, "rmi.xml"), filterChain);
            File defaultWebAppDir = this.getFileUtils().createDirectory(this.getDir(), "default-web-app/WEB-INF");
            this.getResourceUtils().copyResource(resourcePath + "/web.xml", new File(defaultWebAppDir, "web.xml"), filterChain);
            this.getFileUtils().createDirectory(this.getDir(), "persistence");
            File appDir = this.getFileUtils().createDirectory(this.getDir(), "applications");
            this.getFileUtils().createDirectory(this.getDir(), "application-deployments");
            this.getFileUtils().createDirectory(this.getDir(), "log");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable instanceof WAR && (!(deployable instanceof WAR) || ((WAR)deployable).isExpandedWar())) continue;
                fileUtils.copyFile(deployable.getFile(), new File(appDir, deployable.getFile().getName()), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create an " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private FilterChain createOrionFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.orion.rmi.port", this.getPropertyValue("cargo.orion.rmi.port"));
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.users", this.getUserToken());
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.roles", this.getRoleToken());
        }
        ReplaceTokens.Token tokenApplications = new ReplaceTokens.Token();
        tokenApplications.setKey("orion.application");
        ReplaceTokens.Token tokenWebModules = new ReplaceTokens.Token();
        tokenWebModules.setKey("orion.web-module");
        ReplaceTokens.Token tokenWebApps = new ReplaceTokens.Token();
        tokenWebApps.setKey("orion.web-app");
        StringBuffer keyApplications = new StringBuffer(" ");
        StringBuffer keyWebModules = new StringBuffer(" ");
        StringBuffer keyWebApps = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable instanceof EAR) {
                keyApplications.append("  <application name=\"");
                keyApplications.append(((EAR)deployable).getName());
                keyApplications.append("\" path=\"../applications/");
                keyApplications.append(deployable.getFile().getName());
                keyApplications.append("\"/>");
                Iterator itContexts = ((EAR)deployable).getWebContexts();
                while (itContexts.hasNext()) {
                    String webContext = (String)itContexts.next();
                    keyWebApps.append("<web-app application=\"");
                    keyWebApps.append(((EAR)deployable).getName());
                    keyWebApps.append("\" name=\"");
                    String name = ((EAR)deployable).getWebUri(webContext);
                    int warIndex = name.toLowerCase().lastIndexOf(".war");
                    if (warIndex >= 0) {
                        name = name.substring(0, warIndex);
                    }
                    keyWebApps.append(name);
                    keyWebApps.append("\" root=\"/");
                    keyWebApps.append(webContext);
                    keyWebApps.append("\"/>");
                }
                continue;
            }
            if (!(deployable instanceof WAR)) continue;
            keyWebModules.append("  <web-module id=\"");
            keyWebModules.append(((WAR)deployable).getContext());
            if (((WAR)deployable).isExpandedWar()) {
                keyWebModules.append("\" path=\"");
                keyWebModules.append(deployable.getFile());
            } else {
                keyWebModules.append("\" path=\"../applications/");
                keyWebModules.append(deployable.getFile().getName());
            }
            keyWebModules.append("\"/>");
            keyWebApps.append("<web-app application=\"default\" name=\"");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\" root=\"/");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\"/>");
        }
        tokenApplications.setValue(keyApplications.toString());
        tokenWebModules.setValue(keyWebModules.toString());
        tokenWebApps.setValue(keyWebApps.toString());
        ReplaceTokens replaceApplications = new ReplaceTokens();
        replaceApplications.addConfiguredToken(tokenApplications);
        filterChain.addReplaceTokens(replaceApplications);
        ReplaceTokens replaceWebModules = new ReplaceTokens();
        replaceWebModules.addConfiguredToken(tokenWebModules);
        filterChain.addReplaceTokens(replaceWebModules);
        ReplaceTokens replaceWebApps = new ReplaceTokens();
        replaceWebApps.addConfiguredToken(tokenWebApps);
        filterChain.addReplaceTokens(replaceWebApps);
        return filterChain;
    }

    protected String getUserToken() {
        StringBuffer token = new StringBuffer(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            Iterator users = User.parseUsers(this.getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                token.append("<user deactivated=\"false\" ");
                token.append("username=\"" + user.getName() + "\" ");
                token.append("password=\"" + user.getPassword() + "\"");
                token.append("/>");
            }
        }
        return token.toString();
    }

    protected String getRoleToken() {
        StringBuffer token = new StringBuffer(" ");
        List users = User.parseUsers(this.getPropertyValue("cargo.servlet.users"));
        Map roles = User.createRoleMap(users);
        Iterator roleIt = roles.keySet().iterator();
        while (roleIt.hasNext()) {
            String role = (String)roleIt.next();
            token.append("<security-role-mapping ");
            token.append("name=\"" + role + "\">");
            Iterator userIt = ((List)roles.get(role)).iterator();
            while (userIt.hasNext()) {
                User user = (User)userIt.next();
                token.append("<user name=\"" + user.getName() + "\"/>");
            }
            token.append("</security-role-mapping>");
        }
        return token.toString();
    }
}

