/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.ContainerConfiguration;

public abstract class AbstractWebLogicContainer
extends AbstractContainer {
    private File beaHome;
    private ContainerCapability capability = new J2EEContainerCapability();

    public final void setBeaHome(File beaHome) {
        this.beaHome = beaHome;
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void initBeaHome() {
        if (!this.getHomeDir().isDirectory()) {
            throw new ContainerException(this.getHomeDir() + " is not a directory");
        }
        if (this.beaHome == null) {
            this.beaHome = this.getHomeDir().getParentFile();
        }
    }

    public final void doStart(Java java) throws Exception {
        ContainerConfiguration wlConfiguration = (ContainerConfiguration)this.getConfiguration();
        this.verify(wlConfiguration);
        wlConfiguration.configure();
        java.setDir(new File(this.getConfiguration().getDir(), "domain"));
        java.createJvmarg().setValue("-hotspot");
        java.createJvmarg().setValue("-Xms32m");
        java.createJvmarg().setValue("-Xmx200m");
        File serverDir = new File(this.getHomeDir(), "server");
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.name", "server"));
        java.addSysproperty(this.getAntUtils().createSysProperty("bea.home", this.beaHome));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.username", "weblogic"));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.password", "weblogic"));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.security.policy", "=./server/lib/weblogic.policy"));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        java.setClassname("weblogic.Server");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }

    public final void doStop(Java java) throws Exception {
        File serverDir = new File(this.getHomeDir(), "server");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        java.setClassname("weblogic.Admin");
        java.createArg().setValue("-url");
        java.createArg().setValue("t3://localhost:" + this.getConfiguration().getPropertyValue("cargo.servlet.port"));
        java.createArg().setValue("-username");
        java.createArg().setValue("weblogic");
        java.createArg().setValue("-password");
        java.createArg().setValue("weblogic");
        java.createArg().setValue("FORCESHUTDOWN");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }

    public void verify(ContainerConfiguration configuration) {
        this.initBeaHome();
        this.verifyHomeDir();
        configuration.verifyProperties();
    }
}

