/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.WebResponse;

public class FaceletsErrorPageException
extends RuntimeException {
    private static final String HEADER = "\r\n----- EXTRACTED FROM FACELETS ERROR PAGE -------\r\n";
    private static final String FOOTER = "\r\n------END FACELETS ERROR PAGE ------------------\r\n";
    private static final String STACK_TRACE_BEGIN = "<div id=\"trace\" class=\"grayBox\"><pre><code>";
    private static final String STACK_TRACE_END = "</code></pre></div>";
    private static final String TRACE_OFF = "span id=\"traceOff\"";
    private static final String TRACE_ON = "span id=\"traceOn\"";
    private static final String TREE_OFF = "span id=\"treeOff\"";
    private static final String TREE_ON = "span id=\"treeOn\"";

    public static boolean isFaceletsErrorPage(WebResponse response) {
        if (response == null) {
            return false;
        }
        String responseBody = response.getContentAsString();
        if (responseBody == null) {
            return false;
        }
        return response.getContentType().equals("text/html") && responseBody.contains(TRACE_OFF) && responseBody.contains(TRACE_ON) && responseBody.contains(TREE_OFF) && responseBody.contains(TREE_ON) && (responseBody.contains("Generated by Facelets") || responseBody.contains("Generated by Mojarra/Facelets"));
    }

    FaceletsErrorPageException(WebResponse response) {
        super(FaceletsErrorPageException.extractStackTrace(response));
    }

    private static String extractStackTrace(WebResponse response) {
        String responseBody = new String(response.getContentAsBytes());
        int beginning = responseBody.indexOf(STACK_TRACE_BEGIN) + STACK_TRACE_BEGIN.length();
        int ending = responseBody.indexOf(STACK_TRACE_END, beginning);
        return HEADER + responseBody.substring(beginning, ending) + FOOTER;
    }
}

